require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_VAX_PARAM_H_)) {
    eval 'sub _VAX_PARAM_H_ () {1;}' unless defined(&_VAX_PARAM_H_);
    eval 'sub _MACHINE () { &vax;}' unless defined(&_MACHINE);
    eval 'sub MACHINE () {"vax";}' unless defined(&MACHINE);
    eval 'sub _MACHINE_ARCH () { &vax;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"vax";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_VAX;}' unless defined(&MID_MACHINE);
    eval 'sub ALIGNBYTES () {($sizeof{\'int\'} - 1);}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        local($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        local($p,$t) = @_;
	    eval q((((($p)) & ($sizeof{$t}-1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub PGSHIFT () {12;}' unless defined(&PGSHIFT);
    eval 'sub NBPG () {(1<<  &PGSHIFT);}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG - 1);}' unless defined(&PGOFSET);
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub VAX_PGSHIFT () {9;}' unless defined(&VAX_PGSHIFT);
    eval 'sub VAX_NBPG () {(1<<  &VAX_PGSHIFT);}' unless defined(&VAX_NBPG);
    eval 'sub VAX_PGOFSET () {( &VAX_NBPG - 1);}' unless defined(&VAX_PGOFSET);
    eval 'sub VAX_NPTEPG () {( &VAX_NBPG / 4);}' unless defined(&VAX_NPTEPG);
    eval 'sub KERNBASE () {0x80000000;}' unless defined(&KERNBASE);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub MAXBSIZE () {0x4000;}' unless defined(&MAXBSIZE);
    eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
    eval 'sub USPACE () {( &NBPG* &UPAGES);}' unless defined(&USPACE);
    eval 'sub REDZONEADDR () {( &VAX_NBPG*3);}' unless defined(&REDZONEADDR);
    unless(defined(&MSGBUFSIZE)) {
	eval 'sub MSGBUFSIZE () {8192;}' unless defined(&MSGBUFSIZE);
    }
    unless(defined(&MSIZE)) {
	eval 'sub MSIZE () {256;}' unless defined(&MSIZE);
    }
    unless(defined(&MCLSHIFT)) {
	eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    }
    eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
    eval 'sub MCLOFSET () {( &MCLBYTES - 1);}' unless defined(&MCLOFSET);
    unless(defined(&NMBCLUSTERS)) {
	if(defined(&GATEWAY)) {
	    eval 'sub NMBCLUSTERS () {512;}' unless defined(&NMBCLUSTERS);
	} else {
	    eval 'sub NMBCLUSTERS () {256;}' unless defined(&NMBCLUSTERS);
	}
    }
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    eval 'sub ctod {
        local($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        local($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub ctob {
        local($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&ctob);
    eval 'sub btoc {
        local($x) = @_;
	    eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }' unless defined(&btoc);
    eval 'sub btop {
        local($x) = @_;
	    eval q(((($x)) >>  &PGSHIFT));
    }' unless defined(&btop);
    eval 'sub btodb {
        local($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        local($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub vax_btoc {
        local($x) = @_;
	    eval q(((($x) +  &VAX_PGOFSET) >>  &VAX_PGSHIFT));
    }' unless defined(&vax_btoc);
    eval 'sub vax_btop {
        local($x) = @_;
	    eval q(((($x)) >>  &VAX_PGSHIFT));
    }' unless defined(&vax_btop);
    eval 'sub bdbtofsb {
        local($bn) = @_;
	    eval q((($bn) / ( &BLKDEV_IOSIZE/ &DEV_BSIZE)));
    }' unless defined(&bdbtofsb);
    eval 'sub ovbcopy {
        local($x,$y,$z) = @_;
	    eval q( &bcopy($x, $y, $z));
    }' unless defined(&ovbcopy);
    if(defined(&_KERNEL)) {
	eval 'sub splassert {
	    local($wantipl) = @_;
    	    eval q();
	}' unless defined(&splassert);
	unless(defined(&lint)) {
	    eval 'sub splx {
	        local($reg) = @_;
    		eval q(({  &register \'int\'  &val;  &__asm  &__volatile (\\"mfpr $0x12,%0;mtpr %1,$0x12\\" : \\"=&g\\" ( &val) : \\"g\\" ($reg));  &val; }));
	    }' unless defined(&splx);
	    eval 'sub _splraise {
	        local($reg) = @_;
    		eval q(({  &register \'int\'  &val;  &__asm  &__volatile (\\"mfpr $0x12,%0\\" : \\"=&g\\" ( &val) : );  &if (($reg) >  &val) {  &__asm  &__volatile (\\"mtpr %0,$0x12\\" : : \\"g\\" ($reg)); }  &val; }));
	    }' unless defined(&_splraise);
	}
	eval 'sub spl0 () {
	    eval q( &splx(0));
	}' unless defined(&spl0);
	eval 'sub spllowersoftclock () {
	    eval q( &splx(8));
	}' unless defined(&spllowersoftclock);
	eval 'sub splsoftclock () {
	    eval q( &_splraise(8));
	}' unless defined(&splsoftclock);
	eval 'sub splsoftnet () {
	    eval q( &_splraise(0xc));
	}' unless defined(&splsoftnet);
	eval 'sub splddb () {
	    eval q( &_splraise(0xf));
	}' unless defined(&splddb);
	eval 'sub splbio () {
	    eval q( &_splraise(0x15));
	}' unless defined(&splbio);
	eval 'sub splnet () {
	    eval q( &_splraise(0x15));
	}' unless defined(&splnet);
	eval 'sub spltty () {
	    eval q( &_splraise(0x15));
	}' unless defined(&spltty);
	eval 'sub splimp () {
	    eval q( &_splraise(0x17));
	}' unless defined(&splimp);
	eval 'sub splvm () {
	    eval q( &_splraise(0x17));
	}' unless defined(&splvm);
	eval 'sub splclock () {
	    eval q( &_splraise(0x18));
	}' unless defined(&splclock);
	eval 'sub splhigh () {
	    eval q( &_splraise(0x1f));
	}' unless defined(&splhigh);
	eval 'sub splstatclock () {
	    eval q( &splclock());
	}' unless defined(&splstatclock);
	eval 'sub spl4 () {
	    eval q( &splx(0x14));
	}' unless defined(&spl4);
	eval 'sub spl5 () {
	    eval q( &splx(0x15));
	}' unless defined(&spl5);
	eval 'sub spl6 () {
	    eval q( &splx(0x16));
	}' unless defined(&spl6);
	eval 'sub spl7 () {
	    eval q( &splx(0x17));
	}' unless defined(&spl7);
	unless(defined(&_LOCORE)) {
	    require 'machine/cpu.ph';
	    require 'machine/macros.ph';
	}
	eval 'sub DELAY {
	    local($x) = @_;
    	    eval q( &delay($x));
	}' unless defined(&DELAY);
    }
}
1;
