require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&OOSIOP_NTGT)) {
    sub OOSIOP_NTGT () {	8;}
}
unless(defined(&OOSIOP_NCB)) {
    sub OOSIOP_NCB () {	32;}
}
unless(defined(&OOSIOP_NSG)) {
    sub OOSIOP_NSG () {	( &MIN( &btoc( &MAXPHYS) + 1, 32));}
}
unless(defined(&OOSIOP_MAX_XFER)) {
    sub OOSIOP_MAX_XFER () {	 &ctob( &OOSIOP_NSG - 1);}
}
unless(defined(&SCSI_OOSIOP_NOSTATUS)) {
    sub SCSI_OOSIOP_NOSTATUS () {	0xff;}
}
unless(defined(&OOSIOP_XFEROFF)) {
    sub OOSIOP_XFEROFF {
	local($x) = @_;
	eval q( &offsetof('struct oosiop_xfer', $x));
    }
}
unless(defined(&OOSIOP_DINSCROFF)) {
    sub OOSIOP_DINSCROFF () {	 &OOSIOP_XFEROFF( $datain_scr[0]);}
}
unless(defined(&OOSIOP_DOUTSCROFF)) {
    sub OOSIOP_DOUTSCROFF () {	 &OOSIOP_XFEROFF( $dataout_scr[0]);}
}
unless(defined(&OOSIOP_MSGINOFF)) {
    sub OOSIOP_MSGINOFF () {	 &OOSIOP_XFEROFF( $msgin[0]);}
}
unless(defined(&OOSIOP_MSGOUTOFF)) {
    sub OOSIOP_MSGOUTOFF () {	 &OOSIOP_XFEROFF( $msgout[0]);}
}
unless(defined(&OOSIOP_XFERSCR_SYNC)) {
    sub OOSIOP_XFERSCR_SYNC {
	local($sc, $cb, $ops) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($cb)-> &xferdma,  &OOSIOP_DINSCROFF,  &OOSIOP_MSGINOFF -  &OOSIOP_DINSCROFF, ($ops)));
    }
}
unless(defined(&OOSIOP_DINSCR_SYNC)) {
    sub OOSIOP_DINSCR_SYNC {
	local($sc, $cb, $ops) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($cb)-> &xferdma,  &OOSIOP_DINSCROFF,  &OOSIOP_DOUTSCROFF -  &OOSIOP_DINSCROFF, ($ops)));
    }
}
unless(defined(&OOSIOP_DOUTSCR_SYNC)) {
    sub OOSIOP_DOUTSCR_SYNC {
	local($sc, $cb, $ops) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($cb)-> &xferdma,  &OOSIOP_DOUTSCROFF,  &OOSIOP_MSGINOFF -  &OOSIOP_DOUTSCROFF, ($ops)));
    }
}
unless(defined(&OOSIOP_XFERMSG_SYNC)) {
    sub OOSIOP_XFERMSG_SYNC {
	local($sc, $cb, $ops) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($cb)-> &xferdma,  &OOSIOP_MSGINOFF, $sizeof{'struct oosiop_xfer'} -  &OOSIOP_MSGINOFF, ($ops)));
    }
}
unless(defined(&OOSIOP_SCRIPT_SYNC)) {
    sub OOSIOP_SCRIPT_SYNC {
	local($sc, $ops) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &sc_scrdma, 0, $sizeof{ &oosiop_script}, ($ops)));
    }
}
unless(defined(&CBF_SELTOUT)) {
    sub CBF_SELTOUT () {	0x1;}
}
unless(defined(&CBF_TIMEOUT)) {
    sub CBF_TIMEOUT () {	0x2;}
}
unless(defined(&CBF_AUTOSENSE)) {
    sub CBF_AUTOSENSE () {	0x4;}
}
unless(defined(&TGTF_SYNCNEG)) {
    sub TGTF_SYNCNEG () {	0x1;}
}
unless(defined(&TGTF_WAITSDTR)) {
    sub TGTF_WAITSDTR () {	0x2;}
}
unless(defined(&OOSIOP_700)) {
    sub OOSIOP_700 () {	0;}
}
unless(defined(&OOSIOP_700_66)) {
    sub OOSIOP_700_66 () {	1;}
}
unless(defined(&oosiop_read_1)) {
    sub oosiop_read_1 {
	local($sc, $addr) = @_;
	eval q( &bus_space_read_1(($sc)-> &sc_bst, ($sc)-> &sc_bsh, ($addr)));
    }
}
unless(defined(&oosiop_write_1)) {
    sub oosiop_write_1 {
	local($sc, $addr, $data) = @_;
	eval q( &bus_space_write_1(($sc)-> &sc_bst, ($sc)-> &sc_bsh, ($addr), ($data)));
    }
}
unless(defined(&oosiop_read_4)) {
    sub oosiop_read_4 {
	local($sc, $addr) = @_;
	eval q( &letoh32( &bus_space_read_4(($sc)-> &sc_bst, ($sc)-> &sc_bsh, ($addr))));
    }
}
unless(defined(&oosiop_write_4)) {
    sub oosiop_write_4 {
	local($sc, $addr, $data) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bst, ($sc)-> &sc_bsh, ($addr),  &htole32($data)));
    }
}
1;
