package VppGateway;
use strict;
require Exporter;
my @ISA = qw(Exporter);
my @EXPORT = qw(GetPaperSize);

sub GetPaperSize ($) {
   my $ps_file = shift;
   my $Pages=0;
   my $Size=0;
   my $vpp_options;
   my $PageSize;
   my $Duplex;
   my $MediaType;
   my $size_flag;    # A3/A4
   my $duplex_flag;  # duplex/shortbind or nothing
   my $title_flag;   # name of the document
   my $media_flag;   # white/foil or nothing
   my $FlagPage;    # flag/noflag
   open PSFILE,"$ps_file" or die "could not open $ps_file";
   while (<PSFILE>) {
      /^%%Page:/ && $Pages++;
      $Size += length($_);
      
      ####
      # DON'T ENTER HERE IF WE ALREADY FOUND THE PAGESIZE
      unless ($size_flag) {
	 #########
      	 # Check Size the microsoft way
      	 # %%BeginFeature: *PageSize A3
	 if ($_ =~ /%%BeginFeature:\s+\*PageSize(.*)/) {
      	   for ($1) {
      	       if     (/Letter/) { $PageSize="Letter"}
      	       elsif  (/A4/) { $PageSize="A4"}
      	       elsif  (/A3/) { $PageSize="A3"}
      	       elsif  (/A5/) { $PageSize="A5"}
      	    }
      	    if ($PageSize) {$size_flag="BeginFeature"} 
      	 }
      	 ##########
      	 # Check Size the classic way
	 # without BeginFeature
      	 elsif ($_ =~ /PageSize\s+(.*)/) {
      	    for ($1) {
      	       if 	   (/\[612\s+792\]/) { $PageSize="Letter"}
      	       elsif  (/\[595\s+842\]/) { $PageSize="A4"}
      	       elsif  (/\[842\s+1191\]/) { $PageSize="A3"}
      	       elsif  (/\[420\s+595\]/) { $PageSize="A5"}
      	    }
      	    if ($PageSize) {$size_flag="PageSize"}
      	 }
      	 #########
      	 # Check Size the DSC way
      	 elsif ($_ =~ /%%DocumentMedia:\s+(.*)/) {
      	   for ($1) {
      	       if     (/Letter/) { $PageSize="Letter"}
      	       elsif  (/A4/) { $PageSize="A4"}
      	       elsif  (/A3/) { $PageSize="A3"}
      	       elsif  (/A5/) { $PageSize="A5"}
      	    }
      	    if ($PageSize) {$size_flag="DocumentMedia"} 
      	 }
      }
      ####
      # Don't enter here if we already know that duplex 
      unless ($duplex_flag) {
	 if ($_ =~ /%%BeginFeature:\s+\*Duplex(.*)/) {
	   for ($1) {
               if     (/NoTumble/) { $Duplex="duplex"}
               elsif  (/Tumble/) { $Duplex="shortbind"}
               elsif  (/None/) { $duplex_flag="simple"}
           } 
	   if ($Duplex) {$duplex_flag="dobble"}
	   else {$Duplex=$duplex_flag}
	 }
      }
      ####
      # Don't enter here if we know Documenttitle 
      unless ($title_flag) {
	 if ($_ =~ /%%Title:\s+(.*)\s*/) {
         $title_flag = $1;
	 $title_flag =~ s/\r//g;
	 } 
      }
     
      ####
      # Don't enter here if we already know that FLAG 
      unless ($FlagPage) {
	 if ($_ =~ /%%BeginFeature:\s+\*FlagPage(.*)/) {
	   for ($1) {
               if     (/False/) { $FlagPage="noflag"}
               elsif  (/True/) { $FlagPage="flag"}
           } 
	 }
      }
      ####
      # Don't enter here if we already know that white or foil
      unless ($media_flag) {
	 ##########
	 # Check if the Mediatype is defined over 'MediaType'
	 # PPD mainword
      	 if ($_ =~ /%%BeginFeature:\s+\*MediaType(.*)/) {
	   for ($1) {
               if     (/Recycled/) { $MediaType="none"}
               elsif  (/Plain/) { $MediaType="white"}
               elsif  (/Transparency/) { $MediaType="foil"}
               elsif  (/None/) { $MediaType="none"}
           } 
	   if ($MediaType eq "none") {
	       $media_flag="mediatype";
	       $MediaType = undef;
	   }
	   else {$media_flag="mediatype"}
	 }
         ##########
         # Check if Mediatype is defined over InputSlot 
         # 
         elsif ($_ =~ /%%BeginFeature:\s+\*InputSlot(.*)/) {
            for ($1) {
               if     (/Recycled/) { $MediaType="none"}
               elsif  (/Plain/) { $MediaType="white"}
               elsif  (/Transparency/) { $MediaType="foil"}
               elsif  (/None/) { $MediaType="none"}
            }
	    if ($MediaType eq "none") {
	       $media_flag="inputslot";
	       $MediaType = undef;
	    }
	    else {$media_flag="inputslot"}
         }
      }
   }
   close PSFILE;
   my $vpp_args;
   $vpp_args->{"PageSize"} = $PageSize;
   $vpp_args->{"Duplex"} = $Duplex;
   $vpp_args->{"MediaType"} = $MediaType;
   $vpp_args->{"Title"} = $title_flag;
   $vpp_args->{"FlagPage"} = $FlagPage;
   $vpp_args->{"Pages"} = $Pages;
   $vpp_args->{"Size"} = $Size;
   return $vpp_args;
   #return "Size=$PageSize, size_flag=$size_flag, Duplex=$Duplex, duplex_flag=$duplex_flag, Size=$Size, Pages=$Pages, Flagpage=$FlagPage";
   
}
1;

__END__
=head1 NAME

ISG::VppGateway - Extracts VPP arguments of a PS-file 

=head1 SYNOPSIS

 use ISG::VppGateway;

 my $vpp_args = VppGateway::GetPaperSize($ps_file);

 $vpp_args->{"PageSize"}     # A4/A3
 $vpp_args->{"Duplex"} 	     # simple, duplex, shorbind	
 $vpp_args->{"MediaType"}    # foil, white 
 $vpp_args->{"Title"}	     # name of the PS file 
 $vpp_args->{"FlagPage"}     # nofl/flag
 $vpp_args->{"Pages"}	     # number of pages of PS file
 $vpp_args->{"Size"}	     # Size in bytes


=head1 DESCRIPTION

VppGateway parses a PS file and extracts information that can be passed as arguments to
a vpp print command.
