<?php
// $Horde: kronolith/lib/DayView.php,v 1.77.2.3 2002/05/17 22:58:15 jan Exp $

/**
 * The Kronolith_DayView:: class provides an API for viewing days.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>, Jan Schneider <jan@ammma.de>
 * @version $Revision: 1.77.2.3 $
 * @since   Kronolith 0.1
 * @package kronolith
 */
class Kronolith_DayView {

    var $Day;
    var $event_arr;
    var $parsed = false;

    function Kronolith_DayView ($month = null, $day = null, $year = null, $timestamp = null) {
        include_once KRONOLITH_BASE . '/lib/Day.php';
        $this->Day = new Kronolith_Day($month, $day, $year, $timestamp);
        $this->event_arr = Kronolith::getEvents($this->Day);
    }

    function isAllDay($event)
    {
        return ($event->start->hour == 0 && $event->start->min == 0 && $event->start->sec == 0 &&
                $event->end->hour == 0 && $event->end->min == 0 && $event->start->sec == 0 &&
                ($event->end->mday > $event->start->mday ||
                 $event->end->month > $event->start->month ||
                 $event->end->year > $event->start->year));

        foreach ($event_arr[$i] as $key) {
            $event = &$this->event_arr[$key];
            if (!($event->start->hour == 0 && $event->end->hour == 0 &&
                  $event->start->min == 0 && $event->end->min == 0 &&
                  $event->start->sec == 0 && $event->end->sec == 0)) {
                return false;
            }
        }

        $event->startTimestamp += 30 * 60;

        return true;
    }

    function html($template_path = './templates')
    {
        global $prefs;

        if (!$this->parsed) {
            $this->parse();
        }

        $hours = $this->Day->hours;
        $started = false;
        $first_row = true;
        $color = 0;

        include $template_path . '/day/head.inc';

        if (count($this->all_day_events) > 0) {
            $rowspan = ' rowspan="' . count($this->all_day_events) . '"';
        } else {
            $rowspan = '';
        }
        $addeventurl = Horde::link(Horde::applicationUrl('addevent.php?timestamp=' . $hours[0]['timestamp'] . '&allday=1&url=' . urlencode($_SERVER['REQUEST_URI'])), _("Create a New Event")) . _("All day") . '</a>';
        foreach ($this->all_day_events as $key => $event) {
            $row = '<td class="eventbox' . ($color % 7) . '" valign="top" colspan="' . $this->span . '">';
            $row .= $event->getLink($this->Day->getStamp());
            $row .= '</td>' . "\n";
            $color++;
            include $template_path . '/day/all_day.inc';
            $first_row = false;
        }
        if ($first_row) {
            $row = '<td colspan="' . $this->span . '">&nbsp;</td>';
            include $template_path . '/day/all_day.inc';
        }

        $first_row = true;
        for ($i = 0; $i < 48; $i++) {
            if ($i >= $prefs->getValue('day_hour_end') && $i > $this->last) {
                break;
            }
            if (!$started
                && $i < $prefs->getValue('day_hour_start')
                && count($this->event_matrix[$i]) == 0) {
                continue;
            }

            $started = true;
            $row = '';
            $hspan = 0;
            $time = date(($prefs->getValue('twentyFour')) ? 'G:i' : 'g:ia', $hours[$i]['timestamp']);
            $style = ((($prefs->getValue('half')) ? $i : floor($i/2)) % 2) ? 'item1' : 'item0';

            foreach ($this->event_matrix[$i] as $key) {
                $event = $this->event_arr[$key];
                $start = mktime(floor($i/2), ($i % 2) * 30, 0, $this->Day->month, $this->Day->mday, $this->Day->year);
                $span = $this->span - $event->overlap + 1;
                if ($event->startTimestamp < $start + 60 * 30 && $event->endTimestamp > $start) {
                    $hspan += $span;
                }
                if ($event->startTimestamp >= $start && $event->startTimestamp < $start + 60 * 30 || $start == $this->Day->getStamp()) {
                    $row .= '<td class="eventbox' . ($color % 7) . '" valign="top" width="' . round(100 * ($span / $this->span)) . '%" colspan="' . $span . '" rowspan="' . $event->rowspan . '">';
                    $row .= $event->getLink($this->Day->getStamp());
                    $row .= '</td>' . "\n";
                    $color++;
                }
            }

            $diff = $this->span - $hspan;
            if ($diff > 0) {
                $row .= '<td width="' . round(100 * ($diff / $this->span)) . '%" colspan="' . $diff . '" class="' . $style . '">&nbsp;</td>' . "\n";
            }

            $addeventurl = Horde::link(Horde::applicationUrl('addevent.php?timestamp=' . $hours[$i]['timestamp'] . '&url=' . urlencode($_SERVER['REQUEST_URI'])), _("Create a New Event"));
            if ($prefs->getValue('half')) {
                $rowspan = false;
                include $template_path . '/day/row.inc';
            } else {
                $rowspan = true;
                if ($i % 2) {
                    include $template_path . '/day/row_half.inc';
                } else {
                    include $template_path . '/day/row.inc';
                }
            }

            $first_row = false;
        }
        include $template_path . '/day/foot.inc';
    }

    // This function runs through the events and tries to figure out
    // what should be on each line of the outputted table. This could
    // get complex...
    function parse()
    {
        global $prefs;

        $this->all_day_events = $tmp = array();
        foreach ($this->event_arr as $key => $event) {
            if ($this->isAllDay($event)) {
                $this->all_day_events[] = $event;
            } else {
                if (!$event->hasRecurType(KRONOLITH_RECUR_NONE)) {
                    $event->start->mday = $this->Day->mday;
                    $event->start->month = $this->Day->month;
                    $event->start->year = $this->Day->year;
                    $event->setStartTimestamp(Kronolith::objectToTimestamp($event->start));
                    $event->setEndTimestamp($event->startTimestamp + $event->durMin * 60);
                }
                $tmp[] = $event;
            }
        }
        $this->event_arr = $tmp;

        $maxspan = 1;
        $this->last = 0;
        for ($i = 0; $i < 48; $i++) {
            $this->event_matrix[$i] = array();
            $start = mktime(floor($i/2), ($i % 2) * 30, 0, $this->Day->month, $this->Day->mday, $this->Day->year);
            foreach ($this->event_arr as $key => $event) {
                if ($event->endTimestamp > $start && $event->startTimestamp < $start + 60 * 30) {
                    if ($i > $this->last) {
                        $this->last = $i;
                    }
                    $this->event_matrix[$i][] = $key;
                    if (!isset($event->rowspan)) {
                        $this->event_arr[$key]->rowspan = 1;
                    } else {
                        $this->event_arr[$key]->rowspan++;
                    }
                    foreach ($this->event_matrix[$i] as $ev) {
                        if (!isset($this->event_arr[$ev]->overlap) || count($this->event_matrix[$i]) > $this->event_arr[$ev]->overlap) {
                            $this->event_arr[$ev]->overlap = count($this->event_matrix[$i]);
                        }
                    }
                    $maxspan = max(count($this->event_matrix[$i]), $maxspan);
                }
            }

        }
        $this->span = $maxspan;

        $this->parsed = true;
    }

    function link($offset = 0)
    {
        return Horde::applicationUrl('day.php?month=' . $this->Day->getTime('%m', $offset) . '&mday=' . ltrim($this->Day->getTime('%d', $offset)) . '&year=' . $this->Day->getTime('%Y', $offset));
    }

}
?>
