#!/usr/bin/perl
#
# $Id: ScanContext.pm,v 1.10 2000/05/04 23:15:57 levine Exp $
#
# Copyright (C) 2000  James D. Levine (jdl@vinecorp.com)
#
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 2
#   of the License, or (at your option) any later version.
# 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
#   02111-1307, USA.
#
####################################################################

use strict;

package PortScan::ScanContext;

my $config = {};

&_init;

sub AUTOLOAD
{
    my $prop = $PortScan::ScanContext::AUTOLOAD;

    $prop =~ s/PortScan::ScanContext:://g;

    return $config->{$prop};
}

sub _require
{
    my $f = shift;
#print "attempting to load $f \n"
#    ;
    (-r $f) ? (require $f) : 0;
}

sub _init
  {
    my $self = shift;

    if (  (! _require $ENV{"HOME"} . "/.ndiff/ndiff.conf" ) 
	  && (! _require $ENV{"NDIFF_ROOT"} . "/ndiff.conf")
	  && (! _require "/usr/local/lib/ndiff/ndiff.conf")
	  && (! _require "./ndiff.conf")  
	  )
    {
	$config = 
	{
	    default_data_store_type => "PortScan::NmapFile",
	    default_data_store_props => "root=/tmp/ndiff_data",
	};
    }
    else
    {
	$config = get_config();
    }

    $config->{root};
  }


sub split_property
{
    my $prop_string = shift;
    $prop_string =~ s/,/=/g;

    return { split /=/, $prop_string }
}


sub _tests
{
    print "default_data_store_type: " . &PortScan::ScanContext::default_data_store_type ."\n";

}

1;












