<?php
/*
 * $Horde: kronolith/addevent.php,v 1.31.2.1 2002/03/19 02:10:40 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require KRONOLITH_BASE . '/lib/base.php';

$event = $calendar->getEventObject();

if (!$timestamp = Horde::getFormData('timestamp')) {
    $month = Horde::getFormData('month', date('n'));
    $day = Horde::getFormData('mday', date('j'));
    $year = Horde::getFormData('year', date('Y'));
    $timestamp = mktime(8, 0, 0, $month, $day, $year);
}

$url = Horde::getFormData('url');

$event->setStartTimestamp($timestamp);
$event->setEndTimestamp($timestamp);
$event->setRecurType(KRONOLITH_RECUR_NONE);
$month = date('n', $timestamp);
$year = date('Y', $timestamp);

$title = _("Add a new event");
$js_onLoad = null;

require KRONOLITH_TEMPLATES . '/common-header.inc';
require './menu.php';
require KRONOLITH_TEMPLATES . '/edit/javascript.inc';
require KRONOLITH_TEMPLATES . '/edit/edit.inc';
require KRONOLITH_TEMPLATES . '/common-footer.inc';

?>
