/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef ARTSMODULESCOMMON_H
#define ARTSMODULESCOMMON_H

#include "common.h"

// includes of other idl definitions
#include "artsgui.h"
#include "artsflow.h"
#include "artsmidi.h"
#include "artsmodulessynth.h"

namespace Arts {
namespace Environment {
class Context;
class Container;
class Item;
class InstrumentItem;
class InstrumentItemGuiFactory;
class StereoEffectItem;
class MixerChannel;
class MixerItem;
class EffectRackItem;
}
class MixerItemGui;
class EffectRackItemGui;
class EffectRackSlot;
class MixerGuiFactory;
class EffectRackGuiFactory;

namespace Environment {
class Context_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static Context_base *_create(const std::string& subClass = "Arts::Environment::Context");
	static Context_base *_fromString(const std::string& objectref);
	static Context_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Context_base *_fromDynamicCast(const Arts::Object& object);
	inline Context_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void addEntry(const std::string& name, Arts::Object obj) = 0;
	virtual std::string lookupEntry(Arts::Object obj) = 0;
	virtual void removeEntry(Arts::Object obj) = 0;
};

class Context_stub : virtual public Context_base, virtual public Arts::Object_stub {
protected:
	Context_stub();

public:
	Context_stub(Arts::Connection *connection, long objectID);

	void addEntry(const std::string& name, Arts::Object obj);
	std::string lookupEntry(Arts::Object obj);
	void removeEntry(Arts::Object obj);
};

class Context_skel : virtual public Context_base, virtual public Arts::Object_skel {
public:
	Context_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
}
#include "reference.h"
namespace Arts {
namespace Environment {
class Context : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Context_base *_cache;
	inline Context_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Context_base *)_pool->base->_cast(Context_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Context(Context_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Context_base _base_class;

	inline Context() : Arts::Object(_Creator), _cache(0) {}
	inline Context(const Arts::SubClass& s) :
		Arts::Object(Context_base::_create(s.string())), _cache(0) {}
	inline Context(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Context_base::_fromString(r.string())):(Context_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Context(const Arts::DynamicCast& c) : Arts::Object(Context_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Context(const Context& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Context(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Context null() {return Context((Context_base*)0);}
	inline static Context _from_base(Context_base* b) {return Context(b);}
	inline Context& operator=(const Context& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline Context_base* _base() {return _cache?_cache:_method_call();}

	inline void addEntry(const std::string& name, Arts::Object obj);
	inline std::string lookupEntry(Arts::Object obj);
	inline void removeEntry(Arts::Object obj);
};

class Container_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static Container_base *_create(const std::string& subClass = "Arts::Environment::Container");
	static Container_base *_fromString(const std::string& objectref);
	static Container_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Container_base *_fromDynamicCast(const Arts::Object& object);
	inline Container_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string dataDirectory() = 0;
	virtual void dataDirectory(const std::string& newValue) = 0;
	virtual Arts::Environment::Context context() = 0;
	virtual void context(Arts::Environment::Context newValue) = 0;
	virtual std::vector<Arts::Environment::Item> * items() = 0;
	virtual std::vector<std::string> * saveToList() = 0;
	virtual void loadFromList(const std::vector<std::string>& strlist) = 0;
	virtual void addItem(Arts::Environment::Item item) = 0;
	virtual Arts::Environment::Item createItem(const std::string& name) = 0;
	virtual void removeItem(Arts::Environment::Item item) = 0;
};

class Container_stub : virtual public Container_base, virtual public Arts::Object_stub {
protected:
	Container_stub();

public:
	Container_stub(Arts::Connection *connection, long objectID);

	std::string dataDirectory();
	void dataDirectory(const std::string& newValue);
	Arts::Environment::Context context();
	void context(Arts::Environment::Context newValue);
	std::vector<Arts::Environment::Item> * items();
	std::vector<std::string> * saveToList();
	void loadFromList(const std::vector<std::string>& strlist);
	void addItem(Arts::Environment::Item item);
	Arts::Environment::Item createItem(const std::string& name);
	void removeItem(Arts::Environment::Item item);
};

class Container_skel : virtual public Container_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void dataDirectory_changed(const std::string& newValue) {
		_emit_changed("dataDirectory_changed",newValue);
	}

public:
	Container_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
}
#include "reference.h"
namespace Arts {
namespace Environment {
class Container : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Container_base *_cache;
	inline Container_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Container_base *)_pool->base->_cast(Container_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Container(Container_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Container_base _base_class;

	inline Container() : Arts::Object(_Creator), _cache(0) {}
	inline Container(const Arts::SubClass& s) :
		Arts::Object(Container_base::_create(s.string())), _cache(0) {}
	inline Container(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Container_base::_fromString(r.string())):(Container_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Container(const Arts::DynamicCast& c) : Arts::Object(Container_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Container(const Container& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Container(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Container null() {return Container((Container_base*)0);}
	inline static Container _from_base(Container_base* b) {return Container(b);}
	inline Container& operator=(const Container& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline Container_base* _base() {return _cache?_cache:_method_call();}

	inline std::string dataDirectory();
	inline void dataDirectory(const std::string& _newValue);
	inline Arts::Environment::Context context();
	inline void context(Arts::Environment::Context _newValue);
	inline std::vector<Arts::Environment::Item> * items();
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& strlist);
	inline void addItem(Arts::Environment::Item item);
	inline Arts::Environment::Item createItem(const std::string& name);
	inline void removeItem(Arts::Environment::Item item);
};

class Item_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static Item_base *_create(const std::string& subClass = "Arts::Environment::Item");
	static Item_base *_fromString(const std::string& objectref);
	static Item_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Item_base *_fromDynamicCast(const Arts::Object& object);
	inline Item_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool active() = 0;
	virtual Arts::Environment::Container parent() = 0;
	virtual void setContainer(Arts::Environment::Container container) = 0;
	virtual std::vector<std::string> * saveToList() = 0;
	virtual void loadFromList(const std::vector<std::string>& strlist) = 0;
};

class Item_stub : virtual public Item_base, virtual public Arts::Object_stub {
protected:
	Item_stub();

public:
	Item_stub(Arts::Connection *connection, long objectID);

	bool active();
	Arts::Environment::Container parent();
	void setContainer(Arts::Environment::Container container);
	std::vector<std::string> * saveToList();
	void loadFromList(const std::vector<std::string>& strlist);
};

class Item_skel : virtual public Item_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void active_changed(bool newValue) {
		_emit_changed("active_changed",newValue);
	}

public:
	Item_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
}
#include "reference.h"
namespace Arts {
namespace Environment {
class Item : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Item_base *_cache;
	inline Item_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Item_base *)_pool->base->_cast(Item_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Item(Item_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Item_base _base_class;

	inline Item() : Arts::Object(_Creator), _cache(0) {}
	inline Item(const Arts::SubClass& s) :
		Arts::Object(Item_base::_create(s.string())), _cache(0) {}
	inline Item(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Item_base::_fromString(r.string())):(Item_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Item(const Arts::DynamicCast& c) : Arts::Object(Item_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Item(const Item& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Item(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Item null() {return Item((Item_base*)0);}
	inline static Item _from_base(Item_base* b) {return Item(b);}
	inline Item& operator=(const Item& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline Item_base* _base() {return _cache?_cache:_method_call();}

	inline bool active();
	inline Arts::Environment::Container parent();
	inline void setContainer(Arts::Environment::Container container);
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& strlist);
};

class InstrumentItem_base : virtual public Arts::Environment::Item_base {
public:
	static unsigned long _IID; // interface ID

	static InstrumentItem_base *_create(const std::string& subClass = "Arts::Environment::InstrumentItem");
	static InstrumentItem_base *_fromString(const std::string& objectref);
	static InstrumentItem_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static InstrumentItem_base *_fromDynamicCast(const Arts::Object& object);
	inline InstrumentItem_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::MidiPort port() = 0;
	virtual std::string filename() = 0;
	virtual void filename(const std::string& newValue) = 0;
	virtual std::string busname() = 0;
	virtual void busname(const std::string& newValue) = 0;
};

class InstrumentItem_stub : virtual public InstrumentItem_base, virtual public Arts::Environment::Item_stub {
protected:
	InstrumentItem_stub();

public:
	InstrumentItem_stub(Arts::Connection *connection, long objectID);

	Arts::MidiPort port();
	std::string filename();
	void filename(const std::string& newValue);
	std::string busname();
	void busname(const std::string& newValue);
};

class InstrumentItem_skel : virtual public InstrumentItem_base, virtual public Arts::Environment::Item_skel {
protected:
	// emitters for change notifications
	inline void filename_changed(const std::string& newValue) {
		_emit_changed("filename_changed",newValue);
	}
	inline void busname_changed(const std::string& newValue) {
		_emit_changed("busname_changed",newValue);
	}

public:
	InstrumentItem_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
}
#include "reference.h"
namespace Arts {
namespace Environment {
class InstrumentItem : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	InstrumentItem_base *_cache;
	inline InstrumentItem_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(InstrumentItem_base *)_pool->base->_cast(InstrumentItem_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline InstrumentItem(InstrumentItem_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef InstrumentItem_base _base_class;

	inline InstrumentItem() : Arts::Object(_Creator), _cache(0) {}
	inline InstrumentItem(const Arts::SubClass& s) :
		Arts::Object(InstrumentItem_base::_create(s.string())), _cache(0) {}
	inline InstrumentItem(const Arts::Reference &r) :
		Arts::Object(r.isString()?(InstrumentItem_base::_fromString(r.string())):(InstrumentItem_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline InstrumentItem(const Arts::DynamicCast& c) : Arts::Object(InstrumentItem_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline InstrumentItem(const InstrumentItem& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline InstrumentItem(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static InstrumentItem null() {return InstrumentItem((InstrumentItem_base*)0);}
	inline static InstrumentItem _from_base(InstrumentItem_base* b) {return InstrumentItem(b);}
	inline InstrumentItem& operator=(const InstrumentItem& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Environment::Item() const { return Arts::Environment::Item(*_pool); }
	inline InstrumentItem_base* _base() {return _cache?_cache:_method_call();}

	inline bool active();
	inline Arts::Environment::Container parent();
	inline void setContainer(Arts::Environment::Container container);
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& strlist);
	inline Arts::MidiPort port();
	inline std::string filename();
	inline void filename(const std::string& _newValue);
	inline std::string busname();
	inline void busname(const std::string& _newValue);
};

class InstrumentItemGuiFactory_base : virtual public Arts::GuiFactory_base {
public:
	static unsigned long _IID; // interface ID

	static InstrumentItemGuiFactory_base *_create(const std::string& subClass = "Arts::Environment::InstrumentItemGuiFactory");
	static InstrumentItemGuiFactory_base *_fromString(const std::string& objectref);
	static InstrumentItemGuiFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static InstrumentItemGuiFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline InstrumentItemGuiFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class InstrumentItemGuiFactory_stub : virtual public InstrumentItemGuiFactory_base, virtual public Arts::GuiFactory_stub {
protected:
	InstrumentItemGuiFactory_stub();

public:
	InstrumentItemGuiFactory_stub(Arts::Connection *connection, long objectID);

};

class InstrumentItemGuiFactory_skel : virtual public InstrumentItemGuiFactory_base, virtual public Arts::GuiFactory_skel {
public:
	InstrumentItemGuiFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
}
#include "reference.h"
namespace Arts {
namespace Environment {
class InstrumentItemGuiFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	InstrumentItemGuiFactory_base *_cache;
	inline InstrumentItemGuiFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(InstrumentItemGuiFactory_base *)_pool->base->_cast(InstrumentItemGuiFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline InstrumentItemGuiFactory(InstrumentItemGuiFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef InstrumentItemGuiFactory_base _base_class;

	inline InstrumentItemGuiFactory() : Arts::Object(_Creator), _cache(0) {}
	inline InstrumentItemGuiFactory(const Arts::SubClass& s) :
		Arts::Object(InstrumentItemGuiFactory_base::_create(s.string())), _cache(0) {}
	inline InstrumentItemGuiFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(InstrumentItemGuiFactory_base::_fromString(r.string())):(InstrumentItemGuiFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline InstrumentItemGuiFactory(const Arts::DynamicCast& c) : Arts::Object(InstrumentItemGuiFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline InstrumentItemGuiFactory(const InstrumentItemGuiFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline InstrumentItemGuiFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static InstrumentItemGuiFactory null() {return InstrumentItemGuiFactory((InstrumentItemGuiFactory_base*)0);}
	inline static InstrumentItemGuiFactory _from_base(InstrumentItemGuiFactory_base* b) {return InstrumentItemGuiFactory(b);}
	inline InstrumentItemGuiFactory& operator=(const InstrumentItemGuiFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::GuiFactory() const { return Arts::GuiFactory(*_pool); }
	inline InstrumentItemGuiFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Widget createGui(Arts::Object runningObject);
};

class StereoEffectItem_base : virtual public Arts::Environment::Item_base {
public:
	static unsigned long _IID; // interface ID

	static StereoEffectItem_base *_create(const std::string& subClass = "Arts::Environment::StereoEffectItem");
	static StereoEffectItem_base *_fromString(const std::string& objectref);
	static StereoEffectItem_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static StereoEffectItem_base *_fromDynamicCast(const Arts::Object& object);
	inline StereoEffectItem_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::SynthModule effect() = 0;
	virtual void effect(Arts::SynthModule newValue) = 0;
	virtual Arts::StereoEffectStack stack() = 0;
	virtual void stack(Arts::StereoEffectStack newValue) = 0;
};

class StereoEffectItem_stub : virtual public StereoEffectItem_base, virtual public Arts::Environment::Item_stub {
protected:
	StereoEffectItem_stub();

public:
	StereoEffectItem_stub(Arts::Connection *connection, long objectID);

	Arts::SynthModule effect();
	void effect(Arts::SynthModule newValue);
	Arts::StereoEffectStack stack();
	void stack(Arts::StereoEffectStack newValue);
};

class StereoEffectItem_skel : virtual public StereoEffectItem_base, virtual public Arts::Environment::Item_skel {
public:
	StereoEffectItem_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
}
#include "reference.h"
namespace Arts {
namespace Environment {
class StereoEffectItem : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	StereoEffectItem_base *_cache;
	inline StereoEffectItem_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoEffectItem_base *)_pool->base->_cast(StereoEffectItem_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline StereoEffectItem(StereoEffectItem_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef StereoEffectItem_base _base_class;

	inline StereoEffectItem() : Arts::Object(_Creator), _cache(0) {}
	inline StereoEffectItem(const Arts::SubClass& s) :
		Arts::Object(StereoEffectItem_base::_create(s.string())), _cache(0) {}
	inline StereoEffectItem(const Arts::Reference &r) :
		Arts::Object(r.isString()?(StereoEffectItem_base::_fromString(r.string())):(StereoEffectItem_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoEffectItem(const Arts::DynamicCast& c) : Arts::Object(StereoEffectItem_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline StereoEffectItem(const StereoEffectItem& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline StereoEffectItem(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static StereoEffectItem null() {return StereoEffectItem((StereoEffectItem_base*)0);}
	inline static StereoEffectItem _from_base(StereoEffectItem_base* b) {return StereoEffectItem(b);}
	inline StereoEffectItem& operator=(const StereoEffectItem& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Environment::Item() const { return Arts::Environment::Item(*_pool); }
	inline StereoEffectItem_base* _base() {return _cache?_cache:_method_call();}

	inline bool active();
	inline Arts::Environment::Container parent();
	inline void setContainer(Arts::Environment::Container container);
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& strlist);
	inline Arts::SynthModule effect();
	inline void effect(Arts::SynthModule _newValue);
	inline Arts::StereoEffectStack stack();
	inline void stack(Arts::StereoEffectStack _newValue);
};

class MixerChannel_base : virtual public Arts::StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static MixerChannel_base *_create(const std::string& subClass = "Arts::Environment::MixerChannel");
	static MixerChannel_base *_fromString(const std::string& objectref);
	static MixerChannel_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MixerChannel_base *_fromDynamicCast(const Arts::Object& object);
	inline MixerChannel_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string name() = 0;
	virtual void name(const std::string& newValue) = 0;
};

class MixerChannel_stub : virtual public MixerChannel_base, virtual public Arts::StereoEffect_stub {
protected:
	MixerChannel_stub();

public:
	MixerChannel_stub(Arts::Connection *connection, long objectID);

	std::string name();
	void name(const std::string& newValue);
};

class MixerChannel_skel : virtual public MixerChannel_base, virtual public Arts::StereoEffect_skel {
protected:
	// emitters for change notifications
	inline void name_changed(const std::string& newValue) {
		_emit_changed("name_changed",newValue);
	}

public:
	MixerChannel_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
}
#include "reference.h"
namespace Arts {
namespace Environment {
class MixerChannel : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MixerChannel_base *_cache;
	inline MixerChannel_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MixerChannel_base *)_pool->base->_cast(MixerChannel_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MixerChannel(MixerChannel_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MixerChannel_base _base_class;

	inline MixerChannel() : Arts::Object(_Creator), _cache(0) {}
	inline MixerChannel(const Arts::SubClass& s) :
		Arts::Object(MixerChannel_base::_create(s.string())), _cache(0) {}
	inline MixerChannel(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MixerChannel_base::_fromString(r.string())):(MixerChannel_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MixerChannel(const Arts::DynamicCast& c) : Arts::Object(MixerChannel_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MixerChannel(const MixerChannel& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MixerChannel(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MixerChannel null() {return MixerChannel((MixerChannel_base*)0);}
	inline static MixerChannel _from_base(MixerChannel_base* b) {return MixerChannel(b);}
	inline MixerChannel& operator=(const MixerChannel& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline MixerChannel_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::string name();
	inline void name(const std::string& _newValue);
};

class MixerItem_base : virtual public Arts::Environment::Item_base {
public:
	static unsigned long _IID; // interface ID

	static MixerItem_base *_create(const std::string& subClass = "Arts::Environment::MixerItem");
	static MixerItem_base *_fromString(const std::string& objectref);
	static MixerItem_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MixerItem_base *_fromDynamicCast(const Arts::Object& object);
	inline MixerItem_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::vector<Arts::Environment::MixerChannel> * channels() = 0;
	virtual long channelCount() = 0;
	virtual void channelCount(long newValue) = 0;
	virtual std::string name() = 0;
	virtual void name(const std::string& newValue) = 0;
	virtual std::string type() = 0;
	virtual void type(const std::string& newValue) = 0;
};

class MixerItem_stub : virtual public MixerItem_base, virtual public Arts::Environment::Item_stub {
protected:
	MixerItem_stub();

public:
	MixerItem_stub(Arts::Connection *connection, long objectID);

	std::vector<Arts::Environment::MixerChannel> * channels();
	long channelCount();
	void channelCount(long newValue);
	std::string name();
	void name(const std::string& newValue);
	std::string type();
	void type(const std::string& newValue);
};

class MixerItem_skel : virtual public MixerItem_base, virtual public Arts::Environment::Item_skel {
protected:
	// emitters for change notifications
	inline void channelCount_changed(long newValue) {
		_emit_changed("channelCount_changed",newValue);
	}
	inline void name_changed(const std::string& newValue) {
		_emit_changed("name_changed",newValue);
	}
	inline void type_changed(const std::string& newValue) {
		_emit_changed("type_changed",newValue);
	}

public:
	MixerItem_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
}
#include "reference.h"
namespace Arts {
namespace Environment {
class MixerItem : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MixerItem_base *_cache;
	inline MixerItem_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MixerItem_base *)_pool->base->_cast(MixerItem_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MixerItem(MixerItem_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MixerItem_base _base_class;

	inline MixerItem() : Arts::Object(_Creator), _cache(0) {}
	inline MixerItem(const Arts::SubClass& s) :
		Arts::Object(MixerItem_base::_create(s.string())), _cache(0) {}
	inline MixerItem(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MixerItem_base::_fromString(r.string())):(MixerItem_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MixerItem(const Arts::DynamicCast& c) : Arts::Object(MixerItem_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MixerItem(const MixerItem& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MixerItem(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MixerItem null() {return MixerItem((MixerItem_base*)0);}
	inline static MixerItem _from_base(MixerItem_base* b) {return MixerItem(b);}
	inline MixerItem& operator=(const MixerItem& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Environment::Item() const { return Arts::Environment::Item(*_pool); }
	inline MixerItem_base* _base() {return _cache?_cache:_method_call();}

	inline bool active();
	inline Arts::Environment::Container parent();
	inline void setContainer(Arts::Environment::Container container);
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& strlist);
	inline std::vector<Arts::Environment::MixerChannel> * channels();
	inline long channelCount();
	inline void channelCount(long _newValue);
	inline std::string name();
	inline void name(const std::string& _newValue);
	inline std::string type();
	inline void type(const std::string& _newValue);
};

class EffectRackItem_base : virtual public Arts::Environment::Item_base {
public:
	static unsigned long _IID; // interface ID

	static EffectRackItem_base *_create(const std::string& subClass = "Arts::Environment::EffectRackItem");
	static EffectRackItem_base *_fromString(const std::string& objectref);
	static EffectRackItem_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static EffectRackItem_base *_fromDynamicCast(const Arts::Object& object);
	inline EffectRackItem_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::vector<Arts::StereoEffect> * effects() = 0;
	virtual long effectCount() = 0;
	virtual std::string name() = 0;
	virtual void name(const std::string& newValue) = 0;
	virtual Arts::StereoEffect createEffect(const std::string& type, const std::string& name) = 0;
	virtual void delEffect(long pos) = 0;
	virtual void routeToMaster(long pos, bool tomaster) = 0;
};

class EffectRackItem_stub : virtual public EffectRackItem_base, virtual public Arts::Environment::Item_stub {
protected:
	EffectRackItem_stub();

public:
	EffectRackItem_stub(Arts::Connection *connection, long objectID);

	std::vector<Arts::StereoEffect> * effects();
	long effectCount();
	std::string name();
	void name(const std::string& newValue);
	Arts::StereoEffect createEffect(const std::string& type, const std::string& name);
	void delEffect(long pos);
	void routeToMaster(long pos, bool tomaster);
};

class EffectRackItem_skel : virtual public EffectRackItem_base, virtual public Arts::Environment::Item_skel {
protected:
	// emitters for change notifications
	inline void effectCount_changed(long newValue) {
		_emit_changed("effectCount_changed",newValue);
	}
	inline void name_changed(const std::string& newValue) {
		_emit_changed("name_changed",newValue);
	}

public:
	EffectRackItem_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
}
#include "reference.h"
namespace Arts {
namespace Environment {
class EffectRackItem : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	EffectRackItem_base *_cache;
	inline EffectRackItem_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(EffectRackItem_base *)_pool->base->_cast(EffectRackItem_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline EffectRackItem(EffectRackItem_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef EffectRackItem_base _base_class;

	inline EffectRackItem() : Arts::Object(_Creator), _cache(0) {}
	inline EffectRackItem(const Arts::SubClass& s) :
		Arts::Object(EffectRackItem_base::_create(s.string())), _cache(0) {}
	inline EffectRackItem(const Arts::Reference &r) :
		Arts::Object(r.isString()?(EffectRackItem_base::_fromString(r.string())):(EffectRackItem_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline EffectRackItem(const Arts::DynamicCast& c) : Arts::Object(EffectRackItem_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline EffectRackItem(const EffectRackItem& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline EffectRackItem(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static EffectRackItem null() {return EffectRackItem((EffectRackItem_base*)0);}
	inline static EffectRackItem _from_base(EffectRackItem_base* b) {return EffectRackItem(b);}
	inline EffectRackItem& operator=(const EffectRackItem& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Environment::Item() const { return Arts::Environment::Item(*_pool); }
	inline EffectRackItem_base* _base() {return _cache?_cache:_method_call();}

	inline bool active();
	inline Arts::Environment::Container parent();
	inline void setContainer(Arts::Environment::Container container);
	inline std::vector<std::string> * saveToList();
	inline void loadFromList(const std::vector<std::string>& strlist);
	inline std::vector<Arts::StereoEffect> * effects();
	inline long effectCount();
	inline std::string name();
	inline void name(const std::string& _newValue);
	inline Arts::StereoEffect createEffect(const std::string& type, const std::string& name);
	inline void delEffect(long pos);
	inline void routeToMaster(long pos, bool tomaster);
};

}
class MixerItemGui_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static MixerItemGui_base *_create(const std::string& subClass = "Arts::MixerItemGui");
	static MixerItemGui_base *_fromString(const std::string& objectref);
	static MixerItemGui_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MixerItemGui_base *_fromDynamicCast(const Arts::Object& object);
	inline MixerItemGui_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool active() = 0;
	virtual void active(bool newValue) = 0;
	virtual long channelCount() = 0;
	virtual void channelCount(long newValue) = 0;
	virtual std::string type() = 0;
	virtual void type(const std::string& newValue) = 0;
	virtual Arts::Widget initialize(Arts::Environment::MixerItem item) = 0;
};

class MixerItemGui_stub : virtual public MixerItemGui_base, virtual public Arts::Object_stub {
protected:
	MixerItemGui_stub();

public:
	MixerItemGui_stub(Arts::Connection *connection, long objectID);

	bool active();
	void active(bool newValue);
	long channelCount();
	void channelCount(long newValue);
	std::string type();
	void type(const std::string& newValue);
	Arts::Widget initialize(Arts::Environment::MixerItem item);
};

class MixerItemGui_skel : virtual public MixerItemGui_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void active_changed(bool newValue) {
		_emit_changed("active_changed",newValue);
	}
	inline void channelCount_changed(long newValue) {
		_emit_changed("channelCount_changed",newValue);
	}
	inline void type_changed(const std::string& newValue) {
		_emit_changed("type_changed",newValue);
	}

public:
	MixerItemGui_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class MixerItemGui : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MixerItemGui_base *_cache;
	inline MixerItemGui_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MixerItemGui_base *)_pool->base->_cast(MixerItemGui_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MixerItemGui(MixerItemGui_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MixerItemGui_base _base_class;

	inline MixerItemGui() : Arts::Object(_Creator), _cache(0) {}
	inline MixerItemGui(const Arts::SubClass& s) :
		Arts::Object(MixerItemGui_base::_create(s.string())), _cache(0) {}
	inline MixerItemGui(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MixerItemGui_base::_fromString(r.string())):(MixerItemGui_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MixerItemGui(const Arts::DynamicCast& c) : Arts::Object(MixerItemGui_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MixerItemGui(const MixerItemGui& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MixerItemGui(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MixerItemGui null() {return MixerItemGui((MixerItemGui_base*)0);}
	inline static MixerItemGui _from_base(MixerItemGui_base* b) {return MixerItemGui(b);}
	inline MixerItemGui& operator=(const MixerItemGui& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline MixerItemGui_base* _base() {return _cache?_cache:_method_call();}

	inline bool active();
	inline void active(bool _newValue);
	inline long channelCount();
	inline void channelCount(long _newValue);
	inline std::string type();
	inline void type(const std::string& _newValue);
	inline Arts::Widget initialize(Arts::Environment::MixerItem item);
};

class EffectRackItemGui_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static EffectRackItemGui_base *_create(const std::string& subClass = "Arts::EffectRackItemGui");
	static EffectRackItemGui_base *_fromString(const std::string& objectref);
	static EffectRackItemGui_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static EffectRackItemGui_base *_fromDynamicCast(const Arts::Object& object);
	inline EffectRackItemGui_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool active() = 0;
	virtual void active(bool newValue) = 0;
	virtual std::string type() = 0;
	virtual void type(const std::string& newValue) = 0;
	virtual bool addeffect() = 0;
	virtual void addeffect(bool newValue) = 0;
	virtual void removeSlot(Arts::EffectRackSlot slot) = 0;
	virtual void routeToMaster(Arts::EffectRackSlot slot, bool tomaster) = 0;
	virtual Arts::Widget initialize(Arts::Environment::EffectRackItem item) = 0;
};

class EffectRackItemGui_stub : virtual public EffectRackItemGui_base, virtual public Arts::Object_stub {
protected:
	EffectRackItemGui_stub();

public:
	EffectRackItemGui_stub(Arts::Connection *connection, long objectID);

	bool active();
	void active(bool newValue);
	std::string type();
	void type(const std::string& newValue);
	bool addeffect();
	void addeffect(bool newValue);
	void removeSlot(Arts::EffectRackSlot slot);
	void routeToMaster(Arts::EffectRackSlot slot, bool tomaster);
	Arts::Widget initialize(Arts::Environment::EffectRackItem item);
};

class EffectRackItemGui_skel : virtual public EffectRackItemGui_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void active_changed(bool newValue) {
		_emit_changed("active_changed",newValue);
	}
	inline void type_changed(const std::string& newValue) {
		_emit_changed("type_changed",newValue);
	}
	inline void addeffect_changed(bool newValue) {
		_emit_changed("addeffect_changed",newValue);
	}

public:
	EffectRackItemGui_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class EffectRackItemGui : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	EffectRackItemGui_base *_cache;
	inline EffectRackItemGui_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(EffectRackItemGui_base *)_pool->base->_cast(EffectRackItemGui_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline EffectRackItemGui(EffectRackItemGui_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef EffectRackItemGui_base _base_class;

	inline EffectRackItemGui() : Arts::Object(_Creator), _cache(0) {}
	inline EffectRackItemGui(const Arts::SubClass& s) :
		Arts::Object(EffectRackItemGui_base::_create(s.string())), _cache(0) {}
	inline EffectRackItemGui(const Arts::Reference &r) :
		Arts::Object(r.isString()?(EffectRackItemGui_base::_fromString(r.string())):(EffectRackItemGui_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline EffectRackItemGui(const Arts::DynamicCast& c) : Arts::Object(EffectRackItemGui_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline EffectRackItemGui(const EffectRackItemGui& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline EffectRackItemGui(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static EffectRackItemGui null() {return EffectRackItemGui((EffectRackItemGui_base*)0);}
	inline static EffectRackItemGui _from_base(EffectRackItemGui_base* b) {return EffectRackItemGui(b);}
	inline EffectRackItemGui& operator=(const EffectRackItemGui& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline EffectRackItemGui_base* _base() {return _cache?_cache:_method_call();}

	inline bool active();
	inline void active(bool _newValue);
	inline std::string type();
	inline void type(const std::string& _newValue);
	inline bool addeffect();
	inline void addeffect(bool _newValue);
	inline void removeSlot(Arts::EffectRackSlot slot);
	inline void routeToMaster(Arts::EffectRackSlot slot, bool tomaster);
	inline Arts::Widget initialize(Arts::Environment::EffectRackItem item);
};

class EffectRackSlot_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static EffectRackSlot_base *_create(const std::string& subClass = "Arts::EffectRackSlot");
	static EffectRackSlot_base *_fromString(const std::string& objectref);
	static EffectRackSlot_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static EffectRackSlot_base *_fromDynamicCast(const Arts::Object& object);
	inline EffectRackSlot_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool removeslot() = 0;
	virtual void removeslot(bool newValue) = 0;
	virtual bool tomaster() = 0;
	virtual void tomaster(bool newValue) = 0;
	virtual void constructor(Arts::Widget parent, Arts::Widget effect, Arts::EffectRackItemGui effectrackgui) = 0;
};

class EffectRackSlot_stub : virtual public EffectRackSlot_base, virtual public Arts::Object_stub {
protected:
	EffectRackSlot_stub();

public:
	EffectRackSlot_stub(Arts::Connection *connection, long objectID);

	bool removeslot();
	void removeslot(bool newValue);
	bool tomaster();
	void tomaster(bool newValue);
	void constructor(Arts::Widget parent, Arts::Widget effect, Arts::EffectRackItemGui effectrackgui);
};

class EffectRackSlot_skel : virtual public EffectRackSlot_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void removeslot_changed(bool newValue) {
		_emit_changed("removeslot_changed",newValue);
	}
	inline void tomaster_changed(bool newValue) {
		_emit_changed("tomaster_changed",newValue);
	}

public:
	EffectRackSlot_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class EffectRackSlot : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	EffectRackSlot_base *_cache;
	inline EffectRackSlot_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(EffectRackSlot_base *)_pool->base->_cast(EffectRackSlot_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline EffectRackSlot(EffectRackSlot_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef EffectRackSlot_base _base_class;

	inline EffectRackSlot() : Arts::Object(_Creator), _cache(0) {}
	inline EffectRackSlot(const Arts::SubClass& s) :
		Arts::Object(EffectRackSlot_base::_create(s.string())), _cache(0) {}
	inline EffectRackSlot(const Arts::Reference &r) :
		Arts::Object(r.isString()?(EffectRackSlot_base::_fromString(r.string())):(EffectRackSlot_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline EffectRackSlot(const Arts::DynamicCast& c) : Arts::Object(EffectRackSlot_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline EffectRackSlot(const EffectRackSlot& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline EffectRackSlot(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static EffectRackSlot null() {return EffectRackSlot((EffectRackSlot_base*)0);}
	inline static EffectRackSlot _from_base(EffectRackSlot_base* b) {return EffectRackSlot(b);}
	inline EffectRackSlot& operator=(const EffectRackSlot& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline EffectRackSlot_base* _base() {return _cache?_cache:_method_call();}

	inline bool removeslot();
	inline void removeslot(bool _newValue);
	inline bool tomaster();
	inline void tomaster(bool _newValue);
	inline EffectRackSlot(Arts::Widget parent, Arts::Widget effect, Arts::EffectRackItemGui effectrackgui);
};

class MixerGuiFactory_base : virtual public Arts::GuiFactory_base {
public:
	static unsigned long _IID; // interface ID

	static MixerGuiFactory_base *_create(const std::string& subClass = "Arts::MixerGuiFactory");
	static MixerGuiFactory_base *_fromString(const std::string& objectref);
	static MixerGuiFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MixerGuiFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline MixerGuiFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class MixerGuiFactory_stub : virtual public MixerGuiFactory_base, virtual public Arts::GuiFactory_stub {
protected:
	MixerGuiFactory_stub();

public:
	MixerGuiFactory_stub(Arts::Connection *connection, long objectID);

};

class MixerGuiFactory_skel : virtual public MixerGuiFactory_base, virtual public Arts::GuiFactory_skel {
public:
	MixerGuiFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class MixerGuiFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MixerGuiFactory_base *_cache;
	inline MixerGuiFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MixerGuiFactory_base *)_pool->base->_cast(MixerGuiFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MixerGuiFactory(MixerGuiFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MixerGuiFactory_base _base_class;

	inline MixerGuiFactory() : Arts::Object(_Creator), _cache(0) {}
	inline MixerGuiFactory(const Arts::SubClass& s) :
		Arts::Object(MixerGuiFactory_base::_create(s.string())), _cache(0) {}
	inline MixerGuiFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MixerGuiFactory_base::_fromString(r.string())):(MixerGuiFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MixerGuiFactory(const Arts::DynamicCast& c) : Arts::Object(MixerGuiFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MixerGuiFactory(const MixerGuiFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MixerGuiFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MixerGuiFactory null() {return MixerGuiFactory((MixerGuiFactory_base*)0);}
	inline static MixerGuiFactory _from_base(MixerGuiFactory_base* b) {return MixerGuiFactory(b);}
	inline MixerGuiFactory& operator=(const MixerGuiFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::GuiFactory() const { return Arts::GuiFactory(*_pool); }
	inline MixerGuiFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Widget createGui(Arts::Object runningObject);
};

class EffectRackGuiFactory_base : virtual public Arts::GuiFactory_base {
public:
	static unsigned long _IID; // interface ID

	static EffectRackGuiFactory_base *_create(const std::string& subClass = "Arts::EffectRackGuiFactory");
	static EffectRackGuiFactory_base *_fromString(const std::string& objectref);
	static EffectRackGuiFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static EffectRackGuiFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline EffectRackGuiFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class EffectRackGuiFactory_stub : virtual public EffectRackGuiFactory_base, virtual public Arts::GuiFactory_stub {
protected:
	EffectRackGuiFactory_stub();

public:
	EffectRackGuiFactory_stub(Arts::Connection *connection, long objectID);

};

class EffectRackGuiFactory_skel : virtual public EffectRackGuiFactory_base, virtual public Arts::GuiFactory_skel {
public:
	EffectRackGuiFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class EffectRackGuiFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	EffectRackGuiFactory_base *_cache;
	inline EffectRackGuiFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(EffectRackGuiFactory_base *)_pool->base->_cast(EffectRackGuiFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline EffectRackGuiFactory(EffectRackGuiFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef EffectRackGuiFactory_base _base_class;

	inline EffectRackGuiFactory() : Arts::Object(_Creator), _cache(0) {}
	inline EffectRackGuiFactory(const Arts::SubClass& s) :
		Arts::Object(EffectRackGuiFactory_base::_create(s.string())), _cache(0) {}
	inline EffectRackGuiFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(EffectRackGuiFactory_base::_fromString(r.string())):(EffectRackGuiFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline EffectRackGuiFactory(const Arts::DynamicCast& c) : Arts::Object(EffectRackGuiFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline EffectRackGuiFactory(const EffectRackGuiFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline EffectRackGuiFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static EffectRackGuiFactory null() {return EffectRackGuiFactory((EffectRackGuiFactory_base*)0);}
	inline static EffectRackGuiFactory _from_base(EffectRackGuiFactory_base* b) {return EffectRackGuiFactory(b);}
	inline EffectRackGuiFactory& operator=(const EffectRackGuiFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::GuiFactory() const { return Arts::GuiFactory(*_pool); }
	inline EffectRackGuiFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Widget createGui(Arts::Object runningObject);
};

}
// Forward wrapper calls to _base classes:

inline void Arts::Environment::Context::addEntry(const std::string& name, Arts::Object obj)
{
	 _cache?static_cast<Arts::Environment::Context_base*>(_cache)->addEntry(name, obj):static_cast<Arts::Environment::Context_base*>(_method_call())->addEntry(name, obj);
}

inline std::string Arts::Environment::Context::lookupEntry(Arts::Object obj)
{
	return _cache?static_cast<Arts::Environment::Context_base*>(_cache)->lookupEntry(obj):static_cast<Arts::Environment::Context_base*>(_method_call())->lookupEntry(obj);
}

inline void Arts::Environment::Context::removeEntry(Arts::Object obj)
{
	 _cache?static_cast<Arts::Environment::Context_base*>(_cache)->removeEntry(obj):static_cast<Arts::Environment::Context_base*>(_method_call())->removeEntry(obj);
}

inline std::string Arts::Environment::Container::dataDirectory()
{
	return _cache?static_cast<Arts::Environment::Container_base*>(_cache)->dataDirectory():static_cast<Arts::Environment::Container_base*>(_method_call())->dataDirectory();
}

inline void Arts::Environment::Container::dataDirectory(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::Container_base*>(_cache)->dataDirectory(_newValue):static_cast<Arts::Environment::Container_base*>(_method_call())->dataDirectory(_newValue);
}

inline Arts::Environment::Context Arts::Environment::Container::context()
{
	return _cache?static_cast<Arts::Environment::Container_base*>(_cache)->context():static_cast<Arts::Environment::Container_base*>(_method_call())->context();
}

inline void Arts::Environment::Container::context(Arts::Environment::Context _newValue)
{
	 _cache?static_cast<Arts::Environment::Container_base*>(_cache)->context(_newValue):static_cast<Arts::Environment::Container_base*>(_method_call())->context(_newValue);
}

inline std::vector<Arts::Environment::Item> * Arts::Environment::Container::items()
{
	return _cache?static_cast<Arts::Environment::Container_base*>(_cache)->items():static_cast<Arts::Environment::Container_base*>(_method_call())->items();
}

inline std::vector<std::string> * Arts::Environment::Container::saveToList()
{
	return _cache?static_cast<Arts::Environment::Container_base*>(_cache)->saveToList():static_cast<Arts::Environment::Container_base*>(_method_call())->saveToList();
}

inline void Arts::Environment::Container::loadFromList(const std::vector<std::string>& strlist)
{
	 _cache?static_cast<Arts::Environment::Container_base*>(_cache)->loadFromList(strlist):static_cast<Arts::Environment::Container_base*>(_method_call())->loadFromList(strlist);
}

inline void Arts::Environment::Container::addItem(Arts::Environment::Item item)
{
	 _cache?static_cast<Arts::Environment::Container_base*>(_cache)->addItem(item):static_cast<Arts::Environment::Container_base*>(_method_call())->addItem(item);
}

inline Arts::Environment::Item Arts::Environment::Container::createItem(const std::string& name)
{
	return _cache?static_cast<Arts::Environment::Container_base*>(_cache)->createItem(name):static_cast<Arts::Environment::Container_base*>(_method_call())->createItem(name);
}

inline void Arts::Environment::Container::removeItem(Arts::Environment::Item item)
{
	 _cache?static_cast<Arts::Environment::Container_base*>(_cache)->removeItem(item):static_cast<Arts::Environment::Container_base*>(_method_call())->removeItem(item);
}

inline bool Arts::Environment::Item::active()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->active():static_cast<Arts::Environment::Item_base*>(_method_call())->active();
}

inline Arts::Environment::Container Arts::Environment::Item::parent()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->parent():static_cast<Arts::Environment::Item_base*>(_method_call())->parent();
}

inline void Arts::Environment::Item::setContainer(Arts::Environment::Container container)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->setContainer(container):static_cast<Arts::Environment::Item_base*>(_method_call())->setContainer(container);
}

inline std::vector<std::string> * Arts::Environment::Item::saveToList()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->saveToList():static_cast<Arts::Environment::Item_base*>(_method_call())->saveToList();
}

inline void Arts::Environment::Item::loadFromList(const std::vector<std::string>& strlist)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->loadFromList(strlist):static_cast<Arts::Environment::Item_base*>(_method_call())->loadFromList(strlist);
}

inline bool Arts::Environment::InstrumentItem::active()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->active():static_cast<Arts::Environment::Item_base*>(_method_call())->active();
}

inline Arts::Environment::Container Arts::Environment::InstrumentItem::parent()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->parent():static_cast<Arts::Environment::Item_base*>(_method_call())->parent();
}

inline void Arts::Environment::InstrumentItem::setContainer(Arts::Environment::Container container)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->setContainer(container):static_cast<Arts::Environment::Item_base*>(_method_call())->setContainer(container);
}

inline std::vector<std::string> * Arts::Environment::InstrumentItem::saveToList()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->saveToList():static_cast<Arts::Environment::Item_base*>(_method_call())->saveToList();
}

inline void Arts::Environment::InstrumentItem::loadFromList(const std::vector<std::string>& strlist)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->loadFromList(strlist):static_cast<Arts::Environment::Item_base*>(_method_call())->loadFromList(strlist);
}

inline Arts::MidiPort Arts::Environment::InstrumentItem::port()
{
	return _cache?static_cast<Arts::Environment::InstrumentItem_base*>(_cache)->port():static_cast<Arts::Environment::InstrumentItem_base*>(_method_call())->port();
}

inline std::string Arts::Environment::InstrumentItem::filename()
{
	return _cache?static_cast<Arts::Environment::InstrumentItem_base*>(_cache)->filename():static_cast<Arts::Environment::InstrumentItem_base*>(_method_call())->filename();
}

inline void Arts::Environment::InstrumentItem::filename(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::InstrumentItem_base*>(_cache)->filename(_newValue):static_cast<Arts::Environment::InstrumentItem_base*>(_method_call())->filename(_newValue);
}

inline std::string Arts::Environment::InstrumentItem::busname()
{
	return _cache?static_cast<Arts::Environment::InstrumentItem_base*>(_cache)->busname():static_cast<Arts::Environment::InstrumentItem_base*>(_method_call())->busname();
}

inline void Arts::Environment::InstrumentItem::busname(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::InstrumentItem_base*>(_cache)->busname(_newValue):static_cast<Arts::Environment::InstrumentItem_base*>(_method_call())->busname(_newValue);
}

inline Arts::Widget Arts::Environment::InstrumentItemGuiFactory::createGui(Arts::Object runningObject)
{
	return _cache?static_cast<Arts::GuiFactory_base*>(_cache)->createGui(runningObject):static_cast<Arts::GuiFactory_base*>(_method_call())->createGui(runningObject);
}

inline bool Arts::Environment::StereoEffectItem::active()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->active():static_cast<Arts::Environment::Item_base*>(_method_call())->active();
}

inline Arts::Environment::Container Arts::Environment::StereoEffectItem::parent()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->parent():static_cast<Arts::Environment::Item_base*>(_method_call())->parent();
}

inline void Arts::Environment::StereoEffectItem::setContainer(Arts::Environment::Container container)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->setContainer(container):static_cast<Arts::Environment::Item_base*>(_method_call())->setContainer(container);
}

inline std::vector<std::string> * Arts::Environment::StereoEffectItem::saveToList()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->saveToList():static_cast<Arts::Environment::Item_base*>(_method_call())->saveToList();
}

inline void Arts::Environment::StereoEffectItem::loadFromList(const std::vector<std::string>& strlist)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->loadFromList(strlist):static_cast<Arts::Environment::Item_base*>(_method_call())->loadFromList(strlist);
}

inline Arts::SynthModule Arts::Environment::StereoEffectItem::effect()
{
	return _cache?static_cast<Arts::Environment::StereoEffectItem_base*>(_cache)->effect():static_cast<Arts::Environment::StereoEffectItem_base*>(_method_call())->effect();
}

inline void Arts::Environment::StereoEffectItem::effect(Arts::SynthModule _newValue)
{
	 _cache?static_cast<Arts::Environment::StereoEffectItem_base*>(_cache)->effect(_newValue):static_cast<Arts::Environment::StereoEffectItem_base*>(_method_call())->effect(_newValue);
}

inline Arts::StereoEffectStack Arts::Environment::StereoEffectItem::stack()
{
	return _cache?static_cast<Arts::Environment::StereoEffectItem_base*>(_cache)->stack():static_cast<Arts::Environment::StereoEffectItem_base*>(_method_call())->stack();
}

inline void Arts::Environment::StereoEffectItem::stack(Arts::StereoEffectStack _newValue)
{
	 _cache?static_cast<Arts::Environment::StereoEffectItem_base*>(_cache)->stack(_newValue):static_cast<Arts::Environment::StereoEffectItem_base*>(_method_call())->stack(_newValue);
}

inline Arts::AutoSuspendState Arts::Environment::MixerChannel::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Environment::MixerChannel::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Environment::MixerChannel::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Environment::MixerChannel::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Environment::MixerChannel::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Environment::MixerChannel::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::Environment::MixerChannel::name()
{
	return _cache?static_cast<Arts::Environment::MixerChannel_base*>(_cache)->name():static_cast<Arts::Environment::MixerChannel_base*>(_method_call())->name();
}

inline void Arts::Environment::MixerChannel::name(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::MixerChannel_base*>(_cache)->name(_newValue):static_cast<Arts::Environment::MixerChannel_base*>(_method_call())->name(_newValue);
}

inline bool Arts::Environment::MixerItem::active()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->active():static_cast<Arts::Environment::Item_base*>(_method_call())->active();
}

inline Arts::Environment::Container Arts::Environment::MixerItem::parent()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->parent():static_cast<Arts::Environment::Item_base*>(_method_call())->parent();
}

inline void Arts::Environment::MixerItem::setContainer(Arts::Environment::Container container)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->setContainer(container):static_cast<Arts::Environment::Item_base*>(_method_call())->setContainer(container);
}

inline std::vector<std::string> * Arts::Environment::MixerItem::saveToList()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->saveToList():static_cast<Arts::Environment::Item_base*>(_method_call())->saveToList();
}

inline void Arts::Environment::MixerItem::loadFromList(const std::vector<std::string>& strlist)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->loadFromList(strlist):static_cast<Arts::Environment::Item_base*>(_method_call())->loadFromList(strlist);
}

inline std::vector<Arts::Environment::MixerChannel> * Arts::Environment::MixerItem::channels()
{
	return _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->channels():static_cast<Arts::Environment::MixerItem_base*>(_method_call())->channels();
}

inline long Arts::Environment::MixerItem::channelCount()
{
	return _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->channelCount():static_cast<Arts::Environment::MixerItem_base*>(_method_call())->channelCount();
}

inline void Arts::Environment::MixerItem::channelCount(long _newValue)
{
	 _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->channelCount(_newValue):static_cast<Arts::Environment::MixerItem_base*>(_method_call())->channelCount(_newValue);
}

inline std::string Arts::Environment::MixerItem::name()
{
	return _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->name():static_cast<Arts::Environment::MixerItem_base*>(_method_call())->name();
}

inline void Arts::Environment::MixerItem::name(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->name(_newValue):static_cast<Arts::Environment::MixerItem_base*>(_method_call())->name(_newValue);
}

inline std::string Arts::Environment::MixerItem::type()
{
	return _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->type():static_cast<Arts::Environment::MixerItem_base*>(_method_call())->type();
}

inline void Arts::Environment::MixerItem::type(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::MixerItem_base*>(_cache)->type(_newValue):static_cast<Arts::Environment::MixerItem_base*>(_method_call())->type(_newValue);
}

inline bool Arts::Environment::EffectRackItem::active()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->active():static_cast<Arts::Environment::Item_base*>(_method_call())->active();
}

inline Arts::Environment::Container Arts::Environment::EffectRackItem::parent()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->parent():static_cast<Arts::Environment::Item_base*>(_method_call())->parent();
}

inline void Arts::Environment::EffectRackItem::setContainer(Arts::Environment::Container container)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->setContainer(container):static_cast<Arts::Environment::Item_base*>(_method_call())->setContainer(container);
}

inline std::vector<std::string> * Arts::Environment::EffectRackItem::saveToList()
{
	return _cache?static_cast<Arts::Environment::Item_base*>(_cache)->saveToList():static_cast<Arts::Environment::Item_base*>(_method_call())->saveToList();
}

inline void Arts::Environment::EffectRackItem::loadFromList(const std::vector<std::string>& strlist)
{
	 _cache?static_cast<Arts::Environment::Item_base*>(_cache)->loadFromList(strlist):static_cast<Arts::Environment::Item_base*>(_method_call())->loadFromList(strlist);
}

inline std::vector<Arts::StereoEffect> * Arts::Environment::EffectRackItem::effects()
{
	return _cache?static_cast<Arts::Environment::EffectRackItem_base*>(_cache)->effects():static_cast<Arts::Environment::EffectRackItem_base*>(_method_call())->effects();
}

inline long Arts::Environment::EffectRackItem::effectCount()
{
	return _cache?static_cast<Arts::Environment::EffectRackItem_base*>(_cache)->effectCount():static_cast<Arts::Environment::EffectRackItem_base*>(_method_call())->effectCount();
}

inline std::string Arts::Environment::EffectRackItem::name()
{
	return _cache?static_cast<Arts::Environment::EffectRackItem_base*>(_cache)->name():static_cast<Arts::Environment::EffectRackItem_base*>(_method_call())->name();
}

inline void Arts::Environment::EffectRackItem::name(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Environment::EffectRackItem_base*>(_cache)->name(_newValue):static_cast<Arts::Environment::EffectRackItem_base*>(_method_call())->name(_newValue);
}

inline Arts::StereoEffect Arts::Environment::EffectRackItem::createEffect(const std::string& type, const std::string& name)
{
	return _cache?static_cast<Arts::Environment::EffectRackItem_base*>(_cache)->createEffect(type, name):static_cast<Arts::Environment::EffectRackItem_base*>(_method_call())->createEffect(type, name);
}

inline void Arts::Environment::EffectRackItem::delEffect(long pos)
{
	 _cache?static_cast<Arts::Environment::EffectRackItem_base*>(_cache)->delEffect(pos):static_cast<Arts::Environment::EffectRackItem_base*>(_method_call())->delEffect(pos);
}

inline void Arts::Environment::EffectRackItem::routeToMaster(long pos, bool tomaster)
{
	 _cache?static_cast<Arts::Environment::EffectRackItem_base*>(_cache)->routeToMaster(pos, tomaster):static_cast<Arts::Environment::EffectRackItem_base*>(_method_call())->routeToMaster(pos, tomaster);
}

inline bool Arts::MixerItemGui::active()
{
	return _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->active():static_cast<Arts::MixerItemGui_base*>(_method_call())->active();
}

inline void Arts::MixerItemGui::active(bool _newValue)
{
	 _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->active(_newValue):static_cast<Arts::MixerItemGui_base*>(_method_call())->active(_newValue);
}

inline long Arts::MixerItemGui::channelCount()
{
	return _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->channelCount():static_cast<Arts::MixerItemGui_base*>(_method_call())->channelCount();
}

inline void Arts::MixerItemGui::channelCount(long _newValue)
{
	 _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->channelCount(_newValue):static_cast<Arts::MixerItemGui_base*>(_method_call())->channelCount(_newValue);
}

inline std::string Arts::MixerItemGui::type()
{
	return _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->type():static_cast<Arts::MixerItemGui_base*>(_method_call())->type();
}

inline void Arts::MixerItemGui::type(const std::string& _newValue)
{
	 _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->type(_newValue):static_cast<Arts::MixerItemGui_base*>(_method_call())->type(_newValue);
}

inline Arts::Widget Arts::MixerItemGui::initialize(Arts::Environment::MixerItem item)
{
	return _cache?static_cast<Arts::MixerItemGui_base*>(_cache)->initialize(item):static_cast<Arts::MixerItemGui_base*>(_method_call())->initialize(item);
}

inline bool Arts::EffectRackItemGui::active()
{
	return _cache?static_cast<Arts::EffectRackItemGui_base*>(_cache)->active():static_cast<Arts::EffectRackItemGui_base*>(_method_call())->active();
}

inline void Arts::EffectRackItemGui::active(bool _newValue)
{
	 _cache?static_cast<Arts::EffectRackItemGui_base*>(_cache)->active(_newValue):static_cast<Arts::EffectRackItemGui_base*>(_method_call())->active(_newValue);
}

inline std::string Arts::EffectRackItemGui::type()
{
	return _cache?static_cast<Arts::EffectRackItemGui_base*>(_cache)->type():static_cast<Arts::EffectRackItemGui_base*>(_method_call())->type();
}

inline void Arts::EffectRackItemGui::type(const std::string& _newValue)
{
	 _cache?static_cast<Arts::EffectRackItemGui_base*>(_cache)->type(_newValue):static_cast<Arts::EffectRackItemGui_base*>(_method_call())->type(_newValue);
}

inline bool Arts::EffectRackItemGui::addeffect()
{
	return _cache?static_cast<Arts::EffectRackItemGui_base*>(_cache)->addeffect():static_cast<Arts::EffectRackItemGui_base*>(_method_call())->addeffect();
}

inline void Arts::EffectRackItemGui::addeffect(bool _newValue)
{
	 _cache?static_cast<Arts::EffectRackItemGui_base*>(_cache)->addeffect(_newValue):static_cast<Arts::EffectRackItemGui_base*>(_method_call())->addeffect(_newValue);
}

inline void Arts::EffectRackItemGui::removeSlot(Arts::EffectRackSlot slot)
{
	 _cache?static_cast<Arts::EffectRackItemGui_base*>(_cache)->removeSlot(slot):static_cast<Arts::EffectRackItemGui_base*>(_method_call())->removeSlot(slot);
}

inline void Arts::EffectRackItemGui::routeToMaster(Arts::EffectRackSlot slot, bool tomaster)
{
	 _cache?static_cast<Arts::EffectRackItemGui_base*>(_cache)->routeToMaster(slot, tomaster):static_cast<Arts::EffectRackItemGui_base*>(_method_call())->routeToMaster(slot, tomaster);
}

inline Arts::Widget Arts::EffectRackItemGui::initialize(Arts::Environment::EffectRackItem item)
{
	return _cache?static_cast<Arts::EffectRackItemGui_base*>(_cache)->initialize(item):static_cast<Arts::EffectRackItemGui_base*>(_method_call())->initialize(item);
}

inline bool Arts::EffectRackSlot::removeslot()
{
	return _cache?static_cast<Arts::EffectRackSlot_base*>(_cache)->removeslot():static_cast<Arts::EffectRackSlot_base*>(_method_call())->removeslot();
}

inline void Arts::EffectRackSlot::removeslot(bool _newValue)
{
	 _cache?static_cast<Arts::EffectRackSlot_base*>(_cache)->removeslot(_newValue):static_cast<Arts::EffectRackSlot_base*>(_method_call())->removeslot(_newValue);
}

inline bool Arts::EffectRackSlot::tomaster()
{
	return _cache?static_cast<Arts::EffectRackSlot_base*>(_cache)->tomaster():static_cast<Arts::EffectRackSlot_base*>(_method_call())->tomaster();
}

inline void Arts::EffectRackSlot::tomaster(bool _newValue)
{
	 _cache?static_cast<Arts::EffectRackSlot_base*>(_cache)->tomaster(_newValue):static_cast<Arts::EffectRackSlot_base*>(_method_call())->tomaster(_newValue);
}

inline Arts::EffectRackSlot::EffectRackSlot(Arts::Widget parent, Arts::Widget effect, Arts::EffectRackItemGui effectrackgui)
		: Arts::Object(EffectRackSlot_base::_create())
{
	static_cast<Arts::EffectRackSlot_base*>(_method_call())->constructor(parent, effect, effectrackgui);
}

inline Arts::Widget Arts::MixerGuiFactory::createGui(Arts::Object runningObject)
{
	return _cache?static_cast<Arts::GuiFactory_base*>(_cache)->createGui(runningObject):static_cast<Arts::GuiFactory_base*>(_method_call())->createGui(runningObject);
}

inline Arts::Widget Arts::EffectRackGuiFactory::createGui(Arts::Object runningObject)
{
	return _cache?static_cast<Arts::GuiFactory_base*>(_cache)->createGui(runningObject):static_cast<Arts::GuiFactory_base*>(_method_call())->createGui(runningObject);
}

#endif /* ARTSMODULESCOMMON_H */
