# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 836 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/_process_set_once.al)"
# Process option '-set_once' or '-set_once_or_FOO'.
# Return: none, but \%opts is modified.
sub _process_set_once {
    my ($class, $option, $opts) = @_;

    return unless $option =~ CMM_SET_ONCE_OPTION;
    my $action_name = $1 || 'die';
    my $use = '';

    if ($action_name eq 'ignore') {
        $opts->{'-set_once'} = sub { };
    }
    elsif ($action_name =~ /(carp|cluck|croak|confess)|die|warn/){
        $use = defined($1) && length($1) ? "use Carp qw($action_name);" : '';
        $opts->{'-set_once'} = eval "sub { $use $action_name(\@_) }";
    }else {
        $opts->{'-set_once'} = eval "sub { \$_[0]->$action_name(\@_[1..\$#_]) }";
    }
    return;
}

# end of Class::MethodMaker::_process_set_once
1;
