%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.0, (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License at
%% http://www.erlang.org/EPL1_0.txt
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Original Code is Erlang-4.7.3, December, 1998.
%% 
%% The Initial Developer of the Original Code is Ericsson Telecom
%% AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
%% Telecom AB. All Rights Reserved.
%% 
%% Contributor(s): ______________________________________.''
%%
%%% File    : reply.erl
%%% Author  : Gordon Beaton <gordon@erix.ericsson.se>
%%% Purpose : Syncronisation with erl_start (erl_interface)
%%% Created : 30 Sep 1997 by Gordon Beaton <gordon@erix.ericsson.se>

-module(erl_reply).
-author('gordon@erix.ericsson.se').
-export([reply/1]).

%% send Msg to Addr:Port
%% all args are atoms since we call this from erl command line
reply([Addr,Port,Msg]) ->
    Ip = ip_string_to_tuple(atom_to_list(Addr)),
    P = list_to_integer(atom_to_list(Port)),
    M = atom_to_list(Msg),
    {ok, S} = gen_tcp:connect(Ip,P,[]),
    gen_tcp:send(S,M),
    gen_tcp:close(S),
    reply_done;

reply(X) ->
    error_logger:error_msg("erl_reply: Can't find address and port "
			   "to reply to~n").

%% convert ip number to tuple
ip_string_to_tuple(Ip) ->
    [Ip1,Ip2,Ip3,Ip4] = string:tokens(Ip,"."),
    {list_to_integer(Ip1),
     list_to_integer(Ip2),
     list_to_integer(Ip3),
     list_to_integer(Ip4)}.
    

