<?php
/*
 * $Horde: kronolith/workweek.php,v 1.9.2.1 2002/03/19 02:10:41 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once KRONOLITH_BASE . '/lib/WeekView.php';

$week = Horde::getFormData('week');
$year = Horde::getFormData('year');
if ($timestamp = Horde::getFormData('timestamp')) {
    $year = date('Y', $timestamp);
    $week = Kronolith::weekOfYear(date('d', $timestamp), date('m', $timestamp), $year);
}

$weekOb = new Kronolith_WeekView($week, $year, 0, 4);
$title = sprintf(_("Week %d"), $weekOb->week);
$js_onLoad = null;

if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

require KRONOLITH_TEMPLATES . '/common-header.inc';
require './menu.php';

$weekOb->html(KRONOLITH_TEMPLATES);

require KRONOLITH_TEMPLATES . '/common-footer.inc';

?>
