<?php
/*
 * $Horde: kronolith/status.php,v 1.12 2002/01/24 22:29:54 chuck Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

// get any alarms in the next hour
$now = mktime();
$current_date = Kronolith::timestampToObject($now);
$events = $calendar->listAlarms($current_date);
$messages = array();
foreach ($events as $eventID) {
	$thisEvent = $calendar->getEventObject($eventID);
    $differential = $thisEvent->getStartTimestamp($now) - $now;
    $key = $thisEvent->getStartTimestamp();
    while (isset($messages[$key])) {
        $key++;
    }
    if ($differential >= -60 && $differential < 60) {
        $messages[$key] = array(sprintf(_("%s is starting now."), $thisEvent->getTitle()), 'kronolith.alarm');
    } else if ($differential < 0 && $now <= $thisEvent->getEndTimestamp()) {
        $messages[$key] = array(sprintf(_("%s is in progress."), $thisEvent->getTitle()), 'kronolith.event');
    } else if ($differential >= 60 && $differential < 7200) {
        $messages[$key] = array(sprintf(_("%s starts in %s"), $thisEvent->getTitle(), Kronolith::secondsToString($differential)), 'kronolith.alarm');
    }
}

ksort($messages);
foreach ($messages as $message) {
    $notification->push($message[0], $message[1]);
}

$notification->notify();

?>
