# Copyright (c) 2003 Hyriand. All rights reserved.
#
import gtk

from transferlist import TransferList
from utils import PopupMenu

from pynicotine.utils import _

class Uploads(TransferList):
	def __init__(self, frame):
		TransferList.__init__(self, frame, frame.UploadList)

		self.popup_menu = popup = PopupMenu(frame)
		popup.setup(
			(_("Copy URL"), self.OnCopyURL),
			(_("Copy folder URL"), self.OnCopyDirURL),
			("", None),
			(_("Send message"), popup.OnSendMessage),
			(_("Show IP address"), popup.OnShowIPaddress),
			(_("Get user info"), popup.OnGetUserInfo),
			(_("Browse files"), popup.OnBrowseUser),
			("$" + _("Add user to list"), popup.OnAddToList),
			("$" + _("Ban this user"), popup.OnBanUser),
			("$" + _("Ignore this user"), popup.OnIgnoreUser),
			("", None),
			(_("Abort"), self.OnAbortTransfer),
			(_("Clear"), self.OnClearTransfer),
			("", None),
			(_("Clear finished/aborted"), self.OnClearFinishedAborted),
			(_("Clear finished"), self.OnClearFinished),
			(_("Clear aborted"), self.OnClearAborted),
			(_("Clear queued"), self.OnClearQueued),
		)
		frame.UploadList.connect("button_press_event", self.OnPopupMenu)
	
	def OnPopupMenu(self, widget, event):
		if event.button != 3:
			return gtk.FALSE
		
		self.selected_transfers = []
		self.selected_users = []
		self.widget.get_selection().selected_foreach(self.SelectedTransfersCallback)

		items = self.popup_menu.get_children()

		act = gtk.FALSE
		if len(self.selected_transfers) == 1:
			act = gtk.TRUE
		items[0].set_sensitive(act)
		items[1].set_sensitive(act)

		act = gtk.FALSE
		if len(self.selected_users) == 1:
			user = self.selected_users[0]
			self.popup_menu.set_user(user)
			act = gtk.TRUE
			items[7].set_active(user in [i[0] for i in self.frame.np.config.sections["server"]["userlist"]])
			items[8].set_active(user in self.frame.np.config.sections["server"]["banlist"])
			items[9].set_active(user in self.frame.np.config.sections["server"]["ignorelist"])

		for i in range(3, 10):
			items[i].set_sensitive(act)
		
		act = len(self.selected_transfers) and gtk.TRUE or gtk.FALSE
		for i in range(11, 13):
			items[i].set_sensitive(act)
		
		self.popup_menu.popup(None, None, None, event.button, event.time)
		
		widget.emit_stop_by_name("button_press_event")
		return gtk.TRUE
		
	def ClearByUser(self, user):
		for i in self.list[:]:
			if i.user == user:
				if i.transfertimer is not None:
					i.transfertimer.cancel()
				self.list.remove(i)
		self.frame.np.transfers.calcUploadQueueSizes()
		self.frame.np.transfers.checkUploadQueue()
		self.update()

	def OnAbortTransfer(self, widget, remove = gtk.FALSE, clear = gtk.FALSE):
		TransferList.OnAbortTransfer(self, widget, remove, clear)
		self.frame.np.transfers.calcUploadQueueSizes()
		self.frame.np.transfers.checkUploadQueue()

	def OnClearQueued(self, widget):
		TransferList.OnClearQueued(self, widget)
		self.frame.np.transfers.calcUploadQueueSizes()
