#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10131);
 script_version ("$Revision: 1.15 $");
 script_bugtraq_id(2002);
 script_cve_id("CVE-1999-0260");
 name["english"] = "jj cgi";
 name["francais"] = "jj cgi";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The 'jj' CGI is installed. This CGI has
a well known security flaw that lets an attacker execute arbitrary
commands with the privileges of the http daemon (usually root or nobody).

Solution : Remove it from /cgi-bin.

Risk factor : Serious";


 desc["francais"] = "Le cgi 'jj' est install. Celui-ci possde
un problme de scurit bien connu qui permet  n'importe qui de faire
executer des commandes arbitraires au daemon http, avec les privilges
de celui-ci (root ou nobody). 

Solution : retirez-le de /cgi-bin.

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/jj";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/jj";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = is_cgi_installed("jj");
if(port)security_hole(port);

