/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kaffe.util.NotImplemented;

public class GregorianCalendar
extends Calendar {
    private static final Calendar stdDateChange = new GregorianCalendar(1582, 9, 15);
    private static final long serialVersionUID = -8125100834729963327L;
    public static final int BC = 0;
    public static final int AD = 1;
    private static final long MILLISECSPERSEC = 1000L;
    private static final long MILLISECSPERMIN = 60000L;
    private static final long MILLISECSPERHOUR = 3600000L;
    private static final long MILLISECSPERDAY = 86400000L;
    private static final int DAYSPERWEEK = 7;
    private static final int EPOCH_WDAY = 4;
    private static final int EPOCH_YEAR = 1970;
    private Calendar dateChange = null;
    private static /* synthetic */ Class class$Ljava$util$GregorianCalendar;

    public void add(int n, int n2) {
        if (n == 15 || n == 16) {
            throw new IllegalArgumentException("bad field: " + n);
        }
        if (!this.isSet[n]) {
            this.computeFields();
        }
        int n3 = n;
        this.fields[n3] = this.fields[n3] + n2;
        this.computeTime();
        this.computeFields();
    }

    public boolean after(Object object) {
        try {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            if (this.getTimeInMillis() > gregorianCalendar.getTimeInMillis()) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public boolean before(Object object) {
        try {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            if (this.getTimeInMillis() < gregorianCalendar.getTimeInMillis()) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    private long computeDateTime() {
        int n;
        int n2;
        long l = 0L;
        if (this.isSet[1]) {
            n2 = this.fields[1];
            n = 1970;
            while (n < n2) {
                l = this.isLeapYear(n) ? (l += 366L) : (l += 365L);
                ++n;
            }
        }
        if (this.isSet[2]) {
            n2 = this.fields[2];
            n = 0;
            while (n < n2) {
                switch (n) {
                    default: {
                        l += 31L;
                        break;
                    }
                    case 1: {
                        if (this.isLeapYear(this.fields[1])) {
                            l += 29L;
                            break;
                        }
                        l += 28L;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 8: 
                    case 10: {
                        l += 30L;
                        break;
                    }
                }
                ++n;
            }
            if (this.isSet[5]) {
                l += (long)(this.fields[5] - 1);
            } else {
                if (this.isSet[4] && this.isSet[7]) {
                    throw new NotImplemented((class$Ljava$util$GregorianCalendar != null ? class$Ljava$util$GregorianCalendar : (class$Ljava$util$GregorianCalendar = GregorianCalendar.class$("java.util.GregorianCalendar"))).getName() + ".computeDateTime() " + "with WEEK_OF_MONTH and DAY_OF_WEEK set.");
                }
                if (this.isSet[8] && this.isSet[7]) {
                    throw new NotImplemented((class$Ljava$util$GregorianCalendar != null ? class$Ljava$util$GregorianCalendar : (class$Ljava$util$GregorianCalendar = GregorianCalendar.class$("java.util.GregorianCalendar"))).getName() + ".computeDateTime() " + "with WEEK_OF_MONTH_IN_MONTH and DAY_OF_WEEK set.");
                }
            }
        } else if (this.isSet[6]) {
            l += (long)this.fields[6];
        } else if (this.isSet[7] && this.isSet[3]) {
            throw new NotImplemented((class$Ljava$util$GregorianCalendar != null ? class$Ljava$util$GregorianCalendar : (class$Ljava$util$GregorianCalendar = GregorianCalendar.class$("java.util.GregorianCalendar"))).getName() + ".computeDateTime() " + "with DAY_OF_WEEK and WEEK_OF_YEAR set.");
        }
        l *= 24L;
        if (this.isSet[11]) {
            l += (long)this.fields[11];
        } else if (this.isSet[9] && this.isSet[10]) {
            l += (long)this.fields[10];
            if (this.fields[9] == 1) {
                l += 12L;
            }
        }
        l *= 60L;
        if (this.isSet[12]) {
            l += (long)this.fields[12];
        }
        l *= 60L;
        if (this.isSet[13]) {
            l += (long)this.fields[13];
        }
        l *= 1000L;
        if (this.isSet[14]) {
            l += (long)this.fields[14];
        }
        if (this.isSet[15]) {
            l += (long)this.fields[15];
        }
        return l;
    }

    protected void computeFields() {
        long l = this.getTimeZone().getRawOffset();
        this.computeFields(this.time + l);
        long l2 = this.getTimeZone().getOffset(this.fields[0], this.fields[1], this.fields[2], this.fields[5], this.fields[7], this.fields[14]);
        if (l2 != l) {
            this.computeFields(this.time + l2);
        }
        this.areFieldsSet = true;
    }

    private void computeFields(long l) {
        int n;
        long l2 = l;
        long l3 = l2 / 86400000L;
        int n2 = (int)((l2 %= 86400000L) / 3600000L);
        int n3 = (int)((l2 %= 3600000L) / 60000L);
        int n4 = (int)((l2 %= 60000L) / 1000L);
        int n5 = (int)(l2 % 1000L);
        int n6 = (int)((4L + l3) % 7L);
        int n7 = 1970;
        long l4 = 0L;
        while (true) {
            int n8 = n = this.isLeapYear(n7) ? 1 : 0;
            if (l3 < (long)(365 + n)) break;
            l4 += (long)(365 + n);
            l3 -= (long)(365 + n);
            ++n7;
        }
        long l5 = l4;
        int n9 = 0;
        int n10 = (int)l3;
        while (true) {
            long l6;
            switch (n9) {
                default: {
                    l6 = 31L;
                    break;
                }
                case 1: {
                    l6 = 28 + n;
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: {
                    l6 = 30L;
                    break;
                }
            }
            if (l3 < l6) break;
            ++n9;
            l3 -= l6;
            l5 += l6;
        }
        if (n7 < 1) {
            this.set(0, 0);
        } else {
            this.set(0, 1);
        }
        this.set(1, n7);
        this.set(2, n9);
        this.set(5, 1 + (int)l3);
        this.set(6, n10);
        this.set(7, n6 + 1);
        if (n2 < 12) {
            this.set(9, 0);
            this.set(10, n2);
        } else {
            this.set(9, 1);
            this.set(10, n2 - 12);
        }
        this.set(11, n2);
        this.set(12, n3);
        this.set(13, n4);
        this.set(14, n5);
        int n11 = (int)((4L + l4) % 7L);
        int n12 = (n11 + n10) / 7;
        this.set(3, n12);
        this.set(8, 1 + (int)l3 / 7);
        int n13 = (int)((4L + l5) % 7L);
        int n14 = (n13 + (int)l3) / 7;
        this.set(4, n14);
    }

    protected void computeTime() {
        long l = this.getTimeZone().getOffset(this.fields[0], this.fields[1], this.fields[2], this.fields[5], this.fields[7], this.fields[14]);
        this.time = this.computeDateTime() - l;
        this.isTimeSet = true;
    }

    public boolean equals(Object object) {
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            if (this.isLenient() == gregorianCalendar.isLenient() && this.getFirstDayOfWeek() == gregorianCalendar.getFirstDayOfWeek() && this.getMinimalDaysInFirstWeek() == gregorianCalendar.getMinimalDaysInFirstWeek() && this.getTimeZone() == gregorianCalendar.getTimeZone() && this.getTime() == gregorianCalendar.getTime()) {
                return true;
            }
        }
        return false;
    }

    public int getGreatestMinimum(int n) {
        return this.getMinimum(n);
    }

    public final Date getGregorianChange() {
        if (this.dateChange == null) {
            return stdDateChange.getTime();
        }
        return this.dateChange.getTime();
    }

    public int getLeastMaximum(int n) {
        switch (n) {
            case 5: {
                return 28;
            }
        }
        return this.getMaximum(n);
    }

    public int getMaximum(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 9999;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 52;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 366;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 0;
            }
            case 10: 
            case 11: {
                return 23;
            }
            case 12: {
                return 59;
            }
            case 13: {
                return 59;
            }
            case 14: {
                return 999;
            }
            case 15: {
                return 0;
            }
            case 16: {
                return 0;
            }
        }
        return 0;
    }

    public int getMinimum(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 7: 
            case 8: {
                return 1;
            }
            case 9: {
                return 0;
            }
            case 10: 
            case 11: {
                return 0;
            }
            case 12: {
                return 0;
            }
            case 13: {
                return 0;
            }
            case 14: {
                return 0;
            }
            case 15: {
                return 0;
            }
            case 16: {
                return 0;
            }
        }
        return 0;
    }

    public synchronized int hashCode() {
        return this.getFirstDayOfWeek() ^ this.getMinimalDaysInFirstWeek();
    }

    public boolean isLeapYear(int n) {
        if (n % 400 == 0) {
            return true;
        }
        if (n % 100 == 0) {
            return false;
        }
        return n % 4 == 0;
    }

    public void roll(int n, boolean bl) {
        if (n == 15 || n == 16) {
            throw new IllegalArgumentException("bad field: " + n);
        }
        if (!this.isSet[n]) {
            this.computeFields();
        }
        if (bl) {
            if (this.fields[n] == this.getMaximum(n)) {
                this.fields[n] = this.getMinimum(n);
            } else {
                int n2 = n;
                this.fields[n2] = this.fields[n2] + 1;
            }
        } else if (this.fields[n] == this.getMinimum(n)) {
            this.fields[n] = this.getMaximum(n);
        } else {
            int n3 = n;
            this.fields[n3] = this.fields[n3] - 1;
        }
        this.computeTime();
        this.computeFields();
    }

    public void setGregorianChange(Date date) {
        this.dateChange = Calendar.getInstance();
        this.dateChange.setTime(date);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(Locale locale2) {
        this(TimeZone.getDefault(), locale2);
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale2) {
        super(timeZone, locale2);
        this.setTime(new Date());
    }

    public GregorianCalendar(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        this.set(n, n2, n3, n4, n5);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        this.set(n, n2, n3, n4, n5, n6);
    }
}

