/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StringBuffer
implements Serializable {
    private static final long serialVersionUID = 3388685877147921107L;
    private final int SPARECAPACITY;
    char[] buffer;
    int used;
    boolean isStringized;

    public StringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public StringBuffer append(String string) {
        if (string == null) {
            string = "null";
        }
        return this.append(string.value, string.offset, string.count);
    }

    public StringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public synchronized StringBuffer append(char c) {
        if (this.used + 1 > this.buffer.length || this.isStringized) {
            this.ensureCapacity(this.used + 1, this.isStringized);
        }
        this.buffer[this.used++] = c;
        return this;
    }

    public StringBuffer append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public synchronized StringBuffer append(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.used + n2 > this.buffer.length || this.isStringized) {
            this.ensureCapacity(this.used + n2, this.isStringized);
        }
        System.arraycopy(cArray, n, this.buffer, this.used, n2);
        this.used += n2;
        return this;
    }

    public StringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public StringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public StringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public StringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public int capacity() {
        return this.buffer.length;
    }

    public synchronized char charAt(int n) {
        if (n >= this.used) {
            throw new StringIndexOutOfBoundsException();
        }
        return this.buffer[n];
    }

    public synchronized StringBuffer deleteCharAt(int n) {
        if (n < 0 || n >= this.used) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, n + 1, this.buffer, n, --this.used - n);
        return this;
    }

    public synchronized StringBuffer delete(int n, int n2) {
        if (n2 > this.used) {
            n2 = this.used;
        }
        if (n < 0 || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, n2, this.buffer, n, this.used - n2);
        this.used -= n2 - n;
        return this;
    }

    public synchronized StringBuffer replace(int n, int n2, String string) {
        return this.delete(n, n2).insert(n, string);
    }

    public synchronized String substring(int n) {
        return this.substring(n, this.used);
    }

    public synchronized String substring(int n, int n2) {
        int n3 = n2 - n;
        if (n < 0 || n2 > this.used || n3 < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.buffer.length - n3 > 32) {
            return new String(this.buffer, n, n2);
        }
        this.isStringized = true;
        return new String(n, n2, this.buffer);
    }

    public void ensureCapacity(int n) {
        if (n <= 0) {
            return;
        }
        StringBuffer stringBuffer = this;
        synchronized (stringBuffer) {
            this.ensureCapacity(n, false);
        }
    }

    private boolean ensureCapacity(int n, boolean bl) {
        if (!bl && n <= this.buffer.length) {
            return false;
        }
        if (n < this.used) {
            n = this.used;
        } else if (n < this.buffer.length * 2 + 2) {
            n = this.buffer.length * 2 + 2;
        }
        char[] cArray = new char[n];
        System.arraycopy(this.buffer, 0, cArray, 0, this.used);
        this.buffer = cArray;
        this.isStringized = false;
        return true;
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        if (n2 > this.used) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, n, cArray, n3, n2 - n);
    }

    public synchronized StringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public synchronized StringBuffer insert(int n, String string) {
        if (string == null) {
            string = "null";
        }
        return this.insert(n, string.value, string.offset, string.count);
    }

    public StringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public synchronized StringBuffer insert(int n, char c) {
        return this.insert(n, new char[]{c}, 0, 1);
    }

    public StringBuffer insert(int n, char[] cArray) {
        return this.insert(n, cArray, 0, cArray.length);
    }

    public synchronized StringBuffer insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this.used) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.used + n3 > this.buffer.length || this.isStringized) {
            this.ensureCapacity(this.used + n3, this.isStringized);
        }
        System.arraycopy(this.buffer, n, this.buffer, n + n3, this.used - n);
        System.arraycopy(cArray, n2, this.buffer, n, n3);
        this.used += cArray.length;
        return this;
    }

    public StringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public StringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public StringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public int length() {
        return this.used;
    }

    public synchronized StringBuffer reverse() {
        if (this.isStringized) {
            this.ensureCapacity(this.used, true);
        }
        int n = this.used / 2 - 1;
        while (n >= 0) {
            char c = this.buffer[n];
            this.buffer[n] = this.buffer[this.used - n - 1];
            this.buffer[this.used - n - 1] = c;
            --n;
        }
        return this;
    }

    public synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this.used) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.isStringized) {
            this.ensureCapacity(this.used, true);
        }
        this.buffer[n] = c;
    }

    public synchronized void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        boolean bl = this.ensureCapacity(n, this.isStringized || n < this.buffer.length / 2);
        if (!bl && n > this.used) {
            int n2 = this.used;
            while (n2 < n) {
                this.buffer[n2] = '\u0000';
                ++n2;
            }
        }
        this.used = n;
    }

    public String toString() {
        return new String(this);
    }

    public StringBuffer() {
        this.SPARECAPACITY = 16;
        this.buffer = new char[16];
    }

    public StringBuffer(String string) {
        this.SPARECAPACITY = 16;
        this.used = string.count;
        this.buffer = new char[this.used + 16];
        System.arraycopy(string.value, string.offset, this.buffer, 0, this.used);
    }

    public StringBuffer(int n) {
        this.SPARECAPACITY = 16;
        this.buffer = new char[n];
    }
}

