/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.loader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tomcat.core.ServletLoader;
import org.apache.tomcat.loader.AdaptiveClassLoader;
import org.apache.tomcat.loader.ClassRepository;
import org.apache.tomcat.util.FileUtil;

public class AdaptiveServletLoader
extends AdaptiveClassLoader
implements ServletLoader {
    AdaptiveClassLoader classL;
    static boolean jdk12 = false;
    Vector classP = new Vector();
    ClassLoader parent;

    public void setParentLoader(ClassLoader p) {
        this.parent = p;
    }

    public ClassLoader getParentLoader() {
        return this.getClassLoader();
    }

    public boolean shouldReload(String className) {
        if (this.classL == null) {
            this.getClassLoader();
        }
        boolean should = this.classL.shouldReload(className);
        return should;
    }

    public boolean shouldReload() {
        if (this.classL == null) {
            this.getClassLoader();
        }
        boolean should = this.classL.shouldReload();
        return should;
    }

    public void reload() {
        if (this.classL == null) {
            this.getClassLoader();
        } else {
            this.classL = this.classL.reinstantiate();
        }
    }

    public ClassLoader getClassLoader() {
        if (this.classL != null) {
            return this.classL;
        }
        if (jdk12) {
            try {
                Class<?> ld = Class.forName("org.apache.tomcat.loader.AdaptiveClassLoader12");
                this.classL = (AdaptiveClassLoader)ld.newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (this.classL == null) {
            this.classL = new AdaptiveClassLoader();
        }
        this.classL.setParent(this.parent);
        this.classL.setRepository(this.classP);
        return this.classL;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.classL == null) {
            this.getClassLoader();
        }
        return this.classL.loadClass(name, true);
    }

    public String getClassPath() {
        String separator = System.getProperty("path.separator", ":");
        String cpath = "";
        Enumeration e = this.classP.elements();
        while (e.hasMoreElements()) {
            ClassRepository cp = (ClassRepository)e.nextElement();
            File f = cp.getFile();
            if (cpath.length() > 0) {
                cpath = cpath + separator;
            }
            cpath = cpath + f;
        }
        return cpath;
    }

    public void addRepository(File f, Object pd) {
        try {
            this.classP.addElement(new ClassRepository(new File(FileUtil.patch(f.getCanonicalPath())), pd));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void addRepository(URL url) {
    }

    public String toString() {
        return "AdaptiveServletLoader( " + this.getClassPath() + " ) using " + this.classL;
    }

    static {
        try {
            Class.forName("java.security.PrivilegedAction");
            jdk12 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

