/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  en Automatique.  All rights reserved.  This file is distributed    */
/*  under the terms of the GNU Library General Public License, with    */
/*  the special exception on linking described in file ../LICENSE.     */
/*                                                                     */
/***********************************************************************/

/* $Id: fail.h,v 1.20 2003/06/19 15:53:49 xleroy Exp $ */

#ifndef _fail_
#define _fail_

#include "misc.h"
#include "mlvalues.h"


CAMLextern void mlraise (value bucket) Noreturn;
CAMLextern void raise_constant (value tag) Noreturn;
CAMLextern void raise_with_arg (value tag, value arg) Noreturn;
CAMLextern void raise_with_string (value tag, char * msg) Noreturn;
CAMLextern void failwith (char *) Noreturn;
CAMLextern void invalid_argument (char *) Noreturn;
CAMLextern void raise_out_of_memory (void) Noreturn;
CAMLextern void raise_stack_overflow (void) Noreturn;
CAMLextern void raise_sys_error (value) Noreturn;
CAMLextern void raise_end_of_file (void) Noreturn;
CAMLextern void raise_zero_divide (void) Noreturn;
CAMLextern void raise_not_found (void) Noreturn;
CAMLextern void init_exceptions (void);
CAMLextern void array_bound_error (void) Noreturn;
CAMLextern void raise_sys_blocked_io (void) Noreturn;


#endif /* _fail_ */
