<?php
// $Horde: kronolith/lib/Event.php,v 1.13.2.2 2002/05/17 22:58:15 jan Exp $

/**
 * Kronolith_Event:: defines a generic API for events
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.13.2.2 $
 * @since   Kronolith 0.1
 * @package kronolith
 */
class Kronolith_Event {

    var $driver = null;
    var $initialized = false;
    var $eventID = null;
    var $title = '';
    var $category = '';
    var $location = '';
    var $description = '';
    var $keywords = array();
    var $exceptions = array();
    var $startTimestamp = 0;
    var $endTimestamp = 0;
    var $durMin = 0;
    var $alarm = 0;
    var $recurEndTimestamp = null;
    var $recurType = KRONOLITH_RECUR_NONE;
    var $recurInterval = null;
    var $recurData = null;

    function Kronolith_Event(&$driver, $eventObject = null)
    {
        $this->driver = &$driver;

        if (isset($eventObject)) {
            $this->fromDriver($eventObject);
        }
    }

    function createEvent()
    {
        $this->toDriver();
        $this->initialized = true;
    }

    function save()
    {
        if (!$this->initialized) {
            return false;
        }

        $this->toDriver();
        return $this->driver->saveEvent($this);
    }

    function addException($year, $month, $day)
    {
        $this->exceptions[] = sprintf("%04d%02d%02d", $year, $month, $day);
    }

    function hasException($year, $month, $day)
    {
        return in_array(sprintf("%04d%02d%02d", $year, $month, $day), $this->getExceptions());
    }

    function getExceptions()
    {
        return $this->exceptions;
    }

    function isInitialized()
    {
        return $this->initialized;
    }

    function recurOnDay($dayMask)
    {
        return ($this->recurData & $dayMask);
    }

    function setRecurOnDay($dayMask)
    {
        $this->recurData = $dayMask;
    }

    function getRecurOnDays()
    {
        return $this->recurData;
    }

    function getRecurType()
    {
        return $this->recurType;
    }

    function hasRecurType($recurrence)
    {
        return ($recurrence === $this->recurType);
    }

    function setRecurType($recurrence)
    {
        $this->recurType = $recurrence;
    }

    function setRecurInterval($interval)
    {
        $this->recurInterval = $interval;
    }

    function getRecurInterval()
    {
        return $this->recurInterval;
    }

    function setID($eventID)
    {
        $this->eventID = $eventID;
    }

    function getID()
    {
        return $this->eventID;
    }

    function setTitle($title)
    {
        $this->title = $title;
    }

    function getTitle()
    {
        return $this->title;
    }

    function setDescription($description)
    {
        $this->description = $description;
    }

    function getDescription()
    {
        return $this->description;
    }

    function setCategory($category)
    {
        $this->category = $category;
    }

    function getCategory()
    {
        return $this->category;
    }

    function setLocation($location)
    {
        $this->location = $location;
    }

    function getLocation()
    {
        return $this->location;
    }

    function setStartTimestamp($startTimestamp)
    {
        $this->startTimestamp = $startTimestamp;
        list($this->start->mday, $this->start->month, $this->start->year,
             $this->start->hour, $this->start->min, $this->start->sec) =
             explode(':', date('d:m:Y:H:i:s', $startTimestamp));
    }

    function setKeywords($keywords)
    {
        $this->keywords = $keywords;
    }

    function getKeywords()
    {
        return $this->keywords;
    }

    function hasKeyword($keyword)
    {
        return in_array($keyword, $this->keywords);
    }

    function getStartTimestamp($dayTimestamp = null)
    {
        if (!isset($dayTimestamp)) {
            return $this->startTimestamp;
        }

        list($year, $month, $day) = explode(':', date('Y:n:j', $dayTimestamp));
        list($hour, $min, $sec) = explode(':', date('G:i:s', $this->startTimestamp));

        return mktime($hour, $min, $sec, $month, $day, $year);
    }

    function getStartDate($formatString, $dayTimestamp = null)
    {
        return date($formatString, $this->getStartTimestamp($dayTimestamp));
    }

    function setEndTimestamp($endTimestamp)
    {
        $this->endTimestamp = $endTimestamp;
        list($this->end->mday, $this->end->month, $this->end->year,
             $this->end->hour, $this->end->min, $this->end->sec) =
             explode(':', date('d:m:Y:H:i:s', $endTimestamp));
    }

    function getEndTimestamp($dayTimestamp = null)
    {
        if (!isset($dayTimestamp)) {
            return $this->endTimestamp;
        }

        list($year, $month, $day) = explode(':', date('Y:n:j', $dayTimestamp));
        list($hour, $min, $sec) = explode(':', date('G:i:s', $this->endTimestamp));

        return mktime($hour, $min, $sec, $month, $day, $year);
    }

    function getEndDate($formatString, $dayTimestamp = null)
    {
        return date($formatString, $this->getEndTimestamp($dayTimestamp));
    }

    function setRecurEndTimestamp($recurTimestamp)
    {
        $this->recurEndTimestamp = $recurTimestamp;
    }

    function getRecurEndTimestamp()
    {
        return $this->recurEndTimestamp;
    }

    function hasRecurEnd()
    {
        return (isset($this->recurEnd) && isset($this->recurEnd->year) && $this->recurEnd->year != 9999);
    }

    function getRecurEndDate($formatString)
    {
        return date($formatString, $this->recurEndTimestamp);
    }

    function setAlarm($alarm)
    {
        $this->alarm = $alarm;
    }

    function getAlarm()
    {
        return $this->alarm;
    }

    function readForm()
    {
        global $prefs;

        // basic fields
        $this->setTitle(Horde::getFormData('title', $this->title));
        $this->setDescription(Horde::getFormData('description', $this->description));
        $this->setCategory(Horde::getFormData('category', $this->category));
        $this->setLocation(Horde::getFormData('location', $this->location));
        $this->setKeywords(Horde::getFormData('keywords', $this->keywords));

        // event start
        $start_year = Horde::getFormData('start_year');
        $start_month = Horde::getFormData('start_month');
        $start_day = Horde::getFormData('start_day');
        $start_hour = Horde::getFormData('start_hour');
        $start_min = Horde::getFormData('start_min');
        $am_pm = Horde::getFormData('am_pm');

        if (!$prefs->getValue('twentyFour')) {
            if ($am_pm == 'PM') {
                if ($start_hour != 12) {
                    $start_hour += 12;
                }
            } elseif ($start_hour == 12) {
                $start_hour = 0;
            }
        }

        if (Horde::getFormData('end_or_dur') == 1) {
            if (Horde::getFormData('whole_day') == 1) {
                $start_hour = 0;
                $start_min = 0;
                $dur_day = 0;
                $dur_hour = 24;
                $dur_min = 0;
            } else {
                $dur_day = Horde::getFormData('dur_day');
                $dur_hour = Horde::getFormData('dur_hour');
                $dur_min = Horde::getFormData('dur_min');
            }
        }

        $this->setStartTimestamp(mktime($start_hour, $start_min, 0,
                                        $start_month, $start_day,
                                        $start_year));

        if (Horde::getFormData('end_or_dur') == 1) {
            // event duration
            $this->setEndTimestamp(mktime($start_hour + $dur_hour,
                                          $start_min + $dur_min,
                                          0,
                                          $start_month,
                                          $start_day + $dur_day,
                                          $start_year));
        } else {
            // event end
            $end_year = Horde::getFormData('end_year');
            $end_month = Horde::getFormData('end_month');
            $end_day = Horde::getFormData('end_day');
            $end_hour = Horde::getFormData('end_hour');
            $end_min = Horde::getFormData('end_min');
            $end_am_pm = Horde::getFormData('end_am_pm');

            if (!$prefs->getValue('twentyFour')) {
                if ($end_am_pm == 'PM') {
                    if ($end_hour != 12) {
                        $end_hour += 12;
                    }
                } elseif ($end_hour == 12) {
                    $end_hour = 0;
                }
            }

            $endstamp = mktime($end_hour, $end_min, 0,
                               $end_month, $end_day, $end_year);
            if ($endstamp < $this->getStartTimestamp()) {
                $endstamp = $this->getStartTimestamp();
            }
            $this->setEndTimestamp($endstamp);
        }

        // alarm
        if (Horde::getFormData('alarm') == 1) {
            $this->setAlarm(Horde::getFormData('alarm_value') * Horde::getFormData('alarm_unit'));
        } else {
            $this->setAlarm(0);
        }

        // recurrence
        $recur = Horde::getFormData('recur');
        if (!is_null($recur) && $recur !== '') {
            if (Horde::getFormData('recur_enddate_type') == 'none') {
                $recur_enddate_year = 9999;
                $recur_enddate_month = 12;
                $recur_enddate_day = 31;
            } else {
                $recur_enddate_year = Horde::getFormData('recur_enddate_year');
                $recur_enddate_month = Horde::getFormData('recur_enddate_month');
                $recur_enddate_day = Horde::getFormData('recur_enddate_day');
            }

            $this->setRecurEndTimestamp(mktime(1, 1, 1,
                                               $recur_enddate_month,
                                               $recur_enddate_day,
                                               $recur_enddate_year));

            $this->setRecurType($recur);
            switch ($recur) {
            case KRONOLITH_RECUR_DAILY:
                $this->setRecurInterval(Horde::getFormData('recur_daily_interval', 1));
                break;

            case KRONOLITH_RECUR_WEEKLY:
                $weekly = Horde::getFormData('weekly');
                if (is_array($weekly)) {
                    $weekdays = 0;
                    foreach ($weekly as $day) {
                        $weekdays |= $day;
                    }
                    $this->setRecurInterval(Horde::getFormData('recur_weekly_interval', 1));
                    $this->setRecurOnDay($weekdays);
                }
                break;

            case KRONOLITH_RECUR_DAY_OF_MONTH:
                $this->setRecurInterval(Horde::getFormData('recur_day_of_month_interval', 1));
                break;

            case KRONOLITH_RECUR_WEEK_OF_MONTH:
                $this->setRecurInterval(Horde::getFormData('recur_week_of_month_interval', 1));
                break;

            case KRONOLITH_RECUR_YEARLY:
                $this->setRecurInterval(Horde::getFormData('recur_yearly_interval', 1));
                break;

            }
        }

        $this->initialized = true;
    }

    function getDuration()
    {
        static $duration;
        if (isset($duration)) {
            return $duration;
        }

        if ($this->isInitialized()) {
            $dur_day_match = $this->getEndDate('j') - $this->getStartDate('j');
            $dur_hour_match = $this->getEndDate('G') - $this->getStartDate('G');
            $dur_min_match = $this->getEndDate('i') - $this->getStartDate('i');
            while ($dur_min_match < 0) {
                $dur_min_match += 60;
                $dur_hour_match--;
            }
            while ($dur_hour_match < 0) {
                $dur_hour_match += 24;
                $dur_day_match--;
            }
            if ($dur_hour_match == 0 && $dur_min_match == 0
                && ($this->getEndDate('d') - $this->getStartDate('d')) == 1) {
                $dur_day_match = 0;
                $dur_hour_match = 23;
                $dur_min_match = 60;
                $whole_day_match = true;
            } else {
                $whole_day_match = false;
            }
        } else {
            $dur_day_match = 0;
            $dur_hour_match = 1;
            $dur_min_match = 0;
            $whole_day_match = false;
        }

        $duration->day = $dur_day_match;
        $duration->hour = $dur_hour_match;
        $duration->min = $dur_min_match;
        $duration->wholeDay = $whole_day_match;

        return $duration;
    }

    function html($property)
    {
        global $conf, $prefs;

        include_once 'HTML/Select.php';
        $select = new HTML_Select($property);

        switch ($property) {

        case 'category':
            $select->loadValueArray($conf['metadata']['category']['options'], array($this->getCategory()));
            break;

        case 'start_year':
            $start_year_match = $this->getStartDate('Y');
            for ($i = -1; $i < 6; $i++) {
                $yr = date('Y') + $i;
                $select->addOption($yr, $yr, $yr == $start_year_match);
            }
            $select->updateAttributes('onchange="updateWday(\'start_wday\'); document.event.whole_day.checked = false; updateEndDate();"');
            break;

        case 'start_month':
            $start_month_match = $this->getStartDate('n');
            for ($i = 1; $i < 13; $i++) {
                $select->addOption(strftime('%b', mktime(1,1,1,$i,1)), $i, $i == $start_month_match);
            }
            $select->updateAttributes('onchange="updateWday(\'start_wday\'); document.event.whole_day.checked = false; updateEndDate();"');
            break;

        case 'start_day':
            $start_day_match = $this->getStartDate('j');
            for ($i = 1; $i < 32; $i++) {
                $select->addOption($i, $i, $i == $start_day_match);
            }
            $select->updateAttributes('onchange="updateWday(\'start_wday\');document.event.whole_day.checked=false;updateEndDate();"');
            break;

        case 'start_hour':
            $start_hour_match = $this->getStartDate(($prefs->getValue('twentyFour')) ? 'G' : 'g');
            $hour_min = ($prefs->getValue('twentyFour')) ? 0 : 1;
            $hour_max = ($prefs->getValue('twentyFour')) ? 24 : 13;
            for ($i=$hour_min; $i<$hour_max; $i++) {
                $select->addOption($i, $i, $i == $start_hour_match);
            }
            $select->updateAttributes('onchange="document.event.whole_day.checked = false; updateEndDate();"');
            break;

        case 'start_min':
            $start_min_match = $this->getStartDate('i');
            for ($i = 0; $i<12; $i++) {
                $min = sprintf('%02d', $i * 5);
                $select->addOption($min, $min, $min == $start_min_match);
            }
            $select->updateAttributes('onchange="document.event.whole_day.checked = false; updateEndDate();"');
            break;

        case 'end_year':
            if ($this->isInitialized()) {
                $end_year_match = $this->getEndDate('Y');
            } else {
                $end_year_match = $this->getStartDate('Y');
            }
            for ($i = -1; $i < 6; $i++) {
                $yr = date('Y') + $i;
                $select->addOption($yr, $yr, $yr == $end_year_match);
            }
            $select->updateAttributes('onchange="updateWday(\'end_wday\'); updateDuration(); document.event.end_or_dur[0].checked = true"');
            break;

        case 'end_month':
            if ($this->isInitialized()) {
                $end_month_match = $this->getEndDate('n');
            } else {
                $end_month_match = $this->getStartDate('n');
            }
            for ($i = 1; $i < 13; $i++) {
                $select->addOption(strftime('%b', mktime(1,1,1,$i,1)), $i, $i == $end_month_match);
            }
            $select->updateAttributes('onchange="updateWday(\'end_wday\'); updateDuration(); document.event.end_or_dur[0].checked = true"');
            break;

        case 'end_day':
            if ($this->isInitialized()) {
                $end_day_match = $this->getEndDate('j');
            } else {
                $end_day_match = $this->getStartDate('j');
            }
            for ($i = 1; $i < 32; $i++) {
                $select->addOption($i, $i, $i == $end_day_match);
            }
            $select->updateAttributes('onchange="updateWday(\'end_wday\'); updateDuration(); document.event.end_or_dur[0].checked = true"');
            break;

        case 'end_hour':
            if ($this->isInitialized()) {
                $end_hour_match = $this->getEndDate(($prefs->getValue('twentyFour')) ? 'G' : 'g');
            } else {
                $end_hour_match = $this->getStartDate(($prefs->getValue('twentyFour')) ? 'G' : 'g') + 1;
            }
            $hour_min = $prefs->getValue('twentyFour') ? 0 : 1;
            $hour_max = $prefs->getValue('twentyFour') ? 24 : 13;
            for ($i=$hour_min; $i<$hour_max; $i++) {
                $select->addOption($i, $i, $i == $end_hour_match);
            }
            $select->updateAttributes('onchange="updateDuration(); document.event.end_or_dur[0].checked = true"');
            break;

        case 'end_min':
            if ($this->isInitialized()) {
                $end_min_match = $this->getEndDate('i');
            } else {
                $end_min_match = $this->getStartDate('i');
            }
            for ($i = 0; $i < 12; $i++) {
                $min = sprintf('%02d', $i * 5);
                $select->addOption($min, $min, $min == $end_min_match);
            }
            $select->updateAttributes('onchange="updateDuration(); document.event.end_or_dur[0].checked = true"');
            break;

        case 'dur_day':
            $dur = $this->getDuration();
            for ($i = 0; $i < 366; $i++) {
                $select->addOption($i, $i, $i == $dur->day);
            }
            $select->updateAttributes('onchange="document.event.whole_day.checked = false; updateEndDate(); document.event.end_or_dur[1].checked = true;"');
            break;

        case 'dur_hour':
            $dur = $this->getDuration();
            for ($i = 0; $i < 24; $i++) {
                $select->addOption($i, $i, $i == $dur->hour);
            }
            $select->updateAttributes('onchange="document.event.whole_day.checked = false; updateEndDate(); document.event.end_or_dur[1].checked = true;"');
            break;

        case 'dur_min':
            $dur = $this->getDuration();
            for ($i = 0; $i < 13; $i++) {
                $min = sprintf("%02d", $i * 5);
                $select->addOption($min, $min, $min == $dur->min);
            }
            $select->updateAttributes('onchange="document.event.whole_day.checked = false;updateEndDate();document.event.end_or_dur[1].checked=true"');
            break;

        case 'recur_enddate_year':
            if ($this->isInitialized()) {
                if ($this->hasRecurEnd()) {
                    $recur_end = $this->recurEnd;
                } else {
                    $recur_end = $this->end;
                }
            } else {
                $recur_end->year = $this->getStartDate('Y');
            }
            for ($i = -1; $i < 6; $i++) {
                $yr = date('Y') + $i;
                $select->addOption($yr, $yr, $yr == $recur_end->year);
            }
            $select->updateAttributes('onchange="updateWday(\'recur_end_wday\'); document.event.recur_enddate_type[1].checked = true;"');
            break;

        case 'recur_enddate_month':
            if ($this->isInitialized()) {
                if ($this->hasRecurEnd()) {
                    $recur_end = $this->recurEnd;
                } else {
                    $recur_end = $this->end;
                }
            } else {
                $recur_end->month = $this->getStartDate('m');
            }
            for ($i=1; $i<13; $i++) {
                $select->addOption(strftime('%b', mktime(1,1,1,$i,1)), $i, $i == $recur_end->month);
            }
            $select->updateAttributes('onchange="updateWday(\'recur_end_wday\'); document.event.recur_enddate_type[1].checked = true;"');
            break;

        case 'recur_enddate_day':
            if ($this->isInitialized()) {
                if ($this->hasRecurEnd()) {
                    $recur_end = $this->recurEnd;
                } else {
                    $recur_end = $this->end;
                }
            } else {
                $recur_end->mday = $this->getStartDate('d');
            }
            for ($i=1; $i<32; $i++) {
                $select->addOption($i, $i, $i == $recur_end->mday);
            }
            $select->updateAttributes('onchange="updateWday(\'recur_end_wday\'); document.event.recur_enddate_type[1].checked = true;"');
            break;

        }

        return $select->toHtml();
    }

    function getLink($timestamp = 0)
    {
        $link = '';
        if (isset($this->eventID)) {
            $link .= Horde::link(Horde::applicationUrl("viewevent.php?eventID=$this->eventID&timestamp=" . $timestamp), $this->title, '', '', '', $this->description);
        } elseif (isset($this->taskID)) {
            $link .= Horde::link($GLOBALS['registry']->link('tasks/show', array('task' => $this->taskID)), $this->title);
        }
        $link .= htmlspecialchars($this->title, ENT_QUOTES, Lang::getCharset());
        if (isset($this->eventID) || isset($this->taskID)) {
            $link .= '</a>';
        }
        if (isset($this->eventID)) {
            $link .= '&nbsp;' . Horde::link(Horde::applicationUrl("delevent.php?eventID=$this->eventID&timestamp=" . $timestamp . '&url=' . urlencode($_SERVER['REQUEST_URI'])), sprintf(_("Delete %s"), $this->title)) . Horde::img('delete.gif', 'alt="' . sprintf(_("Delete %s"), htmlspecialchars($this->title, ENT_QUOTES, Lang::getCharset())) . '"') . '</a>';
        }
        if ($this->alarm) {
            $link .= Horde::img('alarm_small.gif', 'alt="' . $this->alarm . ' ' . _("Minutes before") . '"');
        }
        if (!$this->hasRecurType(KRONOLITH_RECUR_NONE)) {
            $link .= Horde::img('recur.gif', 'alt="' . Kronolith::recurToString($this->recurType) . '"');
        }

        return $link;
    }

}
?>
