#ifndef NTL_mach_desc__H
#define NTL_mach_desc__H


#define NTL_BITS_PER_LONG (64)
#define NTL_MAX_LONG (9223372036854775807L)
#define NTL_MAX_INT (2147483647)
#define NTL_BITS_PER_INT (32)
#define NTL_BITS_PER_SIZE_T (64)
#define NTL_ARITH_RIGHT_SHIFT (1)
#define NTL_NBITS_MAX (50)
#define NTL_DOUBLE_PRECISION (53)
#define NTL_FDOUBLE_PRECISION (((double)(1L<<52)))
#define NTL_QUAD_FLOAT_SPLIT ((((double)(1L<<27)))+1.0)
#define NTL_EXT_DOUBLE (0)
#define NTL_SINGLE_MUL_OK (0)
#define NTL_DOUBLES_LOW_HIGH (0)




#define NTL_BB_MUL_CODE \
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>58)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>56)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>54)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>52)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>50)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>48)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>46)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>44)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>42)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>40)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>38)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>36)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>34)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>32)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>30)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>28)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>26)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>24)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>22)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>20)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>18)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>16)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>14)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>12)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>10)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>8)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>6)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>4)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>2)&3];\




#define NTL_BB_HALF_MUL_CODE \
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>26)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>24)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>22)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>20)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>18)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>16)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>14)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>12)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>10)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>8)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>6)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>4)&3];\
hi=(hi<<2)|(lo>>62); lo=(lo<<2)^A[(b>>2)&3];\




#define NTL_BB_SQR_CODE \
lo=sqrtab[a&255];\
lo=lo|(sqrtab[(a>>8)&255]<<16);\
lo=lo|(sqrtab[(a>>16)&255]<<32);\
lo=lo|(sqrtab[(a>>24)&255]<<48);\
hi=sqrtab[(a>>32)&255];\
hi=hi|(sqrtab[(a>>40)&255]<<16);\
hi=hi|(sqrtab[(a>>48)&255]<<32);\
hi=hi|(sqrtab[(a>>56)&255]<<48);\




#define NTL_BB_REV_CODE (revtab[(a>>0)&255]<<56)\
|(revtab[(a>>8)&255]<<48)\
|(revtab[(a>>16)&255]<<40)\
|(revtab[(a>>24)&255]<<32)\
|(revtab[(a>>32)&255]<<24)\
|(revtab[(a>>40)&255]<<16)\
|(revtab[(a>>48)&255]<<8)\
|(revtab[(a>>56)&255]<<0)

#define NTL_MIN_LONG (-NTL_MAX_LONG - 1L)
#define NTL_MIN_INT  (-NTL_MAX_INT - 1)
#endif

