%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.0, (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License at
%% http://www.erlang.org/EPL1_0.txt
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Original Code is Erlang-4.7.3, December, 1998.
%% 
%% The Initial Developer of the Original Code is Ericsson Telecom
%% AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
%% Telecom AB. All Rights Reserved.
%% 
%% Contributor(s): ______________________________________.''
%%
-module(queue).
-copyright('Copyright (c) 1991-97 Ericsson Telecom AB').
-vsn('$Revision: /main/release/free/1').
-export([new/0, in/2, out/1, to_list/1]).

%% efficient implementation of fifo queues

new() -> {[], []}.

in(X, {In, Out}) -> {[X|In], Out}.

out({In, [H|Out]}) ->
	{{value, H}, {In, Out}};
out({[], []}) ->
	{empty, {[],[]}};
out({In, _}) ->
	out({[], lists:reverse(In)}).

to_list({In, Out}) ->
    lists:append(lists:reverse(In), Out).

