require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&BOOT_ELF)) {
    sub BOOT_ELF () {	1;}
}
unless(defined(&ELFSIZE)) {
    sub ELFSIZE () {	32;}
}
unless(defined(&LOAD_KERNEL)) {
    sub LOAD_KERNEL () {	( &LOAD_ALL & ~ &LOAD_TEXTA);}
}
unless(defined(&COUNT_KERNEL)) {
    sub COUNT_KERNEL () {	( &COUNT_ALL & ~ &COUNT_TEXTA);}
}
unless(defined(&LOADADDR)) {
    sub LOADADDR {
	local($a) = @_;
	eval q(((($a)) +  &offset));
    }
}
unless(defined(&ALIGNENTRY)) {
    sub ALIGNENTRY {
	local($a) = @_;
	eval q((($a)));
    }
}
unless(defined(&READ)) {
    sub READ {
	local($f, $b, $c) = @_;
	eval q( &read(,  &LOADADDR($b), ($c)));
    }
}
unless(defined(&BCOPY)) {
    sub BCOPY {
	local($s, $d, $c) = @_;
	eval q( &memcpy( &LOADADDR, ($s), ($c)));
    }
}
unless(defined(&BZERO)) {
    sub BZERO {
	local($d, $c) = @_;
	eval q( &memset( &LOADADDR($d), 0, ($c)));
    }
}
unless(defined(&WARN)) {
    sub WARN {
	local($a) = @_;
	eval q(( &printf $a,  &printf(( &errno ? \": %s\\n\" : \"\\n\"),  &strerror( &errno))));
    }
}
unless(defined(&PROGRESS)) {
    sub PROGRESS {
	local($a) = @_;
	eval q(  &printf $a);
    }
}
unless(defined(&ALLOC)) {
    sub ALLOC {
	local($a) = @_;
	eval q( &alloc($a));
    }
}
unless(defined(&FREE)) {
    sub FREE {
	local($a, $b) = @_;
	eval q( &free($a, $b));
    }
}
unless(defined(&OKMAGIC)) {
    sub OKMAGIC {
	local($a) = @_;
	eval q((($a) ==  &OMAGIC));
    }
}
1;
