require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_AIC7XXX_H_)) {
    eval 'sub _AIC7XXX_H_ () {1;}' unless defined(&_AIC7XXX_H_);
    require 'dev/microcode/aic7xxx/aic7xxx_reg.ph';
    require 'dev/ic/aic7xxx_cam.ph';
    unless(defined(&MAX)) {
	eval 'sub MAX {
	    local($a,$b) = @_;
    	    eval q(((($a) > ($b)) ? ($a) : ($b)));
	}' unless defined(&MAX);
    }
    unless(defined(&MIN)) {
	eval 'sub MIN {
	    local($a,$b) = @_;
    	    eval q(((($a) < ($b)) ? ($a) : ($b)));
	}' unless defined(&MIN);
    }
    unless(defined(&TRUE)) {
	eval 'sub TRUE () {1;}' unless defined(&TRUE);
    }
    unless(defined(&FALSE)) {
	eval 'sub FALSE () {0;}' unless defined(&FALSE);
    }
    eval 'sub NUM_ELEMENTS {
        local($array) = @_;
	    eval q(($sizeof{$array} / $sizeof{$array}));
    }' unless defined(&NUM_ELEMENTS);
    eval 'sub ALL_CHANNELS () {ord(\'\\0\');}' unless defined(&ALL_CHANNELS);
    eval 'sub ALL_TARGETS_MASK () {0xffff;}' unless defined(&ALL_TARGETS_MASK);
    eval 'sub INITIATOR_WILDCARD () {(~0);}' unless defined(&INITIATOR_WILDCARD);
    eval 'sub SCSIID_TARGET {
        local($ahc, $scsiid) = @_;
	    eval q(((($scsiid) & (((($ahc)-> &features &  &AHC_TWIN) != 0) ?  &TWIN_TID :  &TID)) >>  &TID_SHIFT));
    }' unless defined(&SCSIID_TARGET);
    eval 'sub SCSIID_OUR_ID {
        local($scsiid) = @_;
	    eval q((($scsiid) &  &OID));
    }' unless defined(&SCSIID_OUR_ID);
    eval 'sub SCSIID_CHANNEL {
        local($ahc, $scsiid) = @_;
	    eval q((((($ahc)-> &features &  &AHC_TWIN) != 0) ? (((($scsiid) &  &TWIN_CHNLB) != 0) ? ord(\'B\' : \'A\')	: \'A\')));
    }' unless defined(&SCSIID_CHANNEL);
    eval 'sub SCB_IS_SCSIBUS_B {
        local($ahc, $scb) = @_;
	    eval q(( &SCSIID_CHANNEL($ahc, ($scb)-> ($h$scb->{scsiid})) == ord(\'B\')));
    }' unless defined(&SCB_IS_SCSIBUS_B);
    eval 'sub SCB_GET_OUR_ID {
        local($scb) = @_;
	    eval q( &SCSIID_OUR_ID(($scb)-> ($h$scb->{scsiid})));
    }' unless defined(&SCB_GET_OUR_ID);
    eval 'sub SCB_GET_TARGET {
        local($ahc, $scb) = @_;
	    eval q( &SCSIID_TARGET(($ahc), ($scb)-> ($h$scb->{scsiid})));
    }' unless defined(&SCB_GET_TARGET);
    eval 'sub SCB_GET_CHANNEL {
        local($ahc, $scb) = @_;
	    eval q( &SCSIID_CHANNEL($ahc, ($scb)-> ($h$scb->{scsiid})));
    }' unless defined(&SCB_GET_CHANNEL);
    eval 'sub SCB_GET_LUN {
        local($scb) = @_;
	    eval q((($scb)-> ($h$scb->{lun})));
    }' unless defined(&SCB_GET_LUN);
    eval 'sub SCB_GET_TARGET_OFFSET {
        local($ahc, $scb) = @_;
	    eval q(( &SCB_GET_TARGET($ahc, $scb) + ( &SCB_IS_SCSIBUS_B($ahc, $scb) ? 8: 0)));
    }' unless defined(&SCB_GET_TARGET_OFFSET);
    eval 'sub SCB_GET_TARGET_MASK {
        local($ahc, $scb) = @_;
	    eval q((0x1 << ( &SCB_GET_TARGET_OFFSET($ahc, $scb))));
    }' unless defined(&SCB_GET_TARGET_MASK);
    if(defined(&AHC_DEBUG)) {
	eval 'sub SCB_IS_SILENT {
	    local($scb) = @_;
    	    eval q((( &ahc_debug &  &AHC_SHOW_MASKED_ERRORS) == 0 && ((($scb)-> &flags &  &SCB_SILENT) != 0)));
	}' unless defined(&SCB_IS_SILENT);
    } else {
	eval 'sub SCB_IS_SILENT {
	    local($scb) = @_;
    	    eval q(((($scb)-> &flags &  &SCB_SILENT) != 0));
	}' unless defined(&SCB_IS_SILENT);
    }
    eval 'sub TCL_TARGET_OFFSET {
        local($tcl) = @_;
	    eval q((((($tcl) >> 4) &  &TID) >> 4));
    }' unless defined(&TCL_TARGET_OFFSET);
    eval 'sub TCL_LUN {
        local($tcl) = @_;
	    eval q(($tcl & ( &AHC_NUM_LUNS - 1)));
    }' unless defined(&TCL_LUN);
    eval 'sub BUILD_TCL {
        local($scsiid, $lun) = @_;
	    eval q((($lun) | ((($scsiid) &  &TID) << 4)));
    }' unless defined(&BUILD_TCL);
    unless(defined(&AHC_TARGET_MODE)) {
	undef(&AHC_TMODE_ENABLE) if defined(&AHC_TMODE_ENABLE);
	eval 'sub AHC_TMODE_ENABLE () {0;}' unless defined(&AHC_TMODE_ENABLE);
    }
    eval 'sub AHC_NUM_TARGETS () {16;}' unless defined(&AHC_NUM_TARGETS);
    eval 'sub AHC_NUM_LUNS () {64;}' unless defined(&AHC_NUM_LUNS);
    eval 'sub AHC_MAXTRANSFER_SIZE () {0xffffff;}' unless defined(&AHC_MAXTRANSFER_SIZE);
    eval 'sub AHC_SCB_MAX () {255;}' unless defined(&AHC_SCB_MAX);
    eval 'sub AHC_MAX_QUEUE () {253;}' unless defined(&AHC_MAX_QUEUE);
    eval 'sub AHC_TMODE_CMDS () {256;}' unless defined(&AHC_TMODE_CMDS);
    eval 'sub AHC_BUSRESET_DELAY () {250;}' unless defined(&AHC_BUSRESET_DELAY);
    eval("sub AHC_NONE () { 0x0000; }") unless defined(&AHC_NONE);
    eval("sub AHC_CHIPID_MASK () { 0x00FF; }") unless defined(&AHC_CHIPID_MASK);
    eval("sub AHC_AIC7770 () { 0x0001; }") unless defined(&AHC_AIC7770);
    eval("sub AHC_AIC7850 () { 0x0002; }") unless defined(&AHC_AIC7850);
    eval("sub AHC_AIC7855 () { 0x0003; }") unless defined(&AHC_AIC7855);
    eval("sub AHC_AIC7859 () { 0x0004; }") unless defined(&AHC_AIC7859);
    eval("sub AHC_AIC7860 () { 0x0005; }") unless defined(&AHC_AIC7860);
    eval("sub AHC_AIC7870 () { 0x0006; }") unless defined(&AHC_AIC7870);
    eval("sub AHC_AIC7880 () { 0x0007; }") unless defined(&AHC_AIC7880);
    eval("sub AHC_AIC7895 () { 0x0008; }") unless defined(&AHC_AIC7895);
    eval("sub AHC_AIC7895C () { 0x0009; }") unless defined(&AHC_AIC7895C);
    eval("sub AHC_AIC7890 () { 0x000a; }") unless defined(&AHC_AIC7890);
    eval("sub AHC_AIC7896 () { 0x000b; }") unless defined(&AHC_AIC7896);
    eval("sub AHC_AIC7892 () { 0x000c; }") unless defined(&AHC_AIC7892);
    eval("sub AHC_AIC7899 () { 0x000d; }") unless defined(&AHC_AIC7899);
    eval("sub AHC_VL () { 0x0100; }") unless defined(&AHC_VL);
    eval("sub AHC_EISA () { 0x0200; }") unless defined(&AHC_EISA);
    eval("sub AHC_PCI () { 0x0400; }") unless defined(&AHC_PCI);
    eval("sub AHC_BUS_MASK () { 0x0F00; }") unless defined(&AHC_BUS_MASK);
    eval("sub AHC_FENONE () { 0x00000; }") unless defined(&AHC_FENONE);
    eval("sub AHC_ULTRA () { 0x00001; }") unless defined(&AHC_ULTRA);
    eval("sub AHC_ULTRA2 () { 0x00002; }") unless defined(&AHC_ULTRA2);
    eval("sub AHC_WIDE () { 0x00004; }") unless defined(&AHC_WIDE);
    eval("sub AHC_TWIN () { 0x00008; }") unless defined(&AHC_TWIN);
    eval("sub AHC_MORE_SRAM () { 0x00010; }") unless defined(&AHC_MORE_SRAM);
    eval("sub AHC_CMD_CHAN () { 0x00020; }") unless defined(&AHC_CMD_CHAN);
    eval("sub AHC_QUEUE_REGS () { 0x00040; }") unless defined(&AHC_QUEUE_REGS);
    eval("sub AHC_SG_PRELOAD () { 0x00080; }") unless defined(&AHC_SG_PRELOAD);
    eval("sub AHC_SPIOCAP () { 0x00100; }") unless defined(&AHC_SPIOCAP);
    eval("sub AHC_MULTI_TID () { 0x00200; }") unless defined(&AHC_MULTI_TID);
    eval("sub AHC_HS_MAILBOX () { 0x00400; }") unless defined(&AHC_HS_MAILBOX);
    eval("sub AHC_DT () { 0x00800; }") unless defined(&AHC_DT);
    eval("sub AHC_NEW_TERMCTL () { 0x01000; }") unless defined(&AHC_NEW_TERMCTL);
    eval("sub AHC_MULTI_FUNC () { 0x02000; }") unless defined(&AHC_MULTI_FUNC);
    eval("sub AHC_LARGE_SCBS () { 0x04000; }") unless defined(&AHC_LARGE_SCBS);
    eval("sub AHC_AUTORATE () { 0x08000; }") unless defined(&AHC_AUTORATE);
    eval("sub AHC_AUTOPAUSE () { 0x10000; }") unless defined(&AHC_AUTOPAUSE);
    eval("sub AHC_TARGETMODE () { 0x20000; }") unless defined(&AHC_TARGETMODE);
    eval("sub AHC_MULTIROLE () { 0x40000; }") unless defined(&AHC_MULTIROLE);
    eval("sub AHC_REMOVABLE () { 0x80000; }") unless defined(&AHC_REMOVABLE);
    eval("sub AHC_AIC7770_FE () { AHC_FENONE; }") unless defined(&AHC_AIC7770_FE);
    eval("sub AHC_AIC7850_FE () { AHC_SPIOCAP|AHC_AUTOPAUSE|AHC_TARGETMODE|AHC_ULTRA; }") unless defined(&AHC_AIC7850_FE);
    eval("sub AHC_AIC7860_FE () { AHC_AIC7850_FE; }") unless defined(&AHC_AIC7860_FE);
    eval("sub AHC_AIC7870_FE () { AHC_TARGETMODE|AHC_AUTOPAUSE; }") unless defined(&AHC_AIC7870_FE);
    eval("sub AHC_AIC7880_FE () { AHC_AIC7870_FE|AHC_ULTRA; }") unless defined(&AHC_AIC7880_FE);
    eval("sub AHC_AIC7890_FE () { AHC_MORE_SRAM|AHC_CMD_CHAN|AHC_ULTRA2|AHC_QUEUE_REGS|AHC_SG_PRELOAD|AHC_MULTI_TID|AHC_HS_MAILBOX|AHC_NEW_TERMCTL|AHC_LARGE_SCBS|AHC_TARGETMODE; }") unless defined(&AHC_AIC7890_FE);
    eval("sub AHC_AIC7892_FE () { AHC_AIC7890_FE|AHC_DT|AHC_AUTORATE|AHC_AUTOPAUSE; }") unless defined(&AHC_AIC7892_FE);
    eval("sub AHC_AIC7895_FE () { AHC_AIC7880_FE|AHC_MORE_SRAM|AHC_AUTOPAUSE|AHC_CMD_CHAN|AHC_MULTI_FUNC|AHC_LARGE_SCBS; }") unless defined(&AHC_AIC7895_FE);
    eval("sub AHC_AIC7895C_FE () { AHC_AIC7895_FE|AHC_MULTI_TID; }") unless defined(&AHC_AIC7895C_FE);
    eval("sub AHC_AIC7896_FE () { AHC_AIC7890_FE|AHC_MULTI_FUNC; }") unless defined(&AHC_AIC7896_FE);
    eval("sub AHC_AIC7899_FE () { AHC_AIC7892_FE|AHC_MULTI_FUNC; }") unless defined(&AHC_AIC7899_FE);
    eval("sub AHC_BUGNONE () { 0x00; }") unless defined(&AHC_BUGNONE);
    eval("sub AHC_TMODE_WIDEODD_BUG () { 0x01; }") unless defined(&AHC_TMODE_WIDEODD_BUG);
    eval("sub AHC_AUTOFLUSH_BUG () { 0x02; }") unless defined(&AHC_AUTOFLUSH_BUG);
    eval("sub AHC_CACHETHEN_BUG () { 0x04; }") unless defined(&AHC_CACHETHEN_BUG);
    eval("sub AHC_CACHETHEN_DIS_BUG () { 0x08; }") unless defined(&AHC_CACHETHEN_DIS_BUG);
    eval("sub AHC_PCI_2_1_RETRY_BUG () { 0x10; }") unless defined(&AHC_PCI_2_1_RETRY_BUG);
    eval("sub AHC_PCI_MWI_BUG () { 0x20; }") unless defined(&AHC_PCI_MWI_BUG);
    eval("sub AHC_SCBCHAN_UPLOAD_BUG () { 0x40; }") unless defined(&AHC_SCBCHAN_UPLOAD_BUG);
    eval("sub AHC_FNONE () { 0x000; }") unless defined(&AHC_FNONE);
    eval("sub AHC_PRIMARY_CHANNEL () { 0x003; }") unless defined(&AHC_PRIMARY_CHANNEL);
    eval("sub AHC_USEDEFAULTS () { 0x004; }") unless defined(&AHC_USEDEFAULTS);
    eval("sub AHC_SEQUENCER_DEBUG () { 0x008; }") unless defined(&AHC_SEQUENCER_DEBUG);
    eval("sub AHC_SHARED_SRAM () { 0x010; }") unless defined(&AHC_SHARED_SRAM);
    eval("sub AHC_LARGE_SEEPROM () { 0x020; }") unless defined(&AHC_LARGE_SEEPROM);
    eval("sub AHC_RESET_BUS_A () { 0x040; }") unless defined(&AHC_RESET_BUS_A);
    eval("sub AHC_RESET_BUS_B () { 0x080; }") unless defined(&AHC_RESET_BUS_B);
    eval("sub AHC_EXTENDED_TRANS_A () { 0x100; }") unless defined(&AHC_EXTENDED_TRANS_A);
    eval("sub AHC_EXTENDED_TRANS_B () { 0x200; }") unless defined(&AHC_EXTENDED_TRANS_B);
    eval("sub AHC_TERM_ENB_A () { 0x400; }") unless defined(&AHC_TERM_ENB_A);
    eval("sub AHC_TERM_ENB_B () { 0x800; }") unless defined(&AHC_TERM_ENB_B);
    eval("sub AHC_INITIATORROLE () { 0x1000; }") unless defined(&AHC_INITIATORROLE);
    eval("sub AHC_TARGETROLE () { 0x2000; }") unless defined(&AHC_TARGETROLE);
    eval("sub AHC_NEWEEPROM_FMT () { 0x4000; }") unless defined(&AHC_NEWEEPROM_FMT);
    eval("sub AHC_RESOURCE_SHORTAGE () { 0x8000; }") unless defined(&AHC_RESOURCE_SHORTAGE);
    eval("sub AHC_TQINFIFO_BLOCKED () { 0x10000; }") unless defined(&AHC_TQINFIFO_BLOCKED);
    eval("sub AHC_INT50_SPEEDFLEX () { 0x20000; }") unless defined(&AHC_INT50_SPEEDFLEX);
    eval("sub AHC_SCB_BTT () { 0x40000; }") unless defined(&AHC_SCB_BTT);
    eval("sub AHC_BIOS_ENABLED () { 0x80000; }") unless defined(&AHC_BIOS_ENABLED);
    eval("sub AHC_ALL_INTERRUPTS () { 0x100000; }") unless defined(&AHC_ALL_INTERRUPTS);
    eval("sub AHC_PAGESCBS () { 0x400000; }") unless defined(&AHC_PAGESCBS);
    eval("sub AHC_EDGE_INTERRUPT () { 0x800000; }") unless defined(&AHC_EDGE_INTERRUPT);
    eval("sub AHC_39BIT_ADDRESSING () { 0x1000000; }") unless defined(&AHC_39BIT_ADDRESSING);
    eval("sub AHC_LSCBS_ENABLED () { 0x2000000; }") unless defined(&AHC_LSCBS_ENABLED);
    eval("sub AHC_SCB_CONFIG_USED () { 0x4000000; }") unless defined(&AHC_SCB_CONFIG_USED);
    eval("sub AHC_NO_BIOS_INIT () { 0x8000000; }") unless defined(&AHC_NO_BIOS_INIT);
    eval("sub AHC_DISABLE_PCI_PERR () { 0x10000000; }") unless defined(&AHC_DISABLE_PCI_PERR);
    eval 'sub SG_PTR_MASK () {0xfffffff8;}' unless defined(&SG_PTR_MASK);
    eval 'sub AHC_DMA_LAST_SEG () {0x80000000;}' unless defined(&AHC_DMA_LAST_SEG);
    eval 'sub AHC_SG_HIGH_ADDR_MASK () {0x7f000000;}' unless defined(&AHC_SG_HIGH_ADDR_MASK);
    eval 'sub AHC_SG_LEN_MASK () {0xffffff;}' unless defined(&AHC_SG_LEN_MASK);
    if(defined(&__OpenBSD__)) {
    }
    eval("sub SCB_FREE () { 0x0000; }") unless defined(&SCB_FREE);
    eval("sub SCB_OTHERTCL_TIMEOUT () { 0x0002; }") unless defined(&SCB_OTHERTCL_TIMEOUT);
    eval("sub SCB_DEVICE_RESET () { 0x0004; }") unless defined(&SCB_DEVICE_RESET);
    eval("sub SCB_SENSE () { 0x0008; }") unless defined(&SCB_SENSE);
    eval("sub SCB_CDB32_PTR () { 0x0010; }") unless defined(&SCB_CDB32_PTR);
    eval("sub SCB_RECOVERY_SCB () { 0x0020; }") unless defined(&SCB_RECOVERY_SCB);
    eval("sub SCB_AUTO_NEGOTIATE () { 0x0040; }") unless defined(&SCB_AUTO_NEGOTIATE);
    eval("sub SCB_NEGOTIATE () { 0x0080; }") unless defined(&SCB_NEGOTIATE);
    eval("sub SCB_ABORT () { 0x1000; }") unless defined(&SCB_ABORT);
    eval("sub SCB_UNTAGGEDQ () { 0x2000; }") unless defined(&SCB_UNTAGGEDQ);
    eval("sub SCB_ACTIVE () { 0x4000; }") unless defined(&SCB_ACTIVE);
    eval("sub SCB_TARGET_IMMEDIATE () { 0x8000; }") unless defined(&SCB_TARGET_IMMEDIATE);
    eval("sub SCB_TRANSMISSION_ERROR () { 0x1000; }") unless defined(&SCB_TRANSMISSION_ERROR);
    eval("sub SCB_TARGET_SCB () { 0x2000; }") unless defined(&SCB_TARGET_SCB);
    eval("sub SCB_SILENT () { 0x4000; }") unless defined(&SCB_SILENT);
    unless(defined(&__linux__)) {
    }
    if(defined(&__OpenBSD__)) {
    }
    if(defined(&__OpenBSD__)) {
    }
    eval 'sub AHC_TMODE_EVENT_BUFFER_SIZE () {8;}' unless defined(&AHC_TMODE_EVENT_BUFFER_SIZE);
    eval 'sub EVENT_TYPE_BUS_RESET () {0xff;}' unless defined(&EVENT_TYPE_BUS_RESET);
    if(defined(&AHC_TARGET_MODE)) {
    } else {
    }
    eval 'sub AHC_TRANS_CUR () {0x1;}' unless defined(&AHC_TRANS_CUR);
    eval 'sub AHC_TRANS_ACTIVE () {0x3;}' unless defined(&AHC_TRANS_ACTIVE);
    eval 'sub AHC_TRANS_GOAL () {0x4;}' unless defined(&AHC_TRANS_GOAL);
    eval 'sub AHC_TRANS_USER () {0x8;}' unless defined(&AHC_TRANS_USER);
    eval 'sub ULTRA_SXFR () {0x100;}' unless defined(&ULTRA_SXFR);
    eval 'sub ST_SXFR () {0x10;}' unless defined(&ST_SXFR);
    eval 'sub DT_SXFR () {0x40;}' unless defined(&DT_SXFR);
    eval 'sub AHC_ASYNC_XFER_PERIOD () {0x45;}' unless defined(&AHC_ASYNC_XFER_PERIOD);
    eval 'sub AHC_ULTRA2_XFER_PERIOD () {0xa;}' unless defined(&AHC_ULTRA2_XFER_PERIOD);
    eval 'sub AHC_SYNCRATE_DT () {0;}' unless defined(&AHC_SYNCRATE_DT);
    eval 'sub AHC_SYNCRATE_ULTRA2 () {1;}' unless defined(&AHC_SYNCRATE_ULTRA2);
    eval 'sub AHC_SYNCRATE_ULTRA () {3;}' unless defined(&AHC_SYNCRATE_ULTRA);
    eval 'sub AHC_SYNCRATE_FAST () {6;}' unless defined(&AHC_SYNCRATE_FAST);
    eval 'sub CFXFER () {0x7;}' unless defined(&CFXFER);
    eval 'sub CFSYNCH () {0x8;}' unless defined(&CFSYNCH);
    eval 'sub CFDISC () {0x10;}' unless defined(&CFDISC);
    eval 'sub CFWIDEB () {0x20;}' unless defined(&CFWIDEB);
    eval 'sub CFSYNCHISULTRA () {0x40;}' unless defined(&CFSYNCHISULTRA);
    eval 'sub CFSYNCSINGLE () {0x80;}' unless defined(&CFSYNCSINGLE);
    eval 'sub CFSTART () {0x100;}' unless defined(&CFSTART);
    eval 'sub CFINCBIOS () {0x200;}' unless defined(&CFINCBIOS);
    eval 'sub CFRNFOUND () {0x400;}' unless defined(&CFRNFOUND);
    eval 'sub CFMULTILUNDEV () {0x800;}' unless defined(&CFMULTILUNDEV);
    eval 'sub CFWBCACHEENB () {0x4000;}' unless defined(&CFWBCACHEENB);
    eval 'sub CFWBCACHENOP () {0xc000;}' unless defined(&CFWBCACHENOP);
    eval 'sub CFSUPREM () {0x1;}' unless defined(&CFSUPREM);
    eval 'sub CFSUPREMB () {0x2;}' unless defined(&CFSUPREMB);
    eval 'sub CFBIOSEN () {0x4;}' unless defined(&CFBIOSEN);
    eval 'sub CFBIOS_BUSSCAN () {0x8;}' unless defined(&CFBIOS_BUSSCAN);
    eval 'sub CFSM2DRV () {0x10;}' unless defined(&CFSM2DRV);
    eval 'sub CFSTPWLEVEL () {0x10;}' unless defined(&CFSTPWLEVEL);
    eval 'sub CF284XEXTEND () {0x20;}' unless defined(&CF284XEXTEND);
    eval 'sub CFCTRL_A () {0x20;}' unless defined(&CFCTRL_A);
    eval 'sub CFTERM_MENU () {0x40;}' unless defined(&CFTERM_MENU);
    eval 'sub CFEXTEND () {0x80;}' unless defined(&CFEXTEND);
    eval 'sub CFSCAMEN () {0x100;}' unless defined(&CFSCAMEN);
    eval 'sub CFMSG_LEVEL () {0x600;}' unless defined(&CFMSG_LEVEL);
    eval 'sub CFMSG_VERBOSE () {0x;}' unless defined(&CFMSG_VERBOSE);
    eval 'sub CFMSG_SILENT () {0x200;}' unless defined(&CFMSG_SILENT);
    eval 'sub CFMSG_DIAG () {0x400;}' unless defined(&CFMSG_DIAG);
    eval 'sub CFBOOTCD () {0x800;}' unless defined(&CFBOOTCD);
    eval 'sub CFAUTOTERM () {0x1;}' unless defined(&CFAUTOTERM);
    eval 'sub CFULTRAEN () {0x2;}' unless defined(&CFULTRAEN);
    eval 'sub CF284XSELTO () {0x3;}' unless defined(&CF284XSELTO);
    eval 'sub CF284XFIFO () {0xc;}' unless defined(&CF284XFIFO);
    eval 'sub CFSTERM () {0x4;}' unless defined(&CFSTERM);
    eval 'sub CFWSTERM () {0x8;}' unless defined(&CFWSTERM);
    eval 'sub CFSPARITY () {0x10;}' unless defined(&CFSPARITY);
    eval 'sub CF284XSTERM () {0x20;}' unless defined(&CF284XSTERM);
    eval 'sub CFMULTILUN () {0x20;}' unless defined(&CFMULTILUN);
    eval 'sub CFRESETB () {0x40;}' unless defined(&CFRESETB);
    eval 'sub CFCLUSTERENB () {0x80;}' unless defined(&CFCLUSTERENB);
    eval 'sub CFBOOTCHAN () {0x300;}' unless defined(&CFBOOTCHAN);
    eval 'sub CFBOOTCHANSHIFT () {8;}' unless defined(&CFBOOTCHANSHIFT);
    eval 'sub CFSEAUTOTERM () {0x400;}' unless defined(&CFSEAUTOTERM);
    eval 'sub CFSELOWTERM () {0x800;}' unless defined(&CFSELOWTERM);
    eval 'sub CFSEHIGHTERM () {0x1000;}' unless defined(&CFSEHIGHTERM);
    eval 'sub CFDOMAINVAL () {0x4000;}' unless defined(&CFDOMAINVAL);
    eval 'sub CFSCSIID () {0xf;}' unless defined(&CFSCSIID);
    eval 'sub CFBRTIME () {0xff00;}' unless defined(&CFBRTIME);
    eval 'sub CFMAXTARG () {0xff;}' unless defined(&CFMAXTARG);
    eval 'sub CFBOOTLUN () {0xf00;}' unless defined(&CFBOOTLUN);
    eval 'sub CFBOOTID () {0xf000;}' unless defined(&CFBOOTID);
    eval 'sub CFSIGNATURE () {0x250;}' unless defined(&CFSIGNATURE);
    eval 'sub CFSIGNATURE2 () {0x300;}' unless defined(&CFSIGNATURE2);
    eval("sub MSG_TYPE_NONE () { 0x00; }") unless defined(&MSG_TYPE_NONE);
    eval("sub MSG_TYPE_INITIATOR_MSGOUT () { 0x01; }") unless defined(&MSG_TYPE_INITIATOR_MSGOUT);
    eval("sub MSG_TYPE_INITIATOR_MSGIN () { 0x02; }") unless defined(&MSG_TYPE_INITIATOR_MSGIN);
    eval("sub MSG_TYPE_TARGET_MSGOUT () { 0x03; }") unless defined(&MSG_TYPE_TARGET_MSGOUT);
    eval("sub MSG_TYPE_TARGET_MSGIN () { 0x04; }") unless defined(&MSG_TYPE_TARGET_MSGIN);
    eval("sub MSGLOOP_IN_PROG () { 0; }") unless defined(&MSGLOOP_IN_PROG);
    eval("sub MSGLOOP_MSGCOMPLETE () { 1; }") unless defined(&MSGLOOP_MSGCOMPLETE);
    eval("sub MSGLOOP_TERMINATED () { 2; }") unless defined(&MSGLOOP_TERMINATED);
    if(defined(&__OpenBSD__)) {
    }
    unless(defined(&__linux__)) {
    }
    eval("sub ROLE_UNKNOWN () { 0; }") unless defined(&ROLE_UNKNOWN);
    eval("sub ROLE_INITIATOR () { 1; }") unless defined(&ROLE_INITIATOR);
    eval("sub ROLE_TARGET () { 2; }") unless defined(&ROLE_TARGET);
    eval 'sub AHC_EISA_SLOT_OFFSET () {0xc00;}' unless defined(&AHC_EISA_SLOT_OFFSET);
    eval 'sub AHC_EISA_IOSIZE () {0x100;}' unless defined(&AHC_EISA_IOSIZE);
    if(defined(&AHC_TARGET_MODE)) {
    }
    eval("sub SEARCH_COMPLETE () { 0; }") unless defined(&SEARCH_COMPLETE);
    eval("sub SEARCH_COUNT () { 1; }") unless defined(&SEARCH_COUNT);
    eval("sub SEARCH_REMOVE () { 2; }") unless defined(&SEARCH_REMOVE);
    eval("sub AHC_QUEUE_NONE () { 0; }") unless defined(&AHC_QUEUE_NONE);
    eval("sub AHC_QUEUE_BASIC () { 1; }") unless defined(&AHC_QUEUE_BASIC);
    eval("sub AHC_QUEUE_TAGGED () { 2; }") unless defined(&AHC_QUEUE_TAGGED);
    if(defined(&AHC_TARGET_MODE)) {
	unless(defined(&AHC_TMODE_ENABLE)) {
	    eval 'sub AHC_TMODE_ENABLE () {0;}' unless defined(&AHC_TMODE_ENABLE);
	}
    }
}
1;
