require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&SCI_CLR_INTR)) {
    sub SCI_CLR_INTR {
	local($sc) = @_;
	eval q((*($sc)-> &sci_iack));
    }
}
unless(defined(&SCI_BUSY)) {
    sub SCI_BUSY {
	local($sc) = @_;
	eval q((* ($sc->{sci_bus_csr}) &  &SCI_BUS_BSY));
    }
}
unless(defined(&PHASE_DATA_OUT)) {
    sub PHASE_DATA_OUT () {	0x;}
}
unless(defined(&PHASE_DATA_IN)) {
    sub PHASE_DATA_IN () {	0x1;}
}
unless(defined(&PHASE_COMMAND)) {
    sub PHASE_COMMAND () {	0x2;}
}
unless(defined(&PHASE_STATUS)) {
    sub PHASE_STATUS () {	0x3;}
}
unless(defined(&PHASE_UNSPEC1)) {
    sub PHASE_UNSPEC1 () {	0x4;}
}
unless(defined(&PHASE_UNSPEC2)) {
    sub PHASE_UNSPEC2 () {	0x5;}
}
unless(defined(&PHASE_MSG_OUT)) {
    sub PHASE_MSG_OUT () {	0x6;}
}
unless(defined(&PHASE_MSG_IN)) {
    sub PHASE_MSG_IN () {	0x7;}
}
unless(defined(&PHASE_INVALID)) {
    sub PHASE_INVALID () {	 &PHASE_UNSPEC1;}
}
unless(defined(&SR_IMMED)) {
    sub SR_IMMED () {	1;}
}
unless(defined(&SR_SENSE)) {
    sub SR_SENSE () {	2;}
}
unless(defined(&SR_OVERDUE)) {
    sub SR_OVERDUE () {	4;}
}
unless(defined(&SR_ERROR)) {
    sub SR_ERROR () {	8;}
}
unless(defined(&SCI_OPENINGS)) {
    sub SCI_OPENINGS () {	16;}
}
unless(defined(&NCR5380_PERMIT_RESELECT)) {
    sub NCR5380_PERMIT_RESELECT () {	1;}
}
unless(defined(&NCR5380_FORCE_POLLING)) {
    sub NCR5380_FORCE_POLLING () {	2;}
}
unless(defined(&NCR_IDLE)) {
    sub NCR_IDLE () {	0;}
}
unless(defined(&NCR_WORKING)) {
    sub NCR_WORKING () {	0x1;}
}
unless(defined(&NCR_ABORTING)) {
    sub NCR_ABORTING () {	0x2;}
}
unless(defined(&NCR_DOINGDMA)) {
    sub NCR_DOINGDMA () {	0x4;}
}
unless(defined(&NCR_DROP_MSGIN)) {
    sub NCR_DROP_MSGIN () {	0x10;}
}
unless(defined(&SEND_DEV_RESET)) {
    sub SEND_DEV_RESET () {	0x1;}
}
unless(defined(&SEND_PARITY_ERROR)) {
    sub SEND_PARITY_ERROR () {	0x2;}
}
unless(defined(&SEND_ABORT)) {
    sub SEND_ABORT () {	0x4;}
}
unless(defined(&SEND_REJECT)) {
    sub SEND_REJECT () {	0x8;}
}
unless(defined(&SEND_INIT_DET_ERR)) {
    sub SEND_INIT_DET_ERR () {	0x10;}
}
unless(defined(&SEND_IDENTIFY)) {
    sub SEND_IDENTIFY () {	0x20;}
}
unless(defined(&SEND_SDTR)) {
    sub SEND_SDTR () {	0x40;}
}
unless(defined(&SEND_WDTR)) {
    sub SEND_WDTR () {	0x80;}
}
unless(defined(&NCR_MAX_MSG_LEN)) {
    sub NCR_MAX_MSG_LEN () {	8;}
}
if(defined(&NCR5380_DEBUG)) {
    eval 'sub NCR_TRACE {
        local($msg, $val) = @_;
	    eval q( &ncr5380_trace($msg, $val));
    }' unless defined(&NCR_TRACE);
} else {
    eval 'sub NCR_TRACE {
        local($msg, $val) = @_;
	    eval q();
    }' unless defined(&NCR_TRACE);
}
1;
