require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SYS_FCNTL_H_)) {
    eval 'sub _SYS_FCNTL_H_ () {1;}' unless defined(&_SYS_FCNTL_H_);
    unless(defined(&_KERNEL)) {
	require 'sys/types.ph';
    }
    eval 'sub O_RDONLY () {0x;}' unless defined(&O_RDONLY);
    eval 'sub O_WRONLY () {0x1;}' unless defined(&O_WRONLY);
    eval 'sub O_RDWR () {0x2;}' unless defined(&O_RDWR);
    eval 'sub O_ACCMODE () {0x3;}' unless defined(&O_ACCMODE);
    unless(defined(&_POSIX_SOURCE)) {
	eval 'sub FREAD () {0x1;}' unless defined(&FREAD);
	eval 'sub FWRITE () {0x2;}' unless defined(&FWRITE);
    }
    eval 'sub O_NONBLOCK () {0x4;}' unless defined(&O_NONBLOCK);
    eval 'sub O_APPEND () {0x8;}' unless defined(&O_APPEND);
    unless(defined(&_POSIX_SOURCE)) {
	eval 'sub O_SHLOCK () {0x10;}' unless defined(&O_SHLOCK);
	eval 'sub O_EXLOCK () {0x20;}' unless defined(&O_EXLOCK);
	eval 'sub O_ASYNC () {0x40;}' unless defined(&O_ASYNC);
	eval 'sub O_FSYNC () { &O_SYNC;}' unless defined(&O_FSYNC);
	eval 'sub O_NOFOLLOW () {0x100;}' unless defined(&O_NOFOLLOW);
    }
    eval 'sub O_SYNC () {0x80;}' unless defined(&O_SYNC);
    eval 'sub O_CREAT () {0x200;}' unless defined(&O_CREAT);
    eval 'sub O_TRUNC () {0x400;}' unless defined(&O_TRUNC);
    eval 'sub O_EXCL () {0x800;}' unless defined(&O_EXCL);
    if(defined(&_KERNEL)) {
	eval 'sub FMARK () {0x1000;}' unless defined(&FMARK);
	eval 'sub FDEFER () {0x2000;}' unless defined(&FDEFER);
	eval 'sub FHASLOCK () {0x4000;}' unless defined(&FHASLOCK);
    }
    eval 'sub O_DSYNC () { &O_SYNC;}' unless defined(&O_DSYNC);
    eval 'sub O_RSYNC () { &O_SYNC;}' unless defined(&O_RSYNC);
    eval 'sub O_NOCTTY () {0x8000;}' unless defined(&O_NOCTTY);
    if(defined(&_KERNEL)) {
	eval 'sub FFLAGS {
	    local($oflags) = @_;
    	    eval q(((($oflags) & ~ &O_ACCMODE) | ((($oflags) + 1) &  &O_ACCMODE)));
	}' unless defined(&FFLAGS);
	eval 'sub OFLAGS {
	    local($fflags) = @_;
    	    eval q(((($fflags) & ~ &O_ACCMODE) | ((($fflags) - 1) &  &O_ACCMODE)));
	}' unless defined(&OFLAGS);
	eval 'sub FMASK () {( &FREAD| &FWRITE| &FAPPEND| &FASYNC| &FFSYNC| &FNONBLOCK);}' unless defined(&FMASK);
	eval 'sub FCNTLFLAGS () {( &FAPPEND| &FASYNC| &FFSYNC| &FNONBLOCK);}' unless defined(&FCNTLFLAGS);
    }
    unless(defined(&_POSIX_SOURCE)) {
	eval 'sub FAPPEND () { &O_APPEND;}' unless defined(&FAPPEND);
	eval 'sub FASYNC () { &O_ASYNC;}' unless defined(&FASYNC);
	eval 'sub FFSYNC () { &O_SYNC;}' unless defined(&FFSYNC);
	eval 'sub FNONBLOCK () { &O_NONBLOCK;}' unless defined(&FNONBLOCK);
	eval 'sub FNDELAY () { &O_NONBLOCK;}' unless defined(&FNDELAY);
	eval 'sub O_NDELAY () { &O_NONBLOCK;}' unless defined(&O_NDELAY);
    }
    eval 'sub F_DUPFD () {0;}' unless defined(&F_DUPFD);
    eval 'sub F_GETFD () {1;}' unless defined(&F_GETFD);
    eval 'sub F_SETFD () {2;}' unless defined(&F_SETFD);
    eval 'sub F_GETFL () {3;}' unless defined(&F_GETFL);
    eval 'sub F_SETFL () {4;}' unless defined(&F_SETFL);
    unless(defined(&_POSIX_SOURCE)) {
	eval 'sub F_GETOWN () {5;}' unless defined(&F_GETOWN);
	eval 'sub F_SETOWN () {6;}' unless defined(&F_SETOWN);
    }
    eval 'sub F_GETLK () {7;}' unless defined(&F_GETLK);
    eval 'sub F_SETLK () {8;}' unless defined(&F_SETLK);
    eval 'sub F_SETLKW () {9;}' unless defined(&F_SETLKW);
    eval 'sub FD_CLOEXEC () {1;}' unless defined(&FD_CLOEXEC);
    eval 'sub F_RDLCK () {1;}' unless defined(&F_RDLCK);
    eval 'sub F_UNLCK () {2;}' unless defined(&F_UNLCK);
    eval 'sub F_WRLCK () {3;}' unless defined(&F_WRLCK);
    if(defined(&_KERNEL)) {
	eval 'sub F_WAIT () {0x10;}' unless defined(&F_WAIT);
	eval 'sub F_FLOCK () {0x20;}' unless defined(&F_FLOCK);
	eval 'sub F_POSIX () {0x40;}' unless defined(&F_POSIX);
    }
    unless(defined(&_POSIX_SOURCE)) {
	eval 'sub LOCK_SH () {0x1;}' unless defined(&LOCK_SH);
	eval 'sub LOCK_EX () {0x2;}' unless defined(&LOCK_EX);
	eval 'sub LOCK_NB () {0x4;}' unless defined(&LOCK_NB);
	eval 'sub LOCK_UN () {0x8;}' unless defined(&LOCK_UN);
    }
    unless(defined(&_KERNEL)) {
	require 'sys/cdefs.ph';
	unless(defined(&_POSIX_SOURCE)) {
	}
    }
}
1;
