require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_X86_BUS_H_)) {
    eval 'sub _X86_BUS_H_ () {1;}' unless defined(&_X86_BUS_H_);
    require 'machine/pio.ph';
    eval 'sub X86_BUS_SPACE_IO () {0;}' unless defined(&X86_BUS_SPACE_IO);
    eval 'sub X86_BUS_SPACE_MEM () {1;}' unless defined(&X86_BUS_SPACE_MEM);
    eval 'sub bus_space_map {
        local($t, $a, $s, $f, $hp) = @_;
	    eval q( &x86_memio_map(($t),($a),($s),($f),($hp)));
    }' unless defined(&bus_space_map);
    eval 'sub bus_space_unmap {
        local($t, $h, $s) = @_;
	    eval q( &x86_memio_unmap(($t),($h),($s)));
    }' unless defined(&bus_space_unmap);
    eval 'sub bus_space_subregion {
        local($t, $h, $o, $s, $nhp) = @_;
	    eval q( &x86_memio_subregion(($t), ($h), ($o), ($s), ($nhp)));
    }' unless defined(&bus_space_subregion);
    eval 'sub bus_space_read_1 {
        local($t, $h, $o) = @_;
	    eval q(( ==  &X86_BUS_SPACE_IO ? ( &inb( + )) : (*(($h) + ($o)))));
    }' unless defined(&bus_space_read_1);
    eval 'sub bus_space_read_2 {
        local($t, $h, $o) = @_;
	    eval q(( ==  &X86_BUS_SPACE_IO ? ( &inw( + )) : (*(($h) + ($o)))));
    }' unless defined(&bus_space_read_2);
    eval 'sub bus_space_read_4 {
        local($t, $h, $o) = @_;
	    eval q(( ==  &X86_BUS_SPACE_IO ? ( &inl( + )) : (*(($h) + ($o)))));
    }' unless defined(&bus_space_read_4);
    if(0) {
	eval 'sub bus_space_read_8 {
	    local($t, $h, $o) = @_;
    	    eval q(!!!  &bus_space_read_8  &unimplemented !!!);
	}' unless defined(&bus_space_read_8);
    }
    eval 'sub bus_space_read_multi_1 {
        local($t, $h, $o, $ptr, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &X86_BUS_SPACE_IO) {  &insb(($h) + ($o), ($ptr), ($cnt)); }  &else {  &void * &dummy1; \'int\'  &dummy2;  &void * &dummy3; \'int\'  &__x;  &__asm  &__volatile(\\"								cld					;			1:	movb (%2),%%al				;				stosb					;				loop 1b\\" : \\"=D\\" ( &dummy1), \\"=c\\" ( &dummy2), \\"=r\\" ( &dummy3), \\"=&a\\" ( &__x) : \\"0\\" (($ptr)), \\"1\\" (($cnt)), \\"2\\" (($h) + ($o)) : \\"memory\\"); } }  &while ( 0));
    }' unless defined(&bus_space_read_multi_1);
    eval 'sub bus_space_read_multi_2 {
        local($t, $h, $o, $ptr, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &X86_BUS_SPACE_IO) {  &insw(($h) + ($o), ($ptr), ($cnt)); }  &else {  &void * &dummy1; \'int\'  &dummy2;  &void * &dummy3; \'int\'  &__x;  &__asm  &__volatile(\\"								cld					;			1:	movw (%2),%%ax				;				stosw					;				loop 1b\\" : \\"=D\\" ( &dummy1), \\"=c\\" ( &dummy2), \\"=r\\" ( &dummy3), \\"=&a\\" ( &__x) : \\"0\\" (($ptr)), \\"1\\" (($cnt)), \\"2\\" (($h) + ($o)) : \\"memory\\"); } }  &while ( 0));
    }' unless defined(&bus_space_read_multi_2);
    eval 'sub bus_space_read_multi_4 {
        local($t, $h, $o, $ptr, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &X86_BUS_SPACE_IO) {  &insl(($h) + ($o), ($ptr), ($cnt)); }  &else {  &void * &dummy1; \'int\'  &dummy2;  &void * &dummy3; \'int\'  &__x;  &__asm  &__volatile(\\"								cld					;			1:	movl (%2),%%eax				;				stosl					;				loop 1b\\" : \\"=D\\" ( &dummy1), \\"=c\\" ( &dummy2), \\"=r\\" ( &dummy3), \\"=&a\\" ( &__x) : \\"0\\" (($ptr)), \\"1\\" (($cnt)), \\"2\\" (($h) + ($o)) : \\"memory\\"); } }  &while ( 0));
    }' unless defined(&bus_space_read_multi_4);
    if(0) {
	eval 'sub bus_space_read_multi_8 () {!!!  &bus_space_read_multi_8  &unimplemented !!!;}' unless defined(&bus_space_read_multi_8);
    }
    eval 'sub bus_space_read_raw_multi_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_multi_2(, , , ($a), ($c) >> 1));
    }' unless defined(&bus_space_read_raw_multi_2);
    eval 'sub bus_space_read_raw_multi_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_multi_4(, , , ($a), ($c) >> 2));
    }' unless defined(&bus_space_read_raw_multi_4);
    if(0) {
	eval 'sub bus_space_read_raw_multi_8 () {!!!  &bus_space_read_raw_multi_8  &unimplemented !!!;}' unless defined(&bus_space_read_raw_multi_8);
    }
    eval 'sub bus_space_read_region_1 {
        local($t, $h, $o, $ptr, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &X86_BUS_SPACE_IO) { \'int\'  &dummy1;  &void * &dummy2; \'int\'  &dummy3; \'int\'  &__x;  &__asm  &__volatile(\\"								cld					;			1:	inb %w1,%%al				;				stosb					;				incl %1					;				loop 1b\\" : \\"=&a\\" ( &__x), \\"=d\\" ( &dummy1), \\"=D\\" ( &dummy2), \\"=c\\" ( &dummy3) : \\"1\\" (($h) + ($o)), \\"2\\" (($ptr)), \\"3\\" (($cnt)) : \\"memory\\"); }  &else { \'int\'  &dummy1;  &void * &dummy2; \'int\'  &dummy3;  &__asm  &__volatile(\\"								cld					;				repne					;				movsb\\" : \\"=S\\" ( &dummy1), \\"=D\\" ( &dummy2), \\"=c\\" ( &dummy3) : \\"0\\" (($h) + ($o)), \\"1\\" (($ptr)), \\"2\\" (($cnt)) : \\"memory\\"); } }  &while ( 0));
    }' unless defined(&bus_space_read_region_1);
    eval 'sub bus_space_read_region_2 {
        local($t, $h, $o, $ptr, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &X86_BUS_SPACE_IO) { \'int\'  &dummy1;  &void * &dummy2; \'int\'  &dummy3; \'int\'  &__x;  &__asm  &__volatile(\\"								cld					;			1:	inw %w1,%%ax				;				stosw					;				addl $2,%1				;				loop 1b\\" : \\"=&a\\" ( &__x), \\"=d\\" ( &dummy1), \\"=D\\" ( &dummy2), \\"=c\\" ( &dummy3) : \\"1\\" (($h) + ($o)), \\"2\\" (($ptr)), \\"3\\" (($cnt)) : \\"memory\\"); }  &else { \'int\'  &dummy1;  &void * &dummy2; \'int\'  &dummy3;  &__asm  &__volatile(\\"								cld					;				repne					;				movsw\\" : \\"=S\\" ( &dummy1), \\"=D\\" ( &dummy2), \\"=c\\" ( &dummy3) : \\"0\\" (($h) + ($o)), \\"1\\" (($ptr)), \\"2\\" (($cnt)) : \\"memory\\"); } }  &while ( 0));
    }' unless defined(&bus_space_read_region_2);
    eval 'sub bus_space_read_region_4 {
        local($t, $h, $o, $ptr, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &X86_BUS_SPACE_IO) { \'int\'  &dummy1;  &void * &dummy2; \'int\'  &dummy3; \'int\'  &__x;  &__asm  &__volatile(\\"								cld					;			1:	inl %w1,%%eax				;				stosl					;				addl $4,%1				;				loop 1b\\" : \\"=&a\\" ( &__x), \\"=d\\" ( &dummy1), \\"=D\\" ( &dummy2), \\"=c\\" ( &dummy3) : \\"1\\" (($h) + ($o)), \\"2\\" (($ptr)), \\"3\\" (($cnt)) : \\"memory\\"); }  &else { \'int\'  &dummy1;  &void * &dummy2; \'int\'  &dummy3;  &__asm  &__volatile(\\"								cld					;				repne					;				movsl\\" : \\"=S\\" ( &dummy1), \\"=D\\" ( &dummy2), \\"=c\\" ( &dummy3) : \\"0\\" (($h) + ($o)), \\"1\\" (($ptr)), \\"2\\" (($cnt)) : \\"memory\\"); } }  &while ( 0));
    }' unless defined(&bus_space_read_region_4);
    eval 'sub bus_space_read_region_stream_1 () { &bus_space_read_region_1;}' unless defined(&bus_space_read_region_stream_1);
    if(0) {
	eval 'sub bus_space_read_region_8 () {!!!  &bus_space_read_region_8  &unimplemented !!!;}' unless defined(&bus_space_read_region_8);
    }
    eval 'sub bus_space_read_raw_region_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_region_2(, , , ($a), ($c) >> 1));
    }' unless defined(&bus_space_read_raw_region_2);
    eval 'sub bus_space_read_raw_region_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_region_4(, , , ($a), ($c) >> 2));
    }' unless defined(&bus_space_read_raw_region_4);
    if(0) {
	eval 'sub bus_space_read_raw_region_8 () {!!!  &bus_space_read_raw_region_8  &unimplemented !!!;}' unless defined(&bus_space_read_raw_region_8);
    }
    eval 'sub bus_space_write_1 {
        local($t, $h, $o, $v) = @_;
	    eval q( &do {  &if ( ==  &X86_BUS_SPACE_IO)  &outb( + , );  &else ((*(($h) + ($o)) = ($v))); }  &while (0));
    }' unless defined(&bus_space_write_1);
    eval 'sub bus_space_write_2 {
        local($t, $h, $o, $v) = @_;
	    eval q( &do {  &if ( ==  &X86_BUS_SPACE_IO)  &outw( + , );  &else ((*(($h) + ($o)) = ($v))); }  &while (0));
    }' unless defined(&bus_space_write_2);
    eval 'sub bus_space_write_4 {
        local($t, $h, $o, $v) = @_;
	    eval q( &do {  &if ( ==  &X86_BUS_SPACE_IO)  &outl( + , );  &else ((*(($h) + ($o)) = ($v))); }  &while (0));
    }' unless defined(&bus_space_write_4);
    if(0) {
	eval 'sub bus_space_write_8 () {!!!  &bus_space_write_8  &not  &implemented !!!;}' unless defined(&bus_space_write_8);
    }
    eval 'sub bus_space_write_multi_1 {
        local($t, $h, $o, $ptr, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &X86_BUS_SPACE_IO) {  &outsb(($h) + ($o), ($ptr), ($cnt)); }  &else {  &void * &dummy1; \'int\'  &dummy2;  &void * &dummy3; \'int\'  &__x;  &__asm  &__volatile(\\"								cld					;			1:	lodsb					;				movb %%al,(%2)				;				loop 1b\\" : \\"=S\\" ( &dummy1), \\"=c\\" ( &dummy2), \\"=r\\" ( &dummy3), \\"=&a\\" ( &__x) : \\"0\\" (($ptr)), \\"1\\" (($cnt)), \\"2\\" (($h) + ($o))); } }  &while ( 0));
    }' unless defined(&bus_space_write_multi_1);
    eval 'sub bus_space_write_multi_2 {
        local($t, $h, $o, $ptr, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &X86_BUS_SPACE_IO) {  &outsw(($h) + ($o), ($ptr), ($cnt)); }  &else {  &void * &dummy1; \'int\'  &dummy2;  &void * &dummy3; \'int\'  &__x;  &__asm  &__volatile(\\"								cld					;			1:	lodsw					;				movw %%ax,(%2)				;				loop 1b\\" : \\"=S\\" ( &dummy1), \\"=c\\" ( &dummy2), \\"=r\\" ( &dummy3), \\"=&a\\" ( &__x) : \\"0\\" (($ptr)), \\"1\\" (($cnt)), \\"2\\" (($h) + ($o))); } }  &while ( 0));
    }' unless defined(&bus_space_write_multi_2);
    eval 'sub bus_space_write_multi_4 {
        local($t, $h, $o, $ptr, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &X86_BUS_SPACE_IO) {  &outsl(($h) + ($o), ($ptr), ($cnt)); }  &else {  &void * &dummy1; \'int\'  &dummy2;  &void * &dummy3; \'int\'  &__x;  &__asm  &__volatile(\\"								cld					;			1:	lodsl					;				movl %%eax,(%2)				;				loop 1b\\" : \\"=S\\" ( &dummy1), \\"=c\\" ( &dummy2), \\"=r\\" ( &dummy3), \\"=&a\\" ( &__x) : \\"0\\" (($ptr)), \\"1\\" (($cnt)), \\"2\\" (($h) + ($o))); } }  &while ( 0));
    }' unless defined(&bus_space_write_multi_4);
    if(0) {
	eval 'sub bus_space_write_multi_8 {
	    local($t, $h, $o, $a, $c) = @_;
    	    eval q(!!!  &bus_space_write_multi_8  &unimplemented !!!);
	}' unless defined(&bus_space_write_multi_8);
    }
    eval 'sub bus_space_write_raw_multi_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_multi_2(, , , ($a), ($c) >> 1));
    }' unless defined(&bus_space_write_raw_multi_2);
    eval 'sub bus_space_write_raw_multi_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_multi_4(, , , ($a), ($c) >> 2));
    }' unless defined(&bus_space_write_raw_multi_4);
    if(0) {
	eval 'sub bus_space_write_raw_multi_8 () {!!!  &bus_space_write_raw_multi_8  &unimplemented !!!;}' unless defined(&bus_space_write_raw_multi_8);
    }
    eval 'sub bus_space_write_region_1 {
        local($t, $h, $o, $ptr, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &X86_BUS_SPACE_IO) { \'int\'  &dummy1;  &void * &dummy2; \'int\'  &dummy3; \'int\'  &__x;  &__asm  &__volatile(\\"								cld					;			1:	lodsb					;				outb %%al,%w1				;				incl %1					;				loop 1b\\" : \\"=&a\\" ( &__x), \\"=d\\" ( &dummy1), \\"=S\\" ( &dummy2), \\"=c\\" ( &dummy3) : \\"1\\" (($h) + ($o)), \\"2\\" (($ptr)), \\"3\\" (($cnt)) : \\"memory\\"); }  &else { \'int\'  &dummy1;  &void * &dummy2; \'int\'  &dummy3;  &__asm  &__volatile(\\"								cld					;				repne					;				movsb\\" : \\"=D\\" ( &dummy1), \\"=S\\" ( &dummy2), \\"=c\\" ( &dummy3) : \\"0\\" (($h) + ($o)), \\"1\\" (($ptr)), \\"2\\" (($cnt)) : \\"memory\\"); } }  &while ( 0));
    }' unless defined(&bus_space_write_region_1);
    eval 'sub bus_space_write_region_2 {
        local($t, $h, $o, $ptr, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &X86_BUS_SPACE_IO) { \'int\'  &dummy1;  &void * &dummy2; \'int\'  &dummy3; \'int\'  &__x;  &__asm  &__volatile(\\"								cld					;			1:	lodsw					;				outw %%ax,%w1				;				addl $2,%1				;				loop 1b\\" : \\"=&a\\" ( &__x), \\"=d\\" ( &dummy1), \\"=S\\" ( &dummy2), \\"=c\\" ( &dummy3) : \\"1\\" (($h) + ($o)), \\"2\\" (($ptr)), \\"3\\" (($cnt)) : \\"memory\\"); }  &else { \'int\'  &dummy1;  &void * &dummy2; \'int\'  &dummy3;  &__asm  &__volatile(\\"								cld					;				repne					;				movsw\\" : \\"=D\\" ( &dummy1), \\"=S\\" ( &dummy2), \\"=c\\" ( &dummy3) : \\"0\\" (($h) + ($o)), \\"1\\" (($ptr)), \\"2\\" (($cnt)) : \\"memory\\"); } }  &while ( 0));
    }' unless defined(&bus_space_write_region_2);
    eval 'sub bus_space_write_region_4 {
        local($t, $h, $o, $ptr, $cnt) = @_;
	    eval q( &do {  &if (($t) ==  &X86_BUS_SPACE_IO) { \'int\'  &dummy1;  &void * &dummy2; \'int\'  &dummy3; \'int\'  &__x;  &__asm  &__volatile(\\"								cld					;			1:	lodsl					;				outl %%eax,%w1				;				addl $4,%1				;				loop 1b\\" : \\"=&a\\" ( &__x), \\"=d\\" ( &dummy1), \\"=S\\" ( &dummy2), \\"=c\\" ( &dummy3) : \\"1\\" (($h) + ($o)), \\"2\\" (($ptr)), \\"3\\" (($cnt)) : \\"memory\\"); }  &else { \'int\'  &dummy1;  &void * &dummy2; \'int\'  &dummy3;  &__asm  &__volatile(\\"								cld					;				repne					;				movsl\\" : \\"=D\\" ( &dummy1), \\"=S\\" ( &dummy2), \\"=c\\" ( &dummy3) : \\"0\\" (($h) + ($o)), \\"1\\" (($ptr)), \\"2\\" (($cnt)) : \\"memory\\"); } }  &while ( 0));
    }' unless defined(&bus_space_write_region_4);
    if(0) {
	eval 'sub bus_space_write_region_8 () {!!!  &bus_space_write_region_8  &unimplemented !!!;}' unless defined(&bus_space_write_region_8);
    }
    eval 'sub bus_space_write_raw_region_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_region_2(, , , ($a), ($c) >> 1));
    }' unless defined(&bus_space_write_raw_region_2);
    eval 'sub bus_space_write_raw_region_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_region_4(, , , ($a), ($c) >> 2));
    }' unless defined(&bus_space_write_raw_region_4);
    if(0) {
	eval 'sub bus_space_write_raw_region_8 () {!!!  &bus_space_write_raw_region_8  &unimplemented !!!;}' unless defined(&bus_space_write_raw_region_8);
    }
    eval 'sub bus_space_set_multi_1 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &x86_memio_set_multi_1(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_multi_1);
    eval 'sub bus_space_set_multi_2 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &x86_memio_set_multi_2(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_multi_2);
    eval 'sub bus_space_set_multi_4 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &x86_memio_set_multi_4(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_multi_4);
    if(0) {
	eval 'sub bus_space_set_multi_8 () {!!!  &bus_space_set_multi_8  &unimplemented !!!;}' unless defined(&bus_space_set_multi_8);
    }
    eval 'sub bus_space_set_region_1 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &x86_memio_set_region_1(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_region_1);
    eval 'sub bus_space_set_region_2 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &x86_memio_set_region_2(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_region_2);
    eval 'sub bus_space_set_region_4 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &x86_memio_set_region_4(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_region_4);
    if(0) {
	eval 'sub bus_space_set_region_8 () {!!!  &bus_space_set_region_8  &unimplemented !!!;}' unless defined(&bus_space_set_region_8);
    }
    eval 'sub bus_space_copy_1 () { &bus_space_copy_region_1;}' unless defined(&bus_space_copy_1);
    eval 'sub bus_space_copy_2 () { &bus_space_copy_region_2;}' unless defined(&bus_space_copy_2);
    eval 'sub bus_space_copy_4 () { &bus_space_copy_region_4;}' unless defined(&bus_space_copy_4);
    eval 'sub bus_space_copy_8 () { &bus_space_copy_region_8;}' unless defined(&bus_space_copy_8);
    eval 'sub bus_space_copy_region_1 {
        local($t, $h1, $o1, $h2, $o2, $c) = @_;
	    eval q( &x86_memio_copy_region_1(($t), ($h1), ($o1), ($h2), ($o2), ($c)));
    }' unless defined(&bus_space_copy_region_1);
    eval 'sub bus_space_copy_region_2 {
        local($t, $h1, $o1, $h2, $o2, $c) = @_;
	    eval q( &x86_memio_copy_region_2(($t), ($h1), ($o1), ($h2), ($o2), ($c)));
    }' unless defined(&bus_space_copy_region_2);
    eval 'sub bus_space_copy_region_4 {
        local($t, $h1, $o1, $h2, $o2, $c) = @_;
	    eval q( &x86_memio_copy_region_4(($t), ($h1), ($o1), ($h2), ($o2), ($c)));
    }' unless defined(&bus_space_copy_region_4);
    if(0) {
	eval 'sub bus_space_copy_8 () {!!!  &bus_space_copy_8  &unimplemented !!!;}' unless defined(&bus_space_copy_8);
    }
    eval 'sub BUS_SPACE_BARRIER_READ () {0x1;}' unless defined(&BUS_SPACE_BARRIER_READ);
    eval 'sub BUS_SPACE_BARRIER_WRITE () {0x2;}' unless defined(&BUS_SPACE_BARRIER_WRITE);
    eval 'sub BUS_BARRIER_READ () { &BUS_SPACE_BARRIER_READ;}' unless defined(&BUS_BARRIER_READ);
    eval 'sub BUS_BARRIER_WRITE () { &BUS_SPACE_BARRIER_WRITE;}' unless defined(&BUS_BARRIER_WRITE);
    eval 'sub BUS_DMA_WAITOK () {0x;}' unless defined(&BUS_DMA_WAITOK);
    eval 'sub BUS_DMA_NOWAIT () {0x1;}' unless defined(&BUS_DMA_NOWAIT);
    eval 'sub BUS_DMA_ALLOCNOW () {0x2;}' unless defined(&BUS_DMA_ALLOCNOW);
    eval 'sub BUS_DMA_COHERENT () {0x4;}' unless defined(&BUS_DMA_COHERENT);
    eval 'sub BUS_DMA_BUS1 () {0x10;}' unless defined(&BUS_DMA_BUS1);
    eval 'sub BUS_DMA_BUS2 () {0x20;}' unless defined(&BUS_DMA_BUS2);
    eval 'sub BUS_DMA_BUS3 () {0x40;}' unless defined(&BUS_DMA_BUS3);
    eval 'sub BUS_DMA_BUS4 () {0x80;}' unless defined(&BUS_DMA_BUS4);
    eval 'sub BUS_DMA_STREAMING () {0x100;}' unless defined(&BUS_DMA_STREAMING);
    eval 'sub BUS_DMA_READ () {0x200;}' unless defined(&BUS_DMA_READ);
    eval 'sub BUS_DMA_WRITE () {0x400;}' unless defined(&BUS_DMA_WRITE);
    eval 'sub BUS_DMASYNC_PREREAD () {0x1;}' unless defined(&BUS_DMASYNC_PREREAD);
    eval 'sub BUS_DMASYNC_POSTREAD () {0x2;}' unless defined(&BUS_DMASYNC_POSTREAD);
    eval 'sub BUS_DMASYNC_PREWRITE () {0x4;}' unless defined(&BUS_DMASYNC_PREWRITE);
    eval 'sub BUS_DMASYNC_POSTWRITE () {0x8;}' unless defined(&BUS_DMASYNC_POSTWRITE);
    eval 'sub bus_dmamap_create {
        local($t, $s, $n, $m, $b, $f, $p) = @_;
	    eval q((*($t)-> &_dmamap_create)(($t), ($s), ($n), ($m), ($b), ($f), ($p)));
    }' unless defined(&bus_dmamap_create);
    eval 'sub bus_dmamap_destroy {
        local($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_destroy)(($t), ($p)));
    }' unless defined(&bus_dmamap_destroy);
    eval 'sub bus_dmamap_load {
        local($t, $m, $b, $s, $p, $f) = @_;
	    eval q((*($t)-> &_dmamap_load)(($t), ($m), ($b), ($s), ($p), ($f)));
    }' unless defined(&bus_dmamap_load);
    eval 'sub bus_dmamap_load_mbuf {
        local($t, $m, $b, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_mbuf)(($t), ($m), ($b), ($f)));
    }' unless defined(&bus_dmamap_load_mbuf);
    eval 'sub bus_dmamap_load_uio {
        local($t, $m, $u, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_uio)(($t), ($m), ($u), ($f)));
    }' unless defined(&bus_dmamap_load_uio);
    eval 'sub bus_dmamap_load_raw {
        local($t, $m, $sg, $n, $s, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_raw)(($t), ($m), ($sg), ($n), ($s), ($f)));
    }' unless defined(&bus_dmamap_load_raw);
    eval 'sub bus_dmamap_unload {
        local($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_unload)(($t), ($p)));
    }' unless defined(&bus_dmamap_unload);
    eval 'sub bus_dmamap_sync {
        local($t, $p, $o, $l, $ops) = @_;
	    eval q((-> &_dmamap_sync ? (*-> &_dmamap_sync)(, , , , ) : 0));
    }' unless defined(&bus_dmamap_sync);
    eval 'sub bus_dmamem_alloc {
        local($t, $s, $a, $b, $sg, $n, $r, $f) = @_;
	    eval q((*($t)-> &_dmamem_alloc)(($t), ($s), ($a), ($b), ($sg), ($n), ($r), ($f)));
    }' unless defined(&bus_dmamem_alloc);
    eval 'sub bus_dmamem_free {
        local($t, $sg, $n) = @_;
	    eval q((*($t)-> &_dmamem_free)(($t), ($sg), ($n)));
    }' unless defined(&bus_dmamem_free);
    eval 'sub bus_dmamem_map {
        local($t, $sg, $n, $s, $k, $f) = @_;
	    eval q((*($t)-> &_dmamem_map)(($t), ($sg), ($n), ($s), ($k), ($f)));
    }' unless defined(&bus_dmamem_map);
    eval 'sub bus_dmamem_unmap {
        local($t, $k, $s) = @_;
	    eval q((*($t)-> &_dmamem_unmap)(($t), ($k), ($s)));
    }' unless defined(&bus_dmamem_unmap);
    eval 'sub bus_dmamem_mmap {
        local($t, $sg, $n, $o, $p, $f) = @_;
	    eval q((*($t)-> &_dmamem_mmap)(($t), ($sg), ($n), ($o), ($p), ($f)));
    }' unless defined(&bus_dmamem_mmap);
    if(defined(&_X86_BUS_DMA_PRIVATE)) {
    }
}
1;
