# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 952 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/object_list.al)"
# ----------------------------------------------------------------------


sub object_list {
  my ($class, @args) = @_;
  my %methods;

  while (@args) {
    # DD: changed to $obj_class to avoid clobberring the $class declared 4
    # line above
    my $obj_class = shift @args;
    my $list = shift @args or die "No slot names for $obj_class";

    my @list = ( ref($list) eq 'ARRAY' ) ? @$list : ($list);

    my $obj_def;
    foreach $obj_def (@list) {
      my $type = $obj_class;

      # Hmmm. We have to do this for the closure to work. I.e. using
      # $obj_class in the closure dosen't work. Someday I'll actually
      # understand scoping in Perl. [ Uh, is this true? 11/11/96 -PBS ]

      # DD (22.1.2002): That's because the closure keeps a 'reference' to the
      # unique storage area hidden behind $obj_class. Its value changes at
      # each iteration of the 'while' loop. On the other hand, a new $type
      # variable (i.e. storage area) is created at each iteration of the
      # loop. Hence the value stored in each $type variable is not clobeered.

      my ( $name, @composites );
      my $new_meth = 'new';
      if ( ! ref $obj_def ) {
        $name = $obj_def;
      } else {
        $name = $obj_def->{'slot'};
        my $composites = $obj_def->{'comp_mthds'};
        @composites = ref($composites) eq 'ARRAY' ? @$composites
          : defined $composites ? ($composites) : ();
      }

      $methods{$name} = sub {
        my ($self, @list) = @_;
        defined $self->{$name} or $self->{$name} = [];
        if ( scalar @list == 1 and ref( $list[0] ) eq 'ARRAY' ) {
          @list = @{ $list[0] };
        }
        push @{$self->{$name}}, map {
          (ref $_ and UNIVERSAL::isa($_, $obj_class)) ?
            $_ : $type->$new_meth($_)
        } @list;

        # Use wantarray for consistency with list, which uses it for
        # consistency with its own doco., and the hash impl.
        return wantarray ? @{$self->{$name}} : $self->{$name};
      };

      $class->_add_list_methods(\%methods, $name);

      #
      # Deprecated in line with list, v0.95 (1.vi.00)
      #
      $methods{"ref_$name"} = sub {
        my ($self) = @_;
        $self->{$name};
      };

      my $meth;
      foreach $meth (@composites) {
        $methods{$meth} = sub {
          my ($self, @args) = @_;
          map { $_->$meth(@args) } $self->$name()
        };
      }
    }
  }

  $class->install_methods(%methods);
}

# end of Class::MethodMaker::object_list
1;
