#!/usr/bin/perl

use strict;
use Palm::Datebook;
use ColdSync;

# Set default values
%HEADERS = (
	File		=> "DatebookDB.pdb",
	Delete		=> "no",		# [yes|no|archive|expunge]
);


#ConduitMain(
#	"fetch" => \&DoFetch,
#	"dump" => \&DoDump,
#);

DoFetch();

sub DoFetch{
	my %apps;
	my ($date,$appointment,$text,$id,$record);
	my ($month,$day,$year);
	
	if(!defined($PDB)){
		$PDB = new Palm::PDB;
		$PDB->Load($HEADERS{"File"}) or
			die "502 No input database\n";
	}
	
	# get our appointments in from the appointments file
	%apps = get_appointments("appointments.txt");

	foreach $date (sort keys %apps){ # each day
		($month,$day,$year) = split(/-/,$date);
		foreach $appointment (sort @{$apps{$date}}){ # each apt
			($text,$id)=split(/=/,$appointment);

			# look in pdb to see if there is an entry here
			if($id){ # this has already been given an ID by palm
			print "I got here $id\n";
				foreach $record (@{$PDB->{records}}){
					# go through and look for the record
					# to see if we should update it
				}

			}else{ # this is a new record, let's add it!
				print "adding $text\n";

				$record = $PDB->append_Record;
				$record->{description} = "$text"; 

				$record->{day} = $day; 
				$record->{month} = $month; 
				$record->{year} = $year; 
	
				$record->{start_hour} = 255;
				$record->{start_minute} = 255; 
				$record->{end_hour} = 255; 
				$record->{end_minute} = 255; 

				$record->{attributes}{dirty} = 1;
			}
		}
	}

	$PDB->Write("DatebookDB2.pdb");	
	
}

sub DoDump{

}

sub get_appointments ($){
	my ($date,$text,$id);
	my %apps;
	if (open(INFILE, "<$_[0]")){
		while(<INFILE>){
			unless(/^#/){ # ignore comments
				chomp;
				($date,$text,$id) = split(/\t/,$_);
				push(@{$apps{"$date"}},"$text=$id");
			}
		}
		close INFILE;
	}

	return %apps;
}



