<?php
// $Id: index.php,v 1.16 2002/12/29 16:19:36 dijkstra Exp $
require_once('datasources.inc');
require_once('class_cpu.inc');
require_once('class_if.inc');
require_once('class_io.inc');
require_once('class_mem.inc');
require_once('class_pf.inc');
require_once('class_debug.inc');
require_once('class_proc.inc');

if (!empty($HTTP_SERVER_VARS["QUERY_STRING"])) {
    $args = $HTTP_SERVER_VARS["QUERY_STRING"];
    // rework args to contain ony last set 'command' 
    $options = array();
    $allargs = explode('&', $args);
    $i = 0;
    $selected_machine = "";
    while ($i < count($allargs)) {
	$operand = split('=', $allargs[$i]);
	if (count($operand) == 2) {
	    // options for this page
	    if ($operand[0] == "machine") {
		$selected_machine = $operand[1];
	    }
	    $options[$operand[0]]=$operand[1];
	}
	$i++;
    }
    // decode done, now recode
    $i = 0;
    $args = "";
    reset($options);
    while (list($key,$val) = each($options)) {
	if ($args) {
	    $args .= '&';
	}
	$args .= $key.'='.$val;
    }
} else {
    $args = "";
    $selected_machine = "";
}
function make_graph_url($type, $new_args) {
    global $args;
    $new_args = urlencode($new_args);
    $url = "graph_".$type.".php?";
    $allargs="";
    if ($args) {
	$allargs.=$args.'&';
    }
    $allargs .= $new_args;

    switch ($type) {
    case 'cpu':
	$g = new CPU_Graph();
	break;
    case 'if':
	$g = new IF_Graph();
	break;
    case 'io':
	$g = new IO_Graph();
	break;
    case 'mem':
	$g = new MEM_Graph();
	break;
    case 'pf':
	$g = new PF_Graph();
	break;
    case 'debug':
	$g = new DEBUG_Graph();
	break;
    case 'proc':
	$g = new PROC_Graph();
	break;
    }
    $g->execute($allargs);
    return ($url . $g->settings2url());
}
function print_index_url($new_args) {
    global $args;
    $url = 'index.php?';
    if ($args) {
	$url.=$args.'&';
    }
    $url .= sprintf("%s", $new_args);

    print $url;
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "DTD/xhtml1-transitional.dtd">
<html>
<head>
 <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
 <title>symon statistics</title>
 <link rel="stylesheet" href="symon.css" type="text/css" />
</head>
<body>
 <table border="0" cellspacing="0" cellpadding="0" align="center">
  <tr>
   <td valign="top">
    <table border="0" cellpadding="0" cellspacing="0">
     <tr>
      <td width="5%"></td>
      <td colspan="5" bgcolor="#555599"><img src="spacer.png" width="1" height="1" alt="|"/></td>
      <td width="5%"></td>
     </tr>
     <tr>
      <!-- sidebar -->
      <td width="5%"></td>
      <td width="1" bgcolor="#555599"><img src="spacer.png" width="1" height="1" alt="|"/></td>
      <td bgcolor="#FFFFFF" valign="top" width="20%">
       <div class="left">
        <img src="symon.png" width="149" border="0" alt="[symon]" />
       </div> 

       <div class="left">
        <div class="section-head">Graph Options</div>
        <div class="left-links">
	 Timespan: 
	 <a href="<? print_index_url("start=-14515200") ?>">last 6 months</a>, 
	 <a href="<? print_index_url("start=-2419200") ?>">last month</a>,
	 <a href="<? print_index_url("start=-691200") ?>">last 8 days</a>,
	 <a href="<? print_index_url("start=-86400") ?>">last 24 hours</a>,
	 <a href="<? print_index_url("start=-3600") ?>">last hour</a><br />
	 Size: 
	 <a href="<? print_index_url("size=tiny") ?>">tiny</a>, 
	 <a href="<? print_index_url("size=small") ?>">small</a>, 
	 <a href="<? print_index_url("size=normal") ?>">normal</a>, 
	 <a href="<? print_index_url("size=big") ?>">big</a>, 
	 <a href="<? print_index_url("size=huge") ?>">huge</a><br />
	</div>
	<div class="section-head">Type options</div>
	<div class="left-links">
	 Cpu:
	 <a href="<? print_index_url("cpu=brief")?> ">brief</a>,
	 <a href="<? print_index_url("cpu=detailed")?> ">detailed</a><br />
	 If:
	 <a href="<? print_index_url("if=brief")?> ">brief</a>,
	 <a href="<? print_index_url("if=bits")?> ">bits</a>,
	 <a href="<? print_index_url("if=packets")?> ">packets</a>,
	 <a href="<? print_index_url("if=all")?> ">all</a><br />
	 Io:
	 <a href="<? print_index_url("io=brief")?> ">brief</a>,
	 <a href="<? print_index_url("io=all")?> ">all</a><br />
	 Mem:
	 <a href="<? print_index_url("mem=brief")?> ">brief</a>,
	 <a href="<? print_index_url("mem=detailed")?> ">detailed</a><br />
	 Pf:
	 <a href="<? print_index_url("pf=state")?> ">state</a>,
	 <a href="<? print_index_url("pf=performance")?> ">performance</a>,
	 <a href="<? print_index_url("pf=all")?> ">all</a><br />
	 Proc:
	 <a href="<? print_index_url("proc=brief")?> ">brief</a>,
	 <a href="<? print_index_url("proc=detailed")?> ">detailed</a><br />
	 Debug:
	 <a href="<? print_index_url("debug=brief")?> ">brief</a>,
	 <a href="<? print_index_url("debug=detailed")?> ">detailed</a><br />
        </div>
       </div>
      </td>

     <!-- main window -->
      <td width="1" bgcolor="#555599"><img src="spacer.png" width="1" height="1"></td>
      <td bgcolor="#FFFFFF" valign="top" width="95%">
       <div align="center" class="blue">
        <table bgcolor="#6699CC" border="0" cellpadding="0" cellspacing="0">
         <tr>
<?
	 // get machines
	 $root_dir = dir($symon2web["tree"]);
         while ($machine = $root_dir->read()) {
	     if ($machine != '.' && 
		 $machine != '..' && 
		 is_dir($symon2web["tree"]."/".$machine)) {
		 $symon2web["machine"][$machine] = $symon2web["tree"]."/".$machine;

		 if ($machine == $selected_machine) {
		     $selected_dir = $symon2web["machine"][$machine];
		 }
	     }
	 }

         // show blue bar
         if ($symon2web["view"] == "one") {
	     print '
          <td><a class="blue" href="';
	     print_index_url("machine=all");
	     print '">all machines</a>&nbsp;&nbsp;&nbsp;</td>
';
	 }
	     
         reset($symon2web["machine"]);
         while (list($machine, $dir) = each($symon2web["machine"])) {
	     print '
          <td><a class="blue" href="';
	     if ($symon2web["view"] == "one") {
		 print_index_url("machine=" . $machine);
	     } else {
		 print_index_url("#" . $machine);
	     }
	     print '">'. $machine . "</a>&nbsp;&nbsp;&nbsp;</td>\n";
	 }
?>
	 </tr>
        </table>
       </div>

       <div class="items">
	
<?php
// traverse through the symonrrd tree
  $found_machine = 0;
// TODO : check if machine is a list
  reset($symon2web["machine"]);
// only allow a single machine in the machine array if selected machine is set
  if ($symon2web["view"] == "one" && $selected_machine != "all" ) {
      unset($symon2web["machine"]);
      if ($selected_machine) {
	  $symon2web["machine"][$selected_machine] = $selected_dir;
      }
  }
// show graphs for each machine in the machine array
  while (list($machine, $dir) = each($symon2web["machine"])) {
      print '
        <!-- item start -->
        <div class="header">
	 <a class="header" name="'. $machine . '">'. $machine. '</a><br />
	</div>
';
      $machine_dir = dir($dir);
      while ($filename = $machine_dir->read()) {
	  $file = $dir."/".$filename;
	  if (is_file($file) && 
	      preg_match("/^(cpu|if|io|mem|pf|proc|debug)(_([a-z]+))?([0-9]?).rrd$/", 
			 $filename, $match)) {
	      $rrdtype = $match[1];
	      $rrdwhat = $match[3];
	      $rrdwhich = $match[4];
	      
	      $cmd = make_graph_url($rrdtype,
				    "rrdfile=".$file.
				    "&name=".$rrdwhat.$rrdwhich);
	      if ($symon2web["magnify"] != '') {
		  $magcmd = make_graph_url($rrdtype,
					   "rrdfile=".$file.
					   "&name=".$rrdwhat.$rrdwhich.
					   "&size=".$symon2web["magnify"]);
		  print '<a class="graph" href="'. $magcmd . '"> <img src="' . $cmd . 
		      '" alt="'. $rrdtype . $rrdwhat . $rrdwhich .'"></a>'."\n";
	      } else {
		  print '<img src="' . $cmd . '" alt="'. $rrdtype . $rrdwhat . $rrdwhich .'">'."\n";
	      }

	      $found_machine++;
	  }
      }
      print '
        <div class="item-footer"></div>
';

  }
  
  if ($found_machine == 0) {
      if ($symon2web["view"] == "one") {
	  print 'Please select a machine';
      } else {
	  print 'Did not find any host directories in '.$symon2web["tree"].'<br>';
      }
  }
?>
       <div class="copyright">Copyright &copy; 2002 Willem Dijkstra</div>
      </div> <!-- end items div -->

      </td> <!-- end main window -->

      <!-- horizontal endline -->
      <td width="1" bgcolor="#555599"><img src="spacer.png" width="1" height="1" alt="|" /></td>
     </tr>

      <!-- vertical endline -->
     <tr> 
      <td width="5%"></td>
      <td colspan="5" bgcolor="#555599"><img src="spacer.png" width="1" height="1" alt="|" /></td>
      <td width="5%"></td>
     </tr>

    </table>
   </td>
   <td width="5%"></td>
  </tr>
 </table>
</body>
</html>
