<?php
// $Id: class_proc.inc,v 1.1 2002/12/29 16:19:36 dijkstra Exp $
require_once("class_graph.inc");

class PROC_Graph extends Graph {
    function PROC_Graph() {
	// get all the sensible defaults from our parent class
	$this->init();
    }
    function execute($url) {
	$this->url2options($url);
	// and add a few private things
	$this->graphsettings["rawcmdline"] .=" -v '% cpu proc(".$this->get("name").")' -u 100 --rigid ";

	$this->shortcut = array_merge($this->shortcut, array(
	    "proc" => array(
		"brief" => array(
		    "dsdefinition" => array(
			"DEF:pct=".$this->get("rrdfile").":cpupct:AVERAGE",
			"DEF:num=".$this->get("rrdfile").":number:AVERAGE",
			"CDEF:inum=0,num,-"),
		    "graphdefinition" => array(
			"AREA:pct#00FF00:'cpupct'",
			"GPRINT:pct:AVERAGE:'%.0lf\g'",
			"AREA:inum#0000FF:'number'",
			"GPRINT:num:AVERAGE:'%.0lf\g'")),
		"detailed" => array(
		    "dsdefinition" => array(
			"DEF:number=".$this->get("rrdfile").":number:AVERAGE",
			"DEF:uticks=".$this->get("rrdfile").":uticks:AVERAGE",
			"DEF:sticks=".$this->get("rrdfile").":sticks:AVERAGE",
			"DEF:iticks=".$this->get("rrdfile").":iticks:AVERAGE",
			"DEF:cpusec=".$this->get("rrdfile").":cpusec:AVERAGE",
			"DEF:cpupct=".$this->get("rrdfile").":cpupct:AVERAGE",
			"DEF:procsz=".$this->get("rrdfile").":procsz:AVERAGE",
			"DEF:rsssz=".$this->get("rrdfile").":rsssz:AVERAGE",
			"CDEF:null=number,number,-",
			"CDEF:inumber=0,number,-"),
		    "graphdefinition" => array(
			'COMMENT:"                 min       avg       max       last\n"',
			"AREA:cpupct#00FF00:'cpupct     '",
			'GPRINT:cpupct:MIN:" %3.2lf %%"',
			'GPRINT:cpupct:AVERAGE:"%3.2lf %%"',
			'GPRINT:cpupct:MAX:"%3.2lf %%"',
			'GPRINT:cpupct:LAST:"%3.2lf %%\n"',
			"AREA:inumber#0000FF:'number     '",
			'GPRINT:number:MIN:" %5.0lf "',
			'GPRINT:number:AVERAGE:"%5.0lf "',
			'GPRINT:number:MAX:"%5.0lf "',
			'GPRINT:number:LAST:"%5.0lf \n"',
			"STACK:null#000000:'uticks    '",
			'GPRINT:uticks:MIN:" %3.2lf %s"',
			'GPRINT:uticks:AVERAGE:"%3.2lf %s"',
			'GPRINT:uticks:MAX:"%3.2lf %s"',
			'GPRINT:uticks:LAST:"%3.2lf %s\n"',
			"STACK:null#000000:'sticks    '",
			'GPRINT:sticks:MIN:" %3.2lf %s"',
			'GPRINT:sticks:AVERAGE:"%3.2lf %s"',
			'GPRINT:sticks:MAX:"%3.2lf %s"',
			'GPRINT:sticks:LAST:"%3.2lf %s\n"',
			"STACK:null#000000:'iticks   '",
			'GPRINT:iticks:MIN:" %3.2lf %s"',
			'GPRINT:iticks:AVERAGE:"%3.2lf %s"',
			'GPRINT:iticks:MAX:"%3.2lf %s"',
			'GPRINT:iticks:LAST:"%3.2lf %s\n"',
			"STACK:null#000000:'cpusec   '",
			'GPRINT:cpusec:MIN:" %5.0lf "',
			'GPRINT:cpusec:AVERAGE:"%5.0lf "',
			'GPRINT:cpusec:MAX:"%5.0lf "',
			'GPRINT:cpusec:LAST:"%5.0lf \n"',
			"STACK:null#000000:'procsz    '", 
			'GPRINT:procsz:MIN:" %3.2lf %s"',
			'GPRINT:procsz:AVERAGE:"%3.2lf %s"',
			'GPRINT:procsz:MAX:"%3.2lf %s"',
			'GPRINT:procsz:LAST:"%3.2lf %s\n"',
			"STACK:null#000000:'rsssz     '",
			'GPRINT:rsssz:MIN:" %3.2lf %s"',
			'GPRINT:rsssz:AVERAGE:"%3.2lf %s"',
			'GPRINT:rsssz:MAX:"%3.2lf %s"',
			'GPRINT:rsssz:LAST:"%3.2lf %s\n"')))));
	$this->graphdefaults = array_merge($this->graphdefaults, 
					   $this->shortcut["proc"]["brief"]);
	$this->url2options($url);

    }
}
?>
