import sys
import os
import ps_lib
import tempfile

class T(ps_lib.T):
    def __write_contents(self, fp):
        fp.write(ps_lib.preamble_text)
        for name in self.__fonts.keys():
            fp.write("/%s {/%s findfont SF} def\n" % (self.__fonts[name], name))
        fp.write("%d %d translate\n" % (-self.__xmin-1, -self.__ymin-1))
        fp.writelines(self.__output_lines)
        fp.write("showpage end\n")
        fp.flush()
        
    def start_gs(self, arg):
        self.pipe_fp = None
	if self.__output_lines == []:
	    return
        
        if sys.platform != "win32":
            cmdline = "gs -q %s -g%dx%d -q >/dev/null 2>&1" % (arg, self.__xmax-self.__xmin + 2, self.__ymax - self.__ymin + 2)
            pipe_fp = os.popen(cmdline, "w")
            self.__write_contents(pipe_fp)
            self.pipe_fp = pipe_fp
        else:
            fname = tempfile.mktemp()
            fp = open(fname, "w")
            self.__write_contents(fp)
            fp.close()
            cmdline = "gs -q %s -g%dx%d -q %s <NUL" % (arg, self.__xmax-self.__xmin + 2, self.__ymax - self.__ymin + 2, fname)
            os.system(cmdline)
            os.unlink(fname)
    def close_gs(self):
        if self.pipe_fp:
            self.pipe_fp.close()
            self.pipe_fp = None
