import string
import doc_support
import sys
import re

import area
import arrow
import axis
import bar_plot
import line_plot
import pie_plot
import color
import error_bar
import fill_style
import font
import text_box
import line_style
import legend
import range_plot
import tick_mark

indent = 4
max_line_len = 64
def format_paragraph(fp, str):
    str = re.sub("<<([^>]+)>>", "See also pychart.\\1", str)

    fp.write(" " * indent)
    line_len = indent
    for word in string.split(str):
        if line_len >= max_line_len:
            fp.write("\n")
            fp.write(" " * indent)
            line_len = indent
        fp.write(word + " ")
        line_len += len(word) + 1
        
def generate_doc(c, name, suffix="", append = 0):
    if append:
        fp = open(name + "_doc.py", "a+")
    else:
        fp = open(name + "_doc.py", "w")
        fp.write("# automatically generated by generate_docs.py.\n")
        
    fp.write("doc" + suffix + "=\"\"\"Attributes supported by this class are:\n")
    for key in c.keys.keys():
            val=c.keys[key]
            description = ""
            if len(val) > 3:
                description = val[3]
            fp.write(key + "(type:" + doc_support.stringify_type(val[0]) + "):\n")
            format_paragraph(fp, description)
            fp.write("\n    default value=" + str(doc_support.stringify_value(val[2])) + ".\n")
    fp.write("\"\"\"\n\n")           
    fp.close()


generate_doc(arrow.T, "arrow")
generate_doc(area.T, "area")
generate_doc(axis.X, "axis", "_x")
generate_doc(axis.Y, "axis", "_y", 1)
generate_doc(bar_plot.T, "bar_plot")
generate_doc(line_plot.T, "line_plot")
generate_doc(pie_plot.T, "pie_plot")
generate_doc(color.T, "color")
generate_doc(error_bar.error_bar1, "error_bar","_1")
generate_doc(error_bar.error_bar2, "error_bar", "_2", 1)
generate_doc(error_bar.error_bar3, "error_bar", "_3", 1)
generate_doc(error_bar.error_bar4, "error_bar", "_4", 1)
generate_doc(error_bar.error_bar5, "error_bar", "_5", 1)
generate_doc(fill_style.T, "fill_style")
generate_doc(text_box.T, "text_box")
generate_doc(range_plot.T, "range_plot")
generate_doc(legend.T, "legend")
generate_doc(legend.Entry, "legend", "_entry", 1)
generate_doc(line_style.T, "line_style")
generate_doc(tick_mark.Base, "tick_mark")
