#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# Script audit and contributions from Carmichael Security <http://www.carmichaelsecurity.com>
#      Erik Anderson <eanders@carmichaelsecurity.com>
#      This one script can and does test for numerous BugIDs and CVEs.  Added reference
#           links to all posted vulnerabilities with boundary lengths less than 
#           the currrent script value of 2048.  
#           All of these posted in the Bugtraq Database appear vulnerable (not tested).
#           Links are current up to 11/16/2002
#
# See the Nessus Scripts License for details
#
# Also covers CVE-2002-0799
#

if(description)
{
 script_id(10184);
 script_version ("$Revision: 1.18.2.1 $");
 
 name["english"] = "Various pop3 overflows";
 name["francais"] = "Divers dpassement de buffers dans pop3";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The remote POP3 server seems
to be subject to a buffer overflow when
it is issued at least one of these commands,
with a too long argument :

	auth
	user
	pass

This problem may allow an attacker to execute
arbitrary code on the remote system, thus
giving him a root shell.

Solution : disable your POP3 server in /etc/inetd.conf
if you don't use it, or upgrade it to a more secure
version.

Reference : http://online.securityfocus.com/archive/1/27197
Reference : http://online.securityfocus.com/bid/789
Reference : http://online.securityfocus.com/bid/790
Reference : http://online.securityfocus.com/bid/830
Reference : http://online.securityfocus.com/bid/894
Reference : http://online.securityfocus.com/bid/942
Reference : http://online.securityfocus.com/bid/2781
Reference : http://online.securityfocus.com/bid/2811
Reference : http://online.securityfocus.com/bid/4055
Reference : http://online.securityfocus.com/bid/4295
Reference : http://online.securityfocus.com/bid/4614

Risk factor : High";


 desc["francais"] = "Le serveur pop3 distant semble
etre sujet  un dpassement de buffer lorsque l'une
des commandes suivante est accompagne d'un
argument trop long :

	auth
	user
	pass
	
Ce problme peut permettre  un pirate d'executer
du code arbitraire sur le systme distant,
lui donnant ainsi un shell root.

Solution : dsactivez votre serveur pop3 dans 
/etc/inetd.conf ( en mettant un diese (#) au debut
de la ligne ) si vous ne vous en servez pas,
ou mettez-le  jour.

Facteur de risque : Elev";
 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Attempts to overflow the in.pop3d buffers";
 summary["francais"] = "Essaye de trop remplir les buffers de in.pop3d";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DESTRUCTIVE_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Gain root remotely";
 family["francais"] = "Passer root  distance";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "qpopper.nasl");
 script_exclude_keys("pop3/false_pop3");
 script_require_ports("Services/pop3", 110);
 exit(0);
}

#
# The script code starts here
#

fake = get_kb_item("pop3/false_pop3");
if(fake)exit(0);
port = get_kb_item("Services/pop3");
if(!port)port = 110;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  d = recv_line(socket:soc, length:1024);
  if(!d){close(soc);exit(0);}
  c = string("AUTH ", crap(2048), "\r\n");
  send(socket:soc, data:c);
  d = recv_line(socket:soc, length:1024);
  if(!d)security_hole(port);
  else {
  	c = string("USER ", crap(1024), "\r\n");
	send(socket:soc, data:c);
	d = recv_line(socket:soc, length:1024);
	if(!d)security_hole(port);
	else
	{
	 c = string("PASS ", crap(1024), "\r\n");
	 send(socket:soc, data:c);
	 d = recv_line(socket:soc, length:1024, timeout:15);
	 if(!d)security_hole(port);
	}
       }
   close(soc);
  }
 }
