#
# Copyright 2000 by Hendrik Scholz <hendrik@scholz.net> 
#
# See the Nessus Scripts License for details
#
# This script is based on the webserver detect script from SecuriTeam.
# But this one uses an HTTP 1.0 request :-)
#

if(description)
{
 script_id(10107);
 script_version ("$Revision: 1.27.2.2 $");
 
 name["english"] = "HTTP Server type and version";
 script_name(english:name["english"]);
 
 desc["english"] = "This detects the HTTP Server's type and version.

Solution: Configure your server to use an alternate name like 
    'Wintendo httpD w/Dotmatrix display'
Be sure to remove common logos like apache_pb.gif.
With Apache, you can set the directive 'ServerTokens Prod' to limit
the information emanating from the server in its response headers.

Risk factor : Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "HTTP Server type and version";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2000 Securiteam / modified by H. Scholz");
 family["english"] = "General";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes", "httpver.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

 port = get_kb_item("Services/www");
 if (!port) port = 80;

 if (get_port_state(port))
 {
  soctcp80 = open_sock_tcp(port);

  if (soctcp80)
  {
   data = http_get(item:"/", port:port);
   resultsend = send(socket:soctcp80, data:data);
   resultrecv = http_recv_headers(soctcp80);
   if ("Server: " >< resultrecv)
   {
    svrline = egrep(pattern:"^Server:", string:resultrecv);
    svr = ereg_replace(pattern:"^Server: (.*)$", string:svrline, replace:"\1");
    report = string("The remote web server type is :\n\n");
    report = report + svr;
    if("Apache" >< svr) {
     if("Apache/" >< svr)report = report + string("\nSolution : You can set the directive 'ServerTokens Prod' to limit\nthe information emanating from the server in its response headers.");
     else{
      report = report + string("\nand the 'ServerTokens' directive is ProductOnly\nApache does not permit to hide the server type\n");
     }
    }else{
     if("Microsoft-IIS/" >< svr){
      report = report + string("\n", "Solution : You can use urlscan to change reported server for IIS.");
     }else{
      report = report + string("\n", "Solution : We recommend that you configure (if possible) your web server to return\n", "a bogus Server header in order to not leak information.\n");
     }
    }
    security_note(port:port, data:report);
    
    #
    # put the name of the web server in the KB
    #
    if(egrep(pattern:"^Server:.*Domino.*", string:svrline))
    	set_kb_item(name:"www/domino", value:TRUE);

    if(egrep(pattern:"^Server:.*Apache.*", string:svrline))
    	set_kb_item(name:"www/apache", value:TRUE);
	
    if(egrep(pattern:"^Server:.*Apache.* Tomcat/", string:svrline, icase:1))
    	set_kb_item(name:"www/tomcat", value:TRUE);
	
    if(egrep(pattern:"^Server:.*Microsoft.*", string:svrline))
    	set_kb_item(name:"www/iis", value:TRUE);
	
    if(egrep(pattern:"^Server:.*Zope.*", string:svrline))
       set_kb_item(name:"www/zope", value:TRUE);
      
    if(egrep(pattern:"^Server:.*CERN.*", string:svrline))
       set_kb_item(name:"www/cern", value:TRUE);
          
    if(egrep(pattern:"^Server:.*Zeus.*", string:svrline))
       set_kb_item(name:"www/zeus", value:TRUE);
       
     if(egrep(pattern:"^Server:.*WebSitePro.*", string:svrline))
       set_kb_item(name:"www/websitepro", value:TRUE);
       	
    if(egrep(pattern:"^Server:.*NCSA.*", string:svrline))
    	set_kb_item(name:"www/ncsa", value:TRUE);
	
    if(egrep(pattern:"^Server:.*Netscape-Enterprise.*", string:svrline))
    	set_kb_item(name:"www/iplanet", value:TRUE);	
 
    if(egrep(pattern:"^Server:.*thttpd/.*", string:svrline))
	set_kb_item(name:"www/thttpd", value:TRUE);
	
    if(egrep(pattern:"^Server:.*WDaemon.*", string:svrline))
	set_kb_item(name:"www/wdaemon", value:TRUE);

    if(egrep(pattern:"^Server:.*SAMBAR.*", string:svrline))
	set_kb_item(name:"www/sambar", value:TRUE);
    
    if(egrep(pattern:"^Server:.*IBM-HTTP-Server.*", string:svrline))
	set_kb_item(name:"www/ibm-http", value:TRUE);

    if(egrep(pattern:"^Server:.*Alchemy.*", string:svrline))
	set_kb_item(name:"www/alchemy", value:TRUE);

    if(egrep(pattern:"^Server:.*Rapidsite/Apa.*", string:svrline))
	set_kb_item(name:"www/apache", value:TRUE);

     if(egrep(pattern:"^Server:.*Statistics Server.*", string:svrline))
	set_kb_item(name:"www/statistics-server", value:TRUE);

     if(egrep(pattern:"^Server:.*CommuniGatePro.*", string:svrline))
	set_kb_item(name:"www/communigatepro", value:TRUE);

     if(egrep(pattern:"^Server:.*Savant.*", string:svrline))
	set_kb_item(name:"www/savant", value:TRUE);
    
     if(egrep(pattern:"^Server:.*StWeb.*", string:svrline))
        set_kb_item(name:"www/stweb", value:TRUE);

     if(egrep(pattern:"^Server:.*StWeb.*", string:svrline))
        set_kb_item(name:"www/apache", value:TRUE);
   
     if(egrep(pattern:"^Server:.*Oracle HTTP Server.*", string:svrline))
	set_kb_item(name:"www/OracleApache", value:TRUE);

     if(egrep(pattern:"^Server:.*Oracle HTTP Server.*", string:svrline))
        set_kb_item(name:"www/apache", value:TRUE);

     if(egrep(pattern:"^Server:.*Stronghold.*", string:svrline))
        set_kb_item(name:"www/stronghold", value:TRUE);

     if(egrep(pattern:"^Server:.*Stronghold.*", string:svrline))
        set_kb_item(name:"www/apache", value:TRUE);

     if(egrep(pattern:"^Server:.*MiniServ.*", string:svrline))
        set_kb_item(name:"www/miniserv", value:TRUE);

     if(egrep(pattern:"^Server:.*vqServer.*", string:svrline))
        set_kb_item(name:"www/vqserver", value:TRUE);

     if(egrep(pattern:"^Server:.*VisualRoute.*", string:svrline))
        set_kb_item(name:"www/visualroute", value:TRUE);

     if(egrep(pattern:"^Server:.*Squid.*", string:svrline))
        set_kb_item(name:"www/squid", value:TRUE);

     if(egrep(pattern:"^Server:.*OmniHTTPd.*", string:svrline))
        set_kb_item(name:"www/omnihttpd", value:TRUE);

     if(egrep(pattern:"^Server:.*linuxconf.*", string:svrline))
        set_kb_item(name:"www/linuxconf", value:TRUE);

     if(egrep(pattern:"^Server:.*CompaqHTTPServer.*", string:svrline))
        set_kb_item(name:"www/compaq", value:TRUE);

     if(egrep(pattern:"^Server:.*WebSTAR.*", string:svrline))
        set_kb_item(name:"www/webstar", value:TRUE);

     if(egrep(pattern:"^Server:.*AppleShareIP.*", string:svrline))
        set_kb_item(name:"www/appleshareip", value:TRUE);

     if(egrep(pattern:"^Server:.*Jigsaw.*", string:svrline))
        set_kb_item(name:"www/jigsaw", value:TRUE);

     if(egrep(pattern:"^Server:.*Resin.*", string:svrline))
        set_kb_item(name:"www/resin", value:TRUE);

     if(egrep(pattern:"^Server:.*AOLserver.*", string:svrline))
        set_kb_item(name:"www/aolserver", value:TRUE);

     if(egrep(pattern:"^Server:.*IdeaWebServer.*", string:svrline))
        set_kb_item(name:"www/ideawebserver", value:TRUE);

     if(egrep(pattern:"^Server:.*FileMakerPro.*", string:svrline))
        set_kb_item(name:"www/filemakerpro", value:TRUE);

     if(egrep(pattern:"^Server:.*NetWare-Enterprise-Web-Server.*", string:svrline))
        set_kb_item(name:"www/netware", value:TRUE);

     if(egrep(pattern:"^Server:.*Roxen.*", string:svrline))
        set_kb_item(name:"www/roxen", value:TRUE);

     if(egrep(pattern:"^Server:.*SimpleServer:WWW.*", string:svrline))
        set_kb_item(name:"www/simpleserver", value:TRUE);

     if(egrep(pattern:"^Server:.*Allegro-Software-RomPager.*", string:svrline))
        set_kb_item(name:"www/allegro", value:TRUE);

     if(egrep(pattern:"^Server:.*GoAhead-Webs.*", string:svrline))
        set_kb_item(name:"www/goahead", value:TRUE);

     if(egrep(pattern:"^Server:.*Xitami.*", string:svrline))
        set_kb_item(name:"www/xitami", value:TRUE);

     if(egrep(pattern:"^Server:.*EmWeb.*", string:svrline))
        set_kb_item(name:"www/emweb", value:TRUE);

     if(egrep(pattern:"^Server:.*Ipswitch-IMail.*", string:svrline))
        set_kb_item(name:"www/ipswitch-imail", value:TRUE);

     if(egrep(pattern:"^Server:.*Netscape-FastTrack.*", string:svrline))
        set_kb_item(name:"www/netscape-fasttrack", value:TRUE);

     if(egrep(pattern:"^Server:.*AkamaiGHost.*", string:svrline))
        set_kb_item(name:"www/akamaighost", value:TRUE);

     if(egrep(pattern:"^Server:.*[aA]libaba.*", string:svrline))
        set_kb_item(name:"www/alibaba", value:TRUE);

     if(egrep(pattern:"^Server:.*tigershark.*", string:svrline))
        set_kb_item(name:"www/tigershark", value:TRUE);

     if(egrep(pattern:"^Server:.*Netscape-Commerce.*", string:svrline))
        set_kb_item(name:"www/netscape-commerce", value:TRUE);

     if(egrep(pattern:"^Server:.*Oracle_Web_listener.*", string:svrline))
        set_kb_item(name:"www/oracle-web-listener", value:TRUE);

     if(egrep(pattern:"^Server:.*Caudium.*", string:svrline))
        set_kb_item(name:"www/caudium", value:TRUE);

     if(egrep(pattern:"^Server:.*Communique.*", string:svrline))
        set_kb_item(name:"www/communique", value:TRUE);

     if(egrep(pattern:"^Server:.*Cougar.*", string:svrline))
        set_kb_item(name:"www/cougar", value:TRUE);

     if(egrep(pattern:"^Server:.*FirstClass.*", string:svrline))
        set_kb_item(name:"www/firstclass", value:TRUE);

     if(egrep(pattern:"^Server:.*NetCache.*", string:svrline))
        set_kb_item(name:"www/netcache", value:TRUE);

     if(egrep(pattern:"^Server:.*AnWeb.*", string:svrline))
        set_kb_item(name:"www/anweb", value:TRUE);

     if(egrep(pattern:"^Server:.*Pi3Web.*", string:svrline))
        set_kb_item(name:"www/pi3web", value:TRUE);

     if(egrep(pattern:"^Server:.*TUX.*", string:svrline))
        set_kb_item(name:"www/tux", value:TRUE);

     if(egrep(pattern:"^Server:.*Abyss.*", string:svrline))
        set_kb_item(name:"www/abyss", value:TRUE);

     if(egrep(pattern:"^Server:.*BadBlue.*", string:svrline))
        set_kb_item(name:"www/badblue", value:TRUE);




     if(egrep(pattern:"^Server:.*Jetty.*", string:svrline))
        set_kb_item(name:"www/jetty", value:TRUE);

   #  if(!egrep(pattern:"^Server:.*", string:svrline))
   #     set_kb_item(name:"www/none", value:TRUE);
   } 
  }
  close(soctcp80);
 }
