#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(11052);
 script_version("$Revision: 1.2.2.2 $");

 name["english"] = "BenHur Firewall active FTP firewall leak";
 script_name(english:name["english"]);

 desc["english"] = "
It is possible to connect on firewall-protected ports on the remote
host by setting one's source port to 20.

An attacker may use this flaw to access services that should not
be accessible to outsiders on this host.


Solution: Reconfigure your firewall to *not* accept anything
coming from port 20.

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Connects to a few services with sport = 20";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);


 script_copyright(english:"This script is Copyright (C) 2002 by Renaud Deraison");
 family["english"] = "Firewalls";
 script_family(english:family["english"]);
 exit(0);
}


function try_syn(dport, sport)
{
 ippkt = forge_ip_packet(
        ip_hl   :5,
        ip_v    :4,
        ip_tos  :0,
        ip_len  :20,
        ip_id   :rand(),
        ip_off  :0,
        ip_ttl  :64,
        ip_p    :IPPROTO_TCP,
        ip_src  :this_host()
        );

  tcppacket = forge_tcp_packet(ip:ippkt,
                               th_sport: sport,
                               th_dport: dport,
                               th_flags:TH_SYN,
                               th_seq: rand(),
                               th_ack: 0,
                               th_x2: 0,
                               th_off: 5,
                               th_win: 8192,
                               th_urp: 0);
			       
			       
 filter = string("tcp and src " , get_host_ip() , " and dst port ", sport, " and src port ", dport);
 reply = send_packet(tcppacket, pcap_active:TRUE, pcap_filter:filter);
 if(reply)
  {
  flags = get_tcp_element(tcp:reply, element:"th_flags");
  
  synack = TH_SYN|TH_ACK;
  
  if (flags == synack) {
	return(1);
	}
	
   if(flags == TH_RST) {
   	exit(0);
   }
  }
 return(0);	       
}


if(islocalhost())exit(0);


if(get_port_state(8888)){
	r = try_syn(dport:8888, sport:1025);
	if(r)exit(0);
}


r = try_syn(dport:8888, sport:20);
if(r)security_hole(8888);
