#
# This script was written by Michel Arboi <arboi@bigfoot.com>
#
# GPL...
#
# SMTP is defined by RFC 821. Messages are defined by RFC 822
#
# Here is the EICAR test string : {
# X5O!P%@AP[4\PZX54(P^)7CC)7}$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*
# You can get it at http://www.eicar.org/anti_virus_test_file.htm
#
# References :
# From: "3APA3A" <3APA3A@SECURITY.NNOV.RU>
# Affiliation: http://www.security.nnov.ru
# To: BUGTRAQ@SECURITYFOCUS.COM
# Subject: SECURITY.NNOV: Bypassing content filtering software
#
# Date:  Mon, 3 Jun 2002 16:19:58 -0400 (EDT)
# From: "David F. Skoll" <dfs@roaringpenguin.com>
# To: bugtraq@securityfocus.com
# Subject: MIME::Tools Perl module and virus scanners
#
# Date:  Fri, 22 Mar 2002 13:24:42 +0300
# From: "3APA3A" <3APA3A@SECURITY.NNOV.RU>
# To: BUGTRAQ@SECURITYFOCUS.COM
# CC: vuln-dev@SECURITYFOCUS.COM
# Subject: One more way to bypass NAV
# 


if(description)
{
 script_id(11034);
 script_version ("$Revision: 1.11.2.1 $");
 name["english"] = "SMTP antivirus filter";
 script_name(english:name["english"]);
 
 desc["english"] = "
Nessus sent several emails containing the EICAR
test strings in them to the postmaster of
the remote SMTP server.

The EICAR test string is a fake virus which
triggers anti-viruses, in order to make sure
they run.

Nessus attempted to e-mail this string five times,
with different codings each time, in order to attempt
to fool the remote anti-virus (if any).


If there is an antivirus filter, these messages should
all be blocked.

*** To determine if the remote host is vulnerable, see
*** if any mail arrived to the postmaster of this host

Solution: Install an antivirus / upgrade it

Risk factor : Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "Test a SMTP antivirus filter";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
 family["english"] = "Firewalls";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes", "smtp_settings.nasl", "smtp_relay.nasl");
 script_require_ports("Services/smtp", 25);
 script_exclude_keys("SMTP/spam");

 #
 exit(0);
}

#
# The script code starts here
#

include("smtp_func.inc");

kb = get_kb_item("SMTP/spam");
if(kb)exit(0);

#

n_sent = 0;

fromaddr = smtp_from_header();
toaddr = smtp_to_header();

port = get_kb_item("Services/smtp");
if (!port) port = 25;

if(!get_port_state(port))exit(0);

s = open_sock_tcp(port);
if (!s) exit(0);

buffer = recv_line(socket:s, length:2048);

send(socket: s, data: string("HELO nessus\r\n"));
buff = recv_line(socket:s, length:2048);

# MIME attachment

header = string("From: ", fromaddr, "\r\nTo: ", toaddr, "\r\n",
	"Organization: Nessus kabale\r\nMIME-Version: 1.0\r\n");

doublequote=raw_string(0x22);
closebracket=raw_string(0x7D);

msg="Subject: Nessus antivirus test 1: base64 attachment
Content-Type: multipart/mixed; boundary=<QQ>=-=-=<QQ>
Lines: 13


--=-=-=

If you can read or execute the attachment, this means that you do not
have an antivirus, or that it was disabled.

--=-=-=
Content-Type: application/octet-stream
Content-Disposition: attachment; filename=eicar.com
Content-Description: EICAR test file

X5O!P%@AP[4\PZX54(P^)7CC)7<CB>$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*
--=-=-=--

";

msg = ereg_replace(pattern:"<QQ>", string:msg, replace:doublequote);
msg = ereg_replace(pattern:"<CB>", string:msg, replace:closebracket);

n=smtp_send_socket(socket:s, from: fromaddr, to: toaddr, body: header+msg);
n_sent=n_sent+n;

# uuencode

msg = "Subject: Nessus antivirus test 2: uuencoded attachment
Lines: 9

If you can read or execute the attachement, you need to install an
antivirus or fix your current one.

begin 664 eicar.com
M6#5/(5`E0$%06S1<4%I8-30H4%XI-T-#*3=])$5)0T%2+5-404Y$05)$+4%.
75$E625)54RU415-4+49)3$4A)$@K2<QQ>H`
`
end
";

msg = ereg_replace(pattern:"<QQ>", string:msg, replace:doublequote);

n=smtp_send_socket(socket:s, from: fromaddr, to: toaddr, body: header+msg);
n_sent=n_sent+n;

# Alternative MIME attachment

header = string("From: ", fromaddr, "\r\nTo: ", toaddr, "\r\n",
	"Organization: Nessus kabale\r\nMIME-Version: 1.0\r\n");

msg="Subject: Nessus antivirus test 3: alternative base64 attachment
Content-Type: multipart/mixed; boundary=<QQ>=-=-=<QQ>
Lines: 13


--=-=-=

If you can read or execute the attachment, this means that you do not
have an antivirus, or that it was disabled.

--=-=-=
Content-Type: application/octet-stream
Content-Disposition: attachment; filename*1=<QQ>eicar.<QQ>; filename*2=<QQ>com<QQ>
Content-Description: EICAR test file

X5O!P%@AP[4\PZX54(P^)7CC)7<CB>$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*
--=-=-=--

";

msg = ereg_replace(pattern:"<QQ>", string:msg, replace:doublequote);
msg = ereg_replace(pattern:"<CB>", string:msg, replace:closebracket);

n=smtp_send_socket(socket:s, from: fromaddr, to: toaddr, body: header+msg);
n_sent=n_sent+n;

# Broken MIME attachment (ISO encoding)

header = string("From: ", fromaddr, "\r\nTo: ", toaddr, "\r\n",
	"Organization: Nessus kabale\r\nMIME-Version: 1.0\r\n");

msg="Subject: Nessus antivirus test 4: broken MIME attachment (ISO encoding)
Content-Type: multipart/mixed; boundary=<QQ>=-=-=<QQ>
Lines: 13


--=-=-=

If you can read or execute the attachment, this means that you do not
have an antivirus, or that it was disabled.

--=-=-=
Content-Type: application/octet-stream
Content-Disposition: attachment; filename=eicar.=?ISO-8859-1?Q?c?= =?ISO-8859-1?Q?o?= =?ISO-8859-1?Q?m?= 
Content-Description: EICAR test file

X5O!P%@AP[4\PZX54(P^)7CC)7<CB>$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*
--=-=-=--

";

msg = ereg_replace(pattern:"<QQ>", string:msg, replace:doublequote);
msg = ereg_replace(pattern:"<CB>", string:msg, replace:closebracket);

n=smtp_send_socket(socket:s, from: fromaddr, to: toaddr, body: header+msg);
n_sent=n_sent+n;

# Case sensitivity of Content-Type and Content-Disposition

header = string("From: ", fromaddr, "\r\nTo: ", toaddr, "\r\n",
	"Organization: Nessus kabale\r\nMIME-Version: 1.0\r\n");

msg="Subject: Nessus antivirus test 5: 'mixed case' base64 attachment
Content-Type: multipart/mixed; boundary=<QQ>=-=-=<QQ>
Lines: 12


--=-=-=

If you can read or execute the attachment, this means that you do not
have an antivirus, or that it was disabled.

--=-=-=
CONTENT-type: text/plain;
	NAme=<QQ>eicar.com<QQ>

X5O!P%@AP[4\PZX54(P^)7CC)7<CB>$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*
--=-=-=--

";

msg = ereg_replace(pattern:"<QQ>", string:msg, replace:doublequote);
msg = ereg_replace(pattern:"<CB>", string:msg, replace:closebracket);

n=smtp_send_socket(socket:s, from: fromaddr, to: toaddr, body: header+msg);
n_sent=n_sent+n;


# TBD: broken MIME attachment - Cf. Bugtraq archives

# Close & quit

send(socket: s, data: string("QUIT\r\n"));
close(s);
if (n_sent == 0) {
  security_note(port: port, 
	data: "For some reason, we could not send the EICAR test string to this MTA");
} 
if (n_sent > 0) {
  security_note(port);
}

