#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10428);
 script_version ("$Revision: 1.21.2.1 $");
 
 name["english"] = "SMB fully accessible registry";
 name["francais"] = "Base de registres completement accessible par SMB";
 
 script_name(english:name["english"],
 	     francais:name["francais"]);
 
 desc["english"] = "

Nessus did not access the remote registry completely,
because this needs to be logged in as administrator.

If you want the permissions / values of all the sensitive
registry keys to be checked for, we recommend that
you fill the 'SMB Login' options in the
'Prefs.' section of the client by the administrator
login name and password.

** Since the password will be sent in clear text, we
suggest you change its value for something else
during the test, as anyone will be able to eavesdrop
it

*** If you are working in a highly sensitive
environment where a second of insecurity
may be critical to you, then forget this
warning and use other tools to check locally
the security of your NT keys.

Risk factor : None";



 desc["francais"] = "
Nessus ne peut pas acceder compltement  la base
de registres, parceque cela ncssite d'etre loggu
en tant qu'administrateur.

Si vous voulez que Nessus teste les permissions / les valeurs
des cls sensibles de la base de registres, alors nous
recommandons que vous remplissiez les options 'SMB Login'
dans la sections 'Prefs.' du client avec le login
de l'administrateur, ainsi que son mot de passe.

** Comme le mot de passe de l'administrateur est
envoy en texte clair, il est fortement suggr
que vous changiez sa valeur pour quelque chose d'autre
pendant la dure du test, car n'importe qui sera
capable de le sniffer.

*** Si vous travaillez dans un environement ultra
sensible dans lequel la moindre seconde d'inattention
scuritaire peut etre dsastreuse pour vous, alors
oubliez ce message et utilisez d'autres outils pour
tester locallement la scurit des cls de votre
base de registres";


 script_description(english:desc["english"],
 		    francais:desc["francais"]);
 
 summary["english"] = "Determines whether the remote registry is fully accessible";
 summary["francais"] = "Dtermine si la base de registres distante est completement accessible";
 script_summary(english:summary["english"],
 		francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl", "smb_registry_access.nasl");
 script_require_keys("SMB/transport", "SMB/name", "SMB/login", "SMB/password", "SMB/registry_access");
 script_require_ports(139, 445);
 exit(0);
}

port = get_kb_item("SMB/transport");
if(!port)port = 139;
if(!get_port_state(port))exit(0);

y = get_kb_item("SMB/name");
if(!y)exit(0);


soc = open_sock_tcp(port);
if(!soc)exit(0);
close(soc);



include("smb_nt.inc");
access = get_kb_item("SMB/registry_access");
if(!access)security_note(port);


key = "SOFTWARE\Microsoft\Internet Explorer\Version Vector";
item = "IE";

value = registry_get_sz(key:key, item:item);
if(value)
{
 set_kb_item(name:"SMB/registry_full_access", value:TRUE);
 exit(0);
}
else {
	security_note(port);
     }
