if (description)
{
 script_id(10780);
 script_version ("$Revision: 1.6.2.1 $");
 script_name(english:"CGIEmail's Cross Site Scripting Vulnerability (cgicso)");
 desc["english"] = "
The remote host seems to be vulnerable to a security problem in 
CGIEmail (cgicso). 
The vulnerability is caused by inadequate processing of queries 
by CGIEmail's cgicso  that results in cross site scripting.

Solution:
Modify cgilib.c to contain a stripper function that will 
remove any HTML or JavaScript tags.

Risk factor : Low";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if a remote host is vulnerable to the cgicso vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses", francais:"Abus de CGI");
 script_copyright(english:"This script is Copyright (C) 2001 SecurITeam");
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");

port = get_kb_item("Services/www");
if (!port) port = 80;

dir[0] = "/bin/";
dir[1] = "/cgi-local/cgiemail-1.4/";
dir[2] = "/cgi-local/";
dir[3] = "/cgi/cgiemail/";
dir[4] = "/html/cgi-bin/";
dir[5] = "/cgi-local/cgiemail-1.6/";

check = string("<script>vulnerable</script>");
 
 
if (!get_port_state(port))exit(0);

for (i = 0; dir[i] ; i = i + 1)
{
 url = string(dir[i], "cgicso");
 data = string(url, "?query=<script>vulnerable</script>");

 req = http_get(item:data, port:port);
 soc = http_open_socket(port);
 if (soc)
 {
   send(socket:soc, data:req);
   buf = http_recv(socket:soc);
   http_close_socket(soc);
   if (check >< buf)
   {
    security_hole(port:port);
    exit(0);
   }
  }
   else exit(0);
}

data = string(cgibin(), "/cgicso?query=<script>vulnerable</script>");
req = http_get(item:data, port:port);
soc = http_open_socket(port);
if(soc)
{
 send(socket:soc, data:req);
 buf = http_recv(socket:soc);
 http_close_socket(soc);
 if(check >< buf)
 {
  security_hole(port);
  exit(0);
 }
}
