<?php
// $Horde: kronolith/lib/WeekView.php,v 1.38.2.3 2002/05/17 22:58:16 jan Exp $

/**
 * The Kronolith_WeekView:: class provides an API for viewing weeks.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>, Jan Schneider <jan@ammma.de>
 * @version $Revision: 1.38.2.3 $
 * @since   Kronolith 0.1
 * @package kronolith
 */
class Kronolith_WeekView {

    var $parsed = false;
    var $days = array();
    var $week = null;
    var $year = null;
    var $startDay = 0;
    var $endDay = 6;


    function Kronolith_WeekView($week = null, $year = null, $startDay = null, $endDay = null)
    {
        if (!isset($year)) $year = date('Y');
        if (!isset($week)) {
            $week = Kronolith::weekOfYear(null, null, $year);
            if ($week == 1 && date('m') == 12) {
                $year++;
            }
        } else {
            if ($week < 1) {
                $year--;
                $week += Kronolith::weeksInYear($year);
            } elseif ($week > Kronolith::weeksInYear($year)) {
                $week -= Kronolith::weeksInYear($year);
                $year++;
            }
        }

        $this->year = $year;
        $this->week = $week;

        if (isset($startDay)) $this->startDay = $startDay;
        if (isset($endDay)) $this->endDay = $endDay;

        $firstDayOfWeek = Kronolith::firstDayOfWeek($week, $year);
        $firstDay = $firstDayOfWeek + Date_Calc::dateToDays(1, 1, $year) - 1;

        include_once KRONOLITH_BASE . '/lib/DayView.php';
        for ($i = $this->startDay; $i <= $this->endDay; $i++) {
            list($day, $month, $year) = explode('/', Date_Calc::daysToDate($firstDay + $i, '%d/%m/%Y'));
            $this->days[$i] = new Kronolith_DayView($month, $day, $year);
        }
    }

    function html($template_path = './templates')
    {
        global $prefs;

        if (!$this->parsed) {
            $this->parse();
        }

        $hours = $this->days[$this->startDay]->Day->hours;

        include $template_path . '/week/head.inc';

        $event_count = 0;
        $color = array();
        for ($j = $this->startDay; $j <= $this->endDay; $j++) {
            $event_count = max($event_count, count($this->days[$j]->all_day_events));
            reset($this->days[$j]->all_day_events);
            $color[$j] = 0;
        }

        $addeventurl = '<span class="hour">' . _("All day") . '</span>';
        $rowspan = ' rowspan="1"';

        $first_row = true;
        $row = '';

        for ($j = $this->startDay; $j <= $this->endDay; $j++) {
            $row .= '<td width="1%" class="text">&nbsp;</td>';
            $row .= '<td colspan="' . $this->days[$j]->span . '" valign="top" style="padding:0px"><table border="0" width="100%" cellspacing="0" cellpadding="0">';
            if (count($this->days[$j]->all_day_events) > 0) {
                foreach ($this->days[$j]->all_day_events as $key => $event) {
                $row .= '<tr><td class="eventbox' . ($color[$j] % 7) . '" valign="top">';
                $row .= $event->getLink($this->days[$j]->Day->getStamp());
                $row .= '</td></tr>' . "\n";
                $color[$j]++;
                }
            } else {
                $row .= '<tr><td colspan="' . $this->days[$j]->span . '">&nbsp;</td></tr>';
            }
            $row .= '</table></td>';
        }
        include $template_path . '/day/all_day.inc';

        $addeventurl = null;
        $started = false;
        for ($i = 0; $i < 48; $i++) {
            if ($i >= $prefs->getValue('day_hour_end') && $i > $this->last) {
                break;
            }
            if (!$started && $i < $prefs->getValue('day_hour_start')) {
                $notstarted = true;
                for ($j = $this->startDay; $j <= $this->endDay; $j++) {
                    $notstarted &= (count($this->days[$j]->event_matrix[$i]) == 0);
                }
                if ($notstarted) {
                    continue;
                }
            }

            $started = true;
            $row = '';
            $time = date(($prefs->getValue('twentyFour')) ? 'G:i' : 'g:ia', $hours[$i]['timestamp']);
            $style = ((($prefs->getValue('half')) ? $i : floor($i/2)) % 2) ? 'item1' : 'item0';

            for ($j = $this->startDay; $j <= $this->endDay; $j++) {
                $hspan = 0;

                // add spacer between days
                $row .= '<td width="1%" class="text">&nbsp;</td>';

                foreach ($this->days[$j]->event_matrix[$i] as $key) {
                    $event = $this->days[$j]->event_arr[$key];
                    $start = mktime(floor($i/2), ($i % 2) * 30, 0, $this->days[$j]->Day->month, $this->days[$j]->Day->mday, $this->days[$j]->Day->year);
                    $span = $this->days[$j]->span - $event->overlap + 1;
                    if ($event->startTimestamp < $start + 60 * 30 && $event->endTimestamp > $start) {
                        $hspan += $span;
                    }
                    if ($event->startTimestamp >= $start && $event->startTimestamp < $start + 60 * 30 || $start == $this->days[$j]->Day->getStamp()) {
                        $row .= '<td class="eventbox' . ($color[$j] % 7) . '" valign="top" width="' . round(90 * ($span / $this->days[$j]->span / count($this->days))) . '%" colspan="' . $span . '" rowspan="' . $event->rowspan . '">';
                        $row .= $event->getLink($this->days[$j]->Day->getStamp());
                        $row .= '</td>' . "\n";
                        $color[$j]++;
                    }
                }

                $diff = $this->days[$j]->span - $hspan;
                if ($diff > 0) {
                    $row .= '<td width="' . round(90 * ($diff / $this->days[$j]->span / count($this->days))) . '%" colspan="' . $diff . '" class="' . $style . '">&nbsp;</td>' . "\n";
                }
            }

            if ($prefs->getValue('half')) {
                $rowspan = false;
                include $template_path . '/day/row.inc';
            } else {
                $rowspan = true;
                if ($i % 2) {
                    include $template_path . '/day/row_half.inc';
                } else {
                    include $template_path . '/day/row.inc';
                }
            }

            $first_row = false;
        }
        include $template_path . '/day/foot.inc';
    }

    // This function runs through the events and tries to figure out
    // what should be on each line of the outputted table. This could
    // get complex...
    function parse()
    {
        for ($i = $this->startDay; $i <= $this->endDay; $i++) {
            $this->days[$i]->parse();
        }

        $this->span = 0;
        for ($i = $this->startDay; $i <= $this->endDay; $i++) {
            $this->span += $this->days[$i]->span;
        }

        $this->last = 0;
        for ($i = $this->startDay; $i <= $this->endDay; $i++) {
            if ($this->days[$i]->last > $this->last) {
                $this->last = $this->days[$i]->last;
            }
        }
    }

    function link($offset = 0)
    {
        $scriptName = basename($_SERVER['PHP_SELF']);
        $week = $this->week + $offset;
        $year = $this->year;
        if ($week < 1) {
            $year--;
            $week += Kronolith::weeksInYear($year);
        } elseif ($week > Kronolith::weeksInYear($year)) {
            $week -= Kronolith::weeksInYear($year);
            $year++;
        }
        return Horde::applicationUrl($scriptName . '?week=' . $week . '&year=' . $year);
    }

}
?>
