%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.0, (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License at
%% http://www.erlang.org/EPL1_0.txt
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Original Code is Erlang-4.7.3, December, 1998.
%% 
%% The Initial Developer of the Original Code is Ericsson Telecom
%% AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
%% Telecom AB. All Rights Reserved.
%% 
%% Contributor(s): ______________________________________.''
%%
%% File    : random.erl
%% Author  : Joe Armstrong, Robert Virding
%% Purpose : Reasonable random number generator.

%%  The method is attributed to B.A. Wichmann and I.D.Hill
%%  See "An efficient and portable pseudo-random number generator",
%%  Journal of Applied Statistics. AS183. 1982. Also Byte March 1987.

-module(random).
-copyright('Copyright (c) 1991-97 Ericsson Telecom AB').
-vsn('$Revision: /main/release/free/1').

-export([seed/0,seed/3,uniform/0,uniform/1]).

%% seed()
%%  Seed random number generation with default values

seed() ->
    seed(3172, 9814, 20125).

%% seed(A1, A2, A3) 
%%  Seed random number generation 

seed(A1, A2, A3) ->
    put(random_seed, 
	{abs(A1) rem 30269, abs(A2) rem 30307, abs(A3) rem 30323}).

%% uniform()
%%  Returns a random float between 0 and 1.

uniform() ->
    {A1, A2, A3} = get(random_seed),
    B1 = (A1*171) rem 30269,
    B2 = (A2*172) rem 30307,
    B3 = (A3*170) rem 30323,
    put(random_seed, {B1,B2,B3}),
    R = A1/30269 + A2/30307 + A3/30323,
    R - trunc(R).

%% uniform(N) -> I
%%  Given an integer N >= 1, uniform(N) returns a random integer
%%  between 1 and N.

uniform(N) ->
    trunc(uniform() * N) + 1.
