# UI-related methods

import os, sys, re, string, time, math
import string
from string import split,join,find,lower,rfind,atoi,strip
from Utils import DLOG,formattedTraceback
from Defaults import DEFAULT_PAGE_TYPE, DISABLE_JAVASCRIPT, \
     LARGE_FILE_SIZE, AUTO_UPGRADE
from AccessControl import getSecurityManager, ClassSecurityInfo
import Permissions
from LocalizerSupport import LocalDTMLFile, _, N_
from Globals import MessageDialog

# built-in defaults for skin objects
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
# modify this to make filesystem templates see the folder as their
# container, like their zodb counterparts. Some simpler way to do
# this ?
from Products.PageTemplates.Expressions import SecureModuleImporter
class MyPageTemplateFile(PageTemplateFile):
    def pt_getContext(self):
        root = self.getPhysicalRoot()
        c = {'template': self,
             'here': self.aq_inner.aq_parent,
             'container': self.aq_inner.aq_parent.aq_parent,
             'nothing': None,
             'options': {},
             'root': root,
             'request': getattr(root, 'REQUEST', None),
             'modules': SecureModuleImporter,
             }
        return c
default_backlinks = MyPageTemplateFile(
    'skins/default/backlinks.pt', globals(), __name__='backlinks')
default_contentspage = MyPageTemplateFile(
    'skins/default/contentspage.pt', globals(), __name__='contentspage')
default_diffform = MyPageTemplateFile(
    'skins/default/diffform.pt', globals(), __name__='diffform')
default_editform = MyPageTemplateFile(
    'skins/default/editform.pt', globals(), __name__='editform')
default_subscribeform = MyPageTemplateFile(
    'skins/default/subscribeform.pt', globals(), __name__='subscribeform')
default_wikipage = MyPageTemplateFile(
    'skins/default/wikipage.pt',globals(), __name__='wikipage')

class UI:
    """
    Holds most of ZWikiPage's UI-related methods.
    """
    security = ClassSecurityInfo()

    security.declareProtected(Permissions.View, 'addStandardLayoutTo')
    def addStandardLayoutTo(self,body,**kw):
        """
        Add standard wiki page layout to the rendered page text.

        If a "bare" keyword is found in REQUEST, or if we are in a CMF
        site, do nothing. Otherwise,
        
        1. if a wikipage page template is found in the zodb (in this
        folder or acquired), use that

        2. if a standard_wiki_header or standard_wiki_footer dtml method
        is found in the zodb, use them (legacy support). If only one is
        found, show a warning for the other.
        
        3. otherwise, use wikipage.pt from skins/default.

        """
        if self.supportsCMF() and self.inCMF():
            # let CMF handle skinning
            return body
        REQUEST = getattr(self,'REQUEST',None)
        if hasattr(REQUEST,'bare') or kw.has_key('bare'):
            return body

        folder = self.folder()
        if (hasattr(folder,'wikipage') and
            getattr(folder.wikipage,'meta_type',None) == 'Page Template'):
            if kw:
                kw['body'] = body
            else:
                kw = {'body':body}
            try:
                return apply(folder.wikipage.__of__(self),
                             (self,REQUEST),kw)
            except:
                return "<html><body>This wiki's custom wikipage template gave an error.\n<pre>%s</pre>\n</body></html>" % formattedTraceback()
                
        elif ((hasattr(folder,'standard_wiki_header') and
               getattr(folder.standard_wiki_header,
                       'meta_type',None) == 'DTML Method') or
              (hasattr(folder,'standard_wiki_footer') and
               getattr(folder.standard_wiki_footer,
                       'meta_type',None) == 'DTML Method')):
            try:
                return self.standard_wiki_header(REQUEST) + \
                       body + \
                       self.standard_wiki_footer(REQUEST)
            except:
                return "<html><body>This wiki's custom standard_wiki_header or standard_wiki_footer method gave an error.\n<pre>%s</pre>\n</body></html>" % formattedTraceback()
        else:
            try:
                if kw:
                    kw['body'] = body
                else:
                    kw = {'body':body}
                return apply(default_wikipage.__of__(self),
                             (self,REQUEST),kw)
            except AttributeError:
                # allow unit tests to run
                return body

    # methods to generate standard forms & dialogs; most of these can be
    # overridden by a page template or DTML method of the same name. 
    # Try to return some meaningul default and message when there is an
    # error, eg due to out of date template objects in the zodb.

    security.declareProtected(Permissions.View, 'standard_wiki_header')
    def standard_wiki_header(self, REQUEST=None):
        """
        Return the custom standard_wiki_header or a default with warning.
        """
        try:
            if hasattr(self.folder(), 'standard_wiki_header'):
                return self.folder().standard_wiki_header(self,REQUEST)
            else:
                return '<html>\n<body>\nThis wiki has a custom standard_wiki_footer but no corresponding standard_wiki_header. Suggestion: remove it.\n'
        except:
            return "<html><body>This wiki's custom standard_wiki_header method gave an error.\n<pre>%s</pre>\n</body></html>" % formattedTraceback()

    security.declareProtected(Permissions.View, 'standard_wiki_footer')
    def standard_wiki_footer(self, REQUEST=None):
        """
        Return the custom standard_wiki_footer or a default with warning.
        """
        try:
            if hasattr(self.folder(), 'standard_wiki_footer'):
                return self.folder().standard_wiki_footer(self,REQUEST)
            else:
                return '<p>This wiki has a custom standard_wiki_header but no corresponding standard_wiki_footer. Suggestion: remove it.</body></html>'
        except:
            return "<html><body>This wiki's custom standard_wiki_footer method gave an error.\n<pre>%s</pre>\n</body></html>" % formattedTraceback()

    security.declareProtected(Permissions.View, 'backlinks')
    def backlinks(self, REQUEST=None):
        """
        Display a default or custom backlinks page. 

        May be overridden by a page template or DTML method of the same
        name.
        """
        try:
            form = getattr(self.folder(),'backlinks',default_backlinks)
            if form.meta_type in ('Page Template',
                                  'Filesystem Page Template',
                                  'Page Template (File)'):
                return form.__of__(self)(self,REQUEST)
            elif form.meta_type == 'DTML Method':
                return form(self,REQUEST)
            else:
                return "<html><body>This wiki's custom backlinks is not a Page Template or DTML Method. Suggestion: remove it.</body></html>"
        except:
            return "<html><body>This wiki's backlinks template gave an error.\n<pre>%s</pre>\n</body></html>" % formattedTraceback()

    security.declareProtected(Permissions.View, 'contentspage')
    def contentspage(self, hierarchy, singletons, REQUEST=None):
        """
        Display a default or custom contents page. 

        May be overridden by a page template or DTML method of the same
        name.
        """
        try:
            form = getattr(self.folder(),'contentspage',default_contentspage)
            if form.meta_type in ('Page Template',
                                  'Filesystem Page Template',
                                  'Page Template (File)'):
                #return apply(form.__of__(self),(self,REQUEST),
                #             {'hierarchy':hierarchy,'singletons':singletons})
                return form.__of__(self)(self,REQUEST,
                                         hierarchy=hierarchy,
                                         singletons=singletons)
            elif form.meta_type == 'DTML Method':
                return form(self,REQUEST,
                            getattr(REQUEST,'RESPONSE',None), #need this ?
                            hierarchy=hierarchy,
                            singletons=singletons)
            else:
                return "<html><body>This wiki's custom contentspage is not a Page Template or DTML Method. Suggestion: remove it.</body></html>"
        except:
            return "<html><body>This wiki's contentspage template gave an error.\n<pre>%s</pre>\n</body></html>" % formattedTraceback()

    security.declareProtected(Permissions.View, 'diffform')
    def diffform(self, revA, difftext, REQUEST=None):
        """
        Display a default or custom contents page. 

        May be overridden by a page template or DTML method of the same
        name.
        """
        try:
            form = getattr(self.folder(),'diffform',default_diffform)
            if form.meta_type in ('Page Template',
                                  'Filesystem Page Template',
                                  'Page Template (File)'):
                return form.__of__(self)(self, REQUEST,
                                         revA=revA,
                                         difftext=difftext)
            elif form.meta_type == 'DTML Method':
                return form(self,REQUEST,
                            revA=revA,
                            difftext=difftext)
            else:
                return "<html><body>This wiki's custom diffform is not a Page Template or DTML Method. Suggestion: remove it.</body></html>"
        except:
            return "<html><body>This wiki's diffform template gave an error.\n<pre>%s</pre>\n</body></html>" % formattedTraceback()

    security.declareProtected(Permissions.Change, 'editform')
    def editform(self, REQUEST=None, page=None, text=None, action='Change'):
        """
        Display the default or a custom form to edit or create a page.

        For new pages, initial text may be specified.  May be overridden
        by a page template or DTML method of the same name.
        """
        if hasattr(self,'wl_isLocked') and self.wl_isLocked():
            return self.davLockDialog()

        # what are we going to do ? set up page, text & action accordingly
        if page is None:
            # no page specified - editing the current page
            page = self.title_or_id()
            text = self.read()
        #elif hasattr(self.folder(), page):
        elif self.pageWithName(page):
            # editing a different page
            text = self.pageWithName(page).read()
        else:
            # editing a brand-new page
            action = 'Create'
            text = text or ''

        # display the edit form - a dtml method or the builtin default
        # NB we redefine id as a convenience, so that one header can work
        # for pages and editforms
        # XXX can we simplify this/make dtml more version independent ?
        # NB 'id' and 'oldid' are no longer used, but provide them for
        # backwards compatibility with old templates
            
        try:
            form = getattr(self.folder(),'editform',default_editform)
            if form.meta_type in ('Page Template',
                                  'Filesystem Page Template',
                                  'Page Template (File)'):
                return form.__of__(self)(self, REQUEST,
                                         page=page,
                                         text=text,
                                         action=action,
                                         id=page,
                                         oldid=self.id())
            elif form.meta_type == 'DTML Method':
                return form(self, REQUEST,
                            page=page,
                            text=text,
                            action=action,
                            id=page,
                            oldid=self.id())
            else:
                return "<html><body>This wiki's custom editform is not a Page Template or DTML Method. Suggestion: remove it.</body></html>"
        except:
            return "<html><body>This wiki's editform template gave an error.\n<pre>%s</pre>\n</body></html>" % formattedTraceback()

    security.declareProtected(Permissions.View, 'subscribeform')
    def subscribeform(self, REQUEST=None):
        """
        Display a default or custom mail subscription form. 

        May be overridden by a page template or DTML method of the same
        name.
        """
        try:
            form = getattr(self.folder(),'subscribeform',default_subscribeform)
            if form.meta_type in ('Page Template',
                                  'Filesystem Page Template',
                                  'Page Template (File)'):
                return form.__of__(self)(self, REQUEST)
            elif form.meta_type == 'DTML Method':
                return form(self,REQUEST)
            elif form.meta_type == 'DEFAULT':
                return form(self,self,REQUEST) # defaults are HTMLFiles
            else:
                return "<html><body>This wiki's custom subscribeform is not a Page Template or DTML Method. Suggestion: remove it.</body></html>"
        except:
            return "<html><body>This wiki's subscribeform template gave an error.\n<pre>%s</pre>\n</body></html>" % formattedTraceback()
    
    security.declareProtected(Permissions.View, 'editConflictDialog')
    def editConflictDialog(self):
        """
        web page displayed in edit conflict situations.
        """
        titlestr=_('Edit conflict')
        return MessageDialog(
            title=titlestr,
            message="""
            <b>%s</b>
            <p>
            %s.
            %s:
            <ol>
            <li>%s
            <li>%s
            <li>%s
            <li>%s
            <li>%s.
            </ol>
            %s,
            <p>
            %s.
            """ % (
            titlestr,
            _("Someone else has saved this page while you were editing"),
            _("To resolve the conflict, do this"),
            _("Click your browser's back button"),
            _("Copy your recent edits to the clipboard"),
            _("Click your browser's refresh button"),
            _("Paste in your edits again, being mindful of the latest changes"),
            _("Click the Change button again"),
            _("or"),
            _("To discard your changes and start again, click OK"),
            ),
            action=self.page_url()+'/editform')

    security.declareProtected(Permissions.View, 'davLockDialog')
    def davLockDialog(self):
        """
        web page displayed in webDAV lock conflict situations.
        """
        titlestr=_('Page is locked')
        return MessageDialog(
            title=titlestr,
            message="""
            <b>%s</b>
            <p>
            %s
            <p>
            %s
            """ % (
            titlestr,
            _("""
            This page has a webDAV lock. Someone is probably editing it
            with an external editor.  You'll need to wait until they've
            finished and then try again.  If you've just made some changes,
            you may want to back up and copy your version of the text for
            reference.
            """),
            _("To discard your changes and try again, click OK."),
            ),
            action=self.page_url()+'/editform')

