'\"
'\" Generated from ./modules/crc/sum.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "sum" n 1.0 crc "sum"
.BS
.SH NAME
sum \- calculate a sum(1) compatible checksum
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBsum ?1.0?\fR
.sp
\fB::crc::sum\fR ?-format \fIformat\fR? \fImessage\fR\fR
.sp
\fB::crc::sum\fR ?-format \fIformat\fR? -filename \fIfile\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
This package provides a Tcl-only implementation of the sum(1) command
which calculates a 16 bit checksum value from the input data.  The BSD
sum algorithm is used by default but the SysV algorithm is also
available.
.SH "COMMANDS"
.TP
\fB::crc::sum\fR ?-format \fIformat\fR? \fImessage\fR\fR
.TP
\fB::crc::sum\fR ?-format \fIformat\fR? -filename \fIfile\fR\fR
The command takes string data or a file name and returns a checksum
value calculated using the \fBsum(1)\fR algorithm. The result is
formatted using the \fIformat\fR(n) specifier provided or as an
unsigned integer (%u) by default.
.SH "OPTIONS"
.TP
-filename \fIname\fR
Return a checksum for the file contents instead of for parameter data.
.TP
-format \fIstring\fR
Return the checksum using an alternative format template.
.SH "EXAMPLES"
.PP
.nf
% crc::sum "Hello, World!"
37287
.fi
.PP
.nf
% crc::sum -format 0x%X "Hello, World!"
0x91A7
.fi
.PP
.nf
% crc::sum -file sum.tcl
13392
.fi
.SH "SEE ALSO"
sum(1), cksum(n), crc32(n)
.SH "AUTHORS"
Pat Thoyts
.SH "KEYWORDS"
sum, cksum, checksum, crc, crc32, cyclic redundancy check, data integrity, security

