<?php
// $Id: class_graph.inc,v 1.7 2002/11/29 10:45:46 dijkstra Exp $
//
// Base class for all graph classes. 

class Graph {
    var $debug;
    var $graphdefaults;
    var $graphsettings;
    var $options;
    var $shortcut;    

    function Graph() {
	$this->init();
    }

    function enable_debug() {
	$this->debug = 1;
    }
    function debug($string) {
	if ($this->debug) {
	    print "<hr><br>$string<br><hr>";
	}
    }

    function dump_vars() {
	print "<br><hr><br><b>graphsettings</b>:<br><pre>";
	print_r($this->graphsettings);
	print "</pre><br><hr><br><b>options</b>:<br><pre>";
	print_r($this->options);
	print "</pre><br><hr><br>";
    }
    // fill meta parameters
    // this function will most likely not be overloaded by child classes
    function init() {
	$this->debug = 0;

	$this->graphdefaults = array( 
	    "width"     => array("max" => 2048, "min" => 32,           "default" => 300),
	    "height"    => array("max" => 2048, "min" => 32,           "default" => 225),
	    "start"     => array("max" => 429467296,    "min" => -4294967296,  "default" => -86400),	
	    "end"       => array("max" => 429467296,    "min" => -4294967296,  "default" => -1),
	    "imagetype" => "PNG",
	    "rrdtool"   => "/usr/local/bin/rrdtool graph -",
	    "rrdfile"   => "",
	    "name"      => "unnamed graph");
	
	$this->options = array(
	    "width"     => "-w",
	    "height"    => "-h",
	    "imagetype" => "-a",
	    "start"     => "-s", 
	    "end"       => "-e" );

	$this->shortcut = array(
	    // date shortcuts
	    "timespan"  => array(
		"today"     => array(
		    "start" => -86400 ),
		"lastweek"  => array(
		    "start" => -604800 ),
		"lastmonth" => array( 
		    "start" => -2419200 )),
	    // size shortcuts
	    "size"      => array(
		"tiny"      => array(
		    "width"  => 100,
		    "height" => 75 ),
		"small"     => array(
		    "width"  => 200,
		    "height" => 125 ),
		"normal"    => array(
		    "width"  => 300,
		    "height" => 225 ),
		"big"      => array(
		    "width" => 600,
		    "height" => 450 ),
		"huge"      => array(
		    "width" => 1024,
		    "height" => 640 )));
	$this->graphsettings = array(
	    "graphdefinition" => array(),
	    "dsdefinition" => array(),
	    "rawcmdline" => "");
    }

    // parseoptions will not be overloaded by child classes
    function parseoptions (&$params) {
	$myparams = array();
	// look for shortcuts
	if (!empty($params) && is_array($params)) {
	    reset($params);
	    while (list($key, $value) = each($params)) {
		if (isset($this->shortcut[$key][$value])) { 
		    $ar = $this->shortcut[$key][$value];
		    while (list($itemkey,$itemvalue) = each($ar)) {
			if (is_array($this->shortcut[$key][$value][$itemkey])) {
			    $myparams[$itemkey] = array_merge(array(),$this->shortcut[$key][$value][$itemkey]);
			} else if (is_scalar($itemvalue)) {
			    $myparams[$itemkey] = $itemvalue;
			}
		    }
		} else {
		    $myparams[$key] = $value;
		}
	    }
	}

	// copy parameters, filling in defaults and constraining to acceptable
	// values where necessary
	reset($this->graphdefaults);
	reset($myparams);
	while (list($key, $value) = each($this->graphdefaults)) {
	    if (isset($myparams[$key])) {
		if (is_array($myparams[$key])) {
		    $value = $myparams[$key];
		} else {
		    $value = escapeshellcmd($myparams[$key]);
		}
	    } else {
		if (isset($this->graphsettings[$key])) {
		    // is this set already, is current value .. 
		    if ((is_array($this->graphsettings[$key]) && 
			 count($this->graphsettings[$key]) != 0) // an non empty array?
			|| (is_scalar($this->graphsettings[$key]))) // or a scalar
		    {
			// yes: keep current set value
			$value = $this->graphsettings[$key];
		    }
		    // no: implicit; set to default
		} else if (is_array($value) && isset($value["default"])) {
		    // - check if it is an min/max/default array
		    $value = $value["default"];
		}
	    }

	    // normalize parameters
	    if (is_array($this->graphdefaults[$key])
		&& isset($this->graphdefaults[$key]["max"]) 
		&& $value > $this->graphdefaults[$key]["max"]) {
		$value = $this->graphdefaults[$key]["max"];
	    }
	    if (is_array($this->graphdefaults[$key]) 
		&& isset($this->graphdefaults[$key]["min"]) 
		&& $value < $this->graphdefaults[$key]["min"]) {
		$value = $this->graphdefaults[$key]["min"];
	    }
	    
	    $this->graphsettings[$key] = $value;
	}
    }
    
    // will not be overloaded by child classes
    function cmdline() {

	$cmdline = $this->graphsettings["rrdtool"];

	// get options
	reset($this->options);
	while (list($key, $value) = each($this->options)) {
	    if (isset($this->graphsettings[$key])) {
		$cmdline .= ' '.$value.' '.$this->graphsettings[$key];
	    }
	}
	
	$cmdline .= $this->graphsettings["rawcmdline"];
	while (list($key, $value) = each($this->graphsettings["dsdefinition"])) {
	    $cmdline .= ' '.$value;
	}

	while (list($key, $value) = each($this->graphsettings["graphdefinition"])) {
	    $cmdline .= ' '.$value;
	}

	return $cmdline;
    }

    function sendimage() {
	$cmd = $this->cmdline();
	$this->debug($cmd);
	header("content-type: image/png");
	passthru($cmd);
    }

    function url2options($url) {
	$options = array();
	$url = urldecode($url);
	$args = explode('&', $url);
	$i = 0;
	while ($i < count($args)) {
	    $operand = split('=', $args[$i]);
	    if (!empty($operand) 
		&& is_array($operand) 
		&& count($operand) >= 2) {
		$key = htmlspecialchars(urldecode($operand[0]));
		if ($key == "opcode") {
		    $this->graphsettings = 
			unserialize(
			    gzuncompress(
				base64_decode(
				    urldecode($operand[1]))));
		} else {
		    $value = htmlspecialchars(urldecode($operand[1]));
		    $options[$key] = $value;
		}
	    }
	    $i++;
	}
	$this->parseoptions($options);
    }
    function settings2url() {
	$settings = urlencode(
	    base64_encode(
		gzcompress(
		    serialize($this->graphsettings),9)));
	return "opcode=".$settings;
    }

    function add($setting, $valuearray) {
	$this->graphsettings[$setting] = 
	    array_merge($this->graphsettings[$setting], $valuearray);
    }

    function set($setting, $value) {
	$this->graphsettings[$setting] = $value;
    }

    function get($setting) {
	return $this->graphsettings[$setting];
    }
}

?>
