# 
# $Id: README,v 1.4 2002/10/03 20:06:10 jiri Exp $
#

From: Bogdan Andrei Iancu <iancu@fokus.gmd.de>



                           StateLess (SL) Module


1.Description

The SL module allows ser to act as a stateless UA server
and generate replies to SIP requests without keeping state.
That is beneficial in many scenarios, in which you wish
not to burden server's memory and scale well.


2.Module parameters

None.


3.Exported functions

 - sl_send_reply(code,text_reason)
For the current request, a reply is sent back having the given code and text
reason. The reply is sent stateless, totally independent of the Transaction
module and with no retransmission for the INVITE's replies.

 - sl_reply_error()
Sends back an error reply describing the nature of the last internal error.
Usually this function should be used after a script function that returned an
error code.


4.Modules dependency

None.


5.Implementation details


The SL module needs to filter ACKs sent after a local stateless
reply to an INVITE was generated. To recognize such ACKs, ser
adds a special "signature" in to-tags. This signature is sought
for in incoming ACKs, and if included, the ACKs are absorbed.

TO speed up the filtering process, the module uses a timeout mechanism. When
a reply is sent, a timer us set. As time as the timer is valid, The incoming
ACK requests will be checked using TO tag value  Once the timer expires, all
the ACK are let through - a long time passed till it sent a reply, so it does
not expect any ACK that have to be blocked.

6. Known Limitations

The ACK filtering may fail in some rare cases. If you think these
matter to you, better use stateful processing (tm module) for
INVITE processing. Particularly, the problem happens when
a UA sends an INVITE which already has a to-tag in it (e.g.,
a re-INVITE) and SER want to reply to it. Than, it will
keep the current to-tag, which will be mirrored in ACK.
SER will not see its signature and forward the ACK
downstream. Caused harm is not bad -- just a useless
ACK is forwarded.
