import fill_style
import canvas
import copy

def __draw_zap(p1, p2, style, pat):
    x = copy.deepcopy(p1)
    x.extend(p2)

    canvas.polygon(None, fill_style.white, x, pat)
    canvas.lines(style, p1)
    canvas.lines(style, p2)
    

def zap_horizontally(style, pat, x1, y1, x2, y2, xsize, ysize):
    """Draw a horizontal "zapping" symbol on the canvas that shows
    that a graph is ripped in the middle. The top and bottom zig-zag lines
    are drawn with STYLE, and the middle part is filled with PAT.
    The symbol is drawn in the rectangle (X1, Y1) - (X2, Y2), and
    each "zigzag" has the width XSIZE, height YSIZE."""
    
    points = []
    points2 = []
    x = x1
    y = y1
    while x < x2:
        points.append((x, y))
        points2.append((x, y + (y2-y1)))
        x = x + xsize
        if y == y1:
            y = y + ysize
        else:
            y = y - ysize

    points2.reverse()
    __draw_zap(style, pat, points, points2)

def zap_vertically(style, pat, x1, y1, x2, y2, xsize, ysize):
    """Draw a vertical "zapping" symbol on the canvas that shows
    that a graph is ripped in the middle. The left and right zig-zag lines
    are drawn with STYLE, and the middle part is filled with PAT.
    The symbol is drawn in the rectangle (X1, Y1) - (X2, Y2), and
    each "zigzag" has the width XSIZE, height YSIZE."""
    points = []
    points2 = []
    x = x1
    y = y1
    while y < y2:
        points.append((x, y))
        points2.append((x + (x2-x1), y))
        y = y + ysize
        if x == x1:
            x = x + xsize
        else:
            x = x - xsize

    points2.reverse()
    __draw_zap(style, pat, points, points2)

