#
# This script was written by Renaud Deraison <deraison@nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10940);
 script_version ("$Revision: 1.1 $");

 name["english"] = "Windows Terminal Service Enabled";

 script_name(english:name["english"]);

    desc["english"] = "
The Terminal Services are enabled on the remote host.

Terminal Services allow a Windows user to remotely obtain
a graphical login (and therefore act as a local user on the
remote host).

If an attacker gains a valid login and password, he may
be able to use this service to gain further access
on the remote host.


Solution : Disable the Terminal Services if you do not use them
Risk factor : Low";


 script_description(english:desc["english"]);
 

 summary["english"] = "Connects to the remote terminal server";
 script_summary(english:summary["english"], francais:summary["francais"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison");

 family["english"] = "Useless services";
 family["francais"] = "Services inutiles";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");

 exit(0);
}



port = 3389;
if(get_port_state(port))
{
   soc = open_sock_tcp(port);
   str = raw_string(0x03, 0x00, 0x00, 0x0B, 0x06, 0xE0,
       		    0x00, 0x00, 0x00, 0x00, 0x00);
   send(socket:soc, data:str);
   r = recv(socket:soc, length:11);

   if(ord(r[0]) == 0x03)security_note(port);
   close(soc);
}
