#
# This script was written by Michael Scheidell <scheidell at secnap.net>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10861);
 script_version("$Revision: 1.9.2.4 $");
 script_bugtraq_id(3578);
 script_cve_id("CAN-2002-1262","CAN-2002-0026","CVE-2001-0727");
 name["english"] = "IE 5.01 5.5 6.0 Cumulative patch Q324929";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The 4 December 2002 Cumulative Patch for IE is
not applied on the remote host.

Impact of vulnerability: Run code of attacker's choice. 

Recommendation: Customers using IE should install the patch immediately. 

Affected Software: 

Microsoft Internet Explorer 5.01
Microsoft Internet Explorer 5.5 
Microsoft Internet Explorer 6.0 

NOTE: Might require full registry access on win2k and xp

Supersedes MS01-055, MS01-058, MS02-005, MS02-066 and others

See http://www.microsoft.com/security/security_bulletins/ms02-068.asp

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines whether the hotfix Q324929 is installed";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 Michael Scheidell");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl", "smb_registry_full_access.nasl",
 		     "smb_reg_service_pack.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password", "SMB/registry_full_access");
 script_require_ports(139, 445);
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}

include("smb_nt.inc");
access = get_kb_item("SMB/registry_full_access");
if(!access)exit(0);

port = get_kb_item("SMB/transport");
if(!port)port = 139;

version = get_kb_item("SMB/WindowsVersion");


if(version)
{
 key = "SOFTWARE\Microsoft\Internet Explorer\Version Vector";
 item = "IE";
 value = string(registry_get_sz(key:key, item:item));

 if(!value)
 {
   security_note(port:port,data:"We were unable to determine what version of IE you are running");
   exit(0);
 }

 report = string("We were able to determine that you are running IE Version ",value);
 
 key =  "SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings";
 item = "MinorVersion";
 minorversion = string(registry_get_sz(key:key, item:item));

 if(minorversion)
    report = report + string("\nwith these IE Hotfixes installed:",minorversion);

 if( !("Q324929" >< minorversion))
   {
    report = report + string("\n
But is missing security update Q324929.
Recommendation: Customers using Microsoft IE  should install
this patch immediately. 

Impact of vulnerability: Run code of attacker's choice. 

See http://www.microsoft.com/technet/security/bulletin/ms02-068.asp
Supersedes MS01-055 and MS02-066 and others\n\n

Risk factor : High");

   security_hole(port:port, data:report);
  }
 else
   security_note(port:port, data:report);
}

