#
# This script was written by Michel Arboi <arboi@bigfoot.com>
#
# GPL...
#
# NNTP protocol is defined by RFC 977
# NNTP message format is defined by RFC 1036 (obsoletes 850); see also RFC 822.
#

if(description)
{
 script_id(11033);
 script_version ("$Revision: 1.11.2.1 $");
 name["english"] = "Misc information on News server";
 script_name(english:name["english"]);
 
 desc["english"] = "This script detects if the NNTP server is open to outside,
counts the number of groups, and tries to post outside.
This channel may been used by virus or trojan.

Solution: Disable the server if it is not used

Risk factor : Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "Misc information on News server";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
 family["english"] = "General";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes");
 script_require_ports("Services/nntp", 119);

 #
 script_add_preference(name:"From address : ", type:"entry", 
			value:"Nessus <listme@listme.dsbl.org>");
 script_add_preference(name:"Test group name regex : ", type:"entry", 
			value:"f[a-z]\.tests?");
 script_add_preference(name:"Max crosspost : ", type:"entry", value:"7");
 #
 script_add_preference(name:"Local distribution", type:"checkbox", value:"yes");
 script_add_preference(name:"No archive", type:"checkbox", value:"no");
 exit(0);
}

#
# The script code starts here
#

function nntp_auth(socket, username, password)
{
 if (!username) return (0);

 send(socket:socket, data: string("AUTHINFO USER ", username, "\r\n"));
 buff = recv(socket:socket, length:2048);
 send(socket:socket, data: string("AUTHINFO PASS ", password, "\r\n"));
 buff = recv(socket:socket, length:2048);
 if ("502 " >< buff) { 
  display(string("Bad username/password for NNTP server"));
  return (0);
 }
 return (1);
}

function nntp_connect(port, username, password)
{
  s = open_sock_tcp(port: port);
  if (s) { 
   buff = recv(socket: s, length: 2048);
   nntp_auth(socket: s, username: username, password: password); 
  }
  return (s);
}

function nntp_post(socket, message)
{
  if (! socket) { return (0); }
  send(socket: socket, data:string("POST\r\n"));
  buff = recv_line(socket:s, length: 2048);

  # 340 = Go ahead; 440 = posting prohibited
  if ("340 " >< buff) {
    send(socket: socket, data: message);
    buff = recv_line(socket: socket, length: 2048);
    if ("240 " >< buff) { return (1); }
    if (ereg(pattern: "^4[34][0-9] +.*unwanted distribution .*local", 
             string: buff, icase:1) &&
        ereg(pattern: "Distribution: +local", string: message)) {
      security_note(port: port, 
data: "The server rejected the message. Try again without 'local distribution' 
if you don't mind leaking information outside");
    }
  }
 return (0);
}

function nntp_article(id, timeout, port, username, password)
{
  for (t=0; t < timeout; t=t+20)
  {
    sleep(20);
    s = nntp_connect(port:port, username: username, password: password);
    if (s) {
      send(socket:s, data: string("ARTICLE ", id, "\r\n"));
      buff = recv(socket: s, length: 2048);
      send(socket:s, data: string("QUIT\r\n"));
      close(s);
      # display(string("Article > ", buff));
      # WARNING! If the header X-Nessus is removed, change this line!
      if (ereg(pattern:"^220 .*X-Nessus:", string: buff)) { return (buff); }
    }
  }
  return (0);
}

function nntp_make_id(str)
{
 # Not RFC 822 compliant - we should use a full domain name
 # We do not check "str", but it should not contain '@' or '>'
 id=string("<", str, ".", rand(), "@", this_host(), ".NESSUS>");
 return(id);
}

#

user = get_kb_item("nntp/login");
pass = get_kb_item("nntp/password");
fromaddr = script_get_preference("From address : ");

# Michael Scheidell gave me this spam trap address.
if (! fromaddr)  { fromaddr="Nessus <listme@listme.dsbl.org>"; }

local_distrib = script_get_preference("Local distribution");
if (! local_distrib) local_distrib = "yes";
x_no_archive = script_get_preference("No archive");
if (!x_no_archive) x_no_archive = "no";

# WARNING! If the header X-Nessus is removed, change nntp_article function!
more_headers = string(
	"User-Agent: Nessus Security Scanner 1.2\r\n",
	"Organization: Nessus Kabale\r\n",
	"X-Nessus: Nessus can be found at http://www.nessus.org/\r\n",
	"X-Abuse-1: The machine at ", get_host_ip(),
	" was scanned from ", this_host(), "\r\n",
	"X-Abuse-2: If you [", get_host_ip(), 
	"] are not currently running a security audit, please complain to them [",  
	this_host(),
	"], not to the Nessus team\r\n",
	"X-Abuse-3: fields Path and NNTP-Posting-Host may give you more reliable information\r\n",
	"X-Abuse-4: Do not answer to the From address, it may be phony and you may blacklist your mail server\r\n",
	"X-NNTP-Posting-Host: ", this_host(), "\r\n"	);

if ("yes" >< local_distrib) { more_headers=more_headers+"Distribution: local\r\n";}
if ("yes" >< x_no_archive) { more_headers=more_headers+"X-No-Archive: yes\r\n";}

# tictac = time();
# if (tictac) more_headers=more_headers+string("Date: ", tictac, "\r\n");

port = get_kb_item("Services/nntp");
if (!port) port = 119;
if(!get_port_state(port))exit(0);

s = open_sock_tcp(port);
if (!s) exit(0);

buff = recv(socket:s, length:2048);

ready=0; posting=0; noauth=1; 
nolist=0; 

# Try to connect to the server

if ("200 " >< buff) { ready=1; posting=1;}
if ("201 " >< buff) { ready=1;}
if (! ready) {
 # Not a NNTP server?
 close(s);
 exit(0);
}

notice = "";

# Does it need authentication before any command?

ng="NoSuchGroup" + rand();
send(socket: s, data: string("LIST ACTIVE ", ng, "\r\n"));
buff = recv(socket:s, length:2048);

if ("480 " >< buff) { noauth = 0; }

authenticated = nntp_auth(socket:s, username: user, password: pass);

testgroups="";
testRE = script_get_preference("Test group name regex : ");
if (! testRE) { testRE = "f[a-z]\.tests?"; }
# Note: we hardcoded alt.test
testRE = "^(" + testRE + ") .*$";
max_crosspost = script_get_preference("Max crosspost : ");
if (! max_crosspost) { max_crosspost = 7; }

if (noauth) 
notice=notice+string("This NNTP server allows unauthenticated connections\n");

if (!noauth) {
 notice=notice+string("This NNTP server does not allows unauthenticated connections\n");
 if (! authenticated)
  notice=notice+string("As no good username/password was provided, we cannot send our test messages\n");
}

if (! posting) {
 notice=notice+string("This NNTP server does not allow posting\n");
}

# No use to go on if we are unable to authenticate 
if (! authenticated && ! noauth) {
 send(socket:s, data:string("QUIT\r\n"));
 close(s);
 if (notice)
  security_note(port:port, data:notice);
 exit(0);
}

# Let's count the groups! (this is slow)

send(socket:s, data: string("LIST ACTIVE\r\n"));
buff = recv_line(socket:s, length: 2048);

if (! ereg(pattern:"^2[0-9][0-9] ", string:buff)) { nolist=1; }

total_len = 8; nbg = 1;
testNGlist = "alt.test";

altNB=0; bizNB=0; compNB=0; miscNB=0; 
newsNB=0; recNB=0; sciNB=0; socNB=0; 
talkNB=0; humanitiesNB=0;

if (!nolist) {
 buff = recv_line(socket:s, length: 2048);
 n = 0;
 while (buff && ! ereg(pattern:"^\.[\r\n]+", string: buff))
 {
  if (ereg(pattern:"^alt\.", string: buff)) { altNB=altNB+1; }
  if (ereg(pattern:"^rec\.", string: buff)) { recNB=recNB+1; }
  if (ereg(pattern:"^biz\.", string: buff)) { bizNB=bizNB+1; }
  if (ereg(pattern:"^sci\.", string: buff)) { sciNB=sciNB+1; }
  if (ereg(pattern:"^soc\.", string: buff)) { socNB=socNB+1; }
  if (ereg(pattern:"^misc\.", string: buff)) { miscNB=miscNB+1; }
  if (ereg(pattern:"^news\.", string: buff)) { altNB=newsNB+1; }
  if (ereg(pattern:"^comp\.", string: buff)) { compNB=compNB+1; }
  if (ereg(pattern:"^talk\.", string: buff)) { talkNB=talkNB+1; }
  if (ereg(pattern:"^humanities\.", string: buff)) { humanitiesNB=humanitiesNB+1; }

  if (ereg(pattern:testRE, string: buff)) {
    group_name = ereg_replace(pattern:testRE, string:buff, icase:1, replace:"\1");
    # display(string("Group=", group_name, "\n"));
    l = strlen(group_name);
    if ((l + 1 + total_len <= 498) && (nbg < max_crosspost)) {
     total_len = total_len + l + 1;
     nbg = nbg + 1;
     testNGlist = string(testNGlist, ",", group_name);
    }
  }

  buff=recv_line(socket:s, length:2048);
  # display(string("> ", buff));
  n=n+1;
 }

 notice=notice+string(	"For your information, we counted ", 
			n, 
			" newsgroups on this NNTP server:\n",
		altNB, " in the alt hierarchy, ",
		recNB, " in rec, ", 
		bizNB, " in biz, ", 
		sciNB, " in sci, ", 
		socNB, " in soc, ", 
		miscNB, " in misc, ", 
		newsNB, " in news, ", 
		compNB, " in comp, ", 
		talkNB, " in talk, ", 
		humanitiesNB, " in humanities.\n"
	);
}

if (nbg > 1) more_headers=more_headers+string("Followup-To: alt.test\r\n");

# Try to post a message

msgid = nntp_make_id(str: "post");
# display(string("testNGlist=", testNGlist, "\n"));

msg = string(
	"Newsgroups: ", testNGlist, "\r\n",
	"Subject: Nessus post test ", rand(), " (ignore)\r\n",
	"From: ", fromaddr, "\r\n",
	"Message-ID: ", msgid, "\r\n",
	more_headers,
	"Content-Type: text/plain; charset: us-ascii\r\n",
	"Lines: 1\r\n",
	"\r\n",
	"Test message (post). Please ignore.\r\n",
	".\r\n");	

posted = nntp_post(socket: s, message: msg);

send(socket:s, data:string("QUIT\r\n"));
close(s);

#

sent = 0;
if (nntp_article(id: msgid, timeout: 60, port: port, username: user, password:pass)) { sent = 1; posted=1; i=9999; }

if (posted && ! posting) {
 notice=notice+"Although this server says it does not allow posting, we could send a message";
 if (! sent) notice = notice + ". We were unable to read it again, though...";
 notice=notice+string("\n");
}

if (! posted && posting)
 notice=notice+string("Although this server says it allows posting, we were unable to send a message\n(posted in ",testNGlist, ")\n");

if (posting && posted && ! sent)
  notice=notice+string("Although this server accepted our test message for delivery, we were unable to read it again\n");

if (! sent) {
  if (notice)
    security_note(port: port, data: notice);
  exit(0);
}

# Test Supersede

supid = nntp_make_id(str: "super");
posted = 0; sent = 0; superseded = 0;

sup = string(
	"Supersedes: ", msgid, "\r\n",
	"Newsgroups: ", testNGlist, "\r\n",
	"Subject: Nessus supersede test ", rand(), " (ignore)\r\n",
	"From: ", fromaddr, "\r\n",
	"Message-ID: ", supid, "\r\n",
	more_headers,
	"Content-Type: text/plain; charset: us-ascii\r\n",
	"Lines: 1\r\n",
	"\r\n",
	"Test message (supersede). Please ignore.\r\n",
	".\r\n");	

s = nntp_connect(port:port, username: user, password: pass);
if (s) {
 posted = nntp_post(socket: s, message: sup);
 send(socket:s, data: string("QUIT\r\n"));
 close(s);
}

if (nntp_article(id: supid, timeout: 60, username: user, password:pass)) { sent=1; posted=1; }
if (! nntp_article(id: msgid, timeout: 10, username: user, password:pass)) { superseded = 1; }

if (superseded)
  notice=notice+string("This NNTP server implements Supersede\n");

if (!superseded && posted)
  notice=notice+string("This NNTP server does not implement Supersede\n");

if (!superseded && !posted)
  notice=notice+string("We were unable to 'Supersede' our test article\n");

# Test cancel

if (superseded) { msgid = supid; }

canid = nntp_make_id(str:"cancel");

can = string(
	"Newsgroups: ", testNGlist, "\r\n",
	"Subject: cmsg cancel ", msgid, "\r\n",
	"From: ", fromaddr, "\r\n",
	"Message-ID: ", canid, "\r\n",
	"Control: cancel ", msgid, "\r\n", 
	more_headers,
	"Content-Type: text/plain; charset: us-ascii\r\n",
	"Lines: 1\r\n",
	"\r\n",
	"Test message (cancel). Please ignore.\r\n",
	".\r\n");	

s = nntp_connect(port:port, username: user, password: pass);
if (s) {
 posted = nntp_post(socket: s, message: can);
 send(socket:s, data: string("QUIT\r\n"));
 close(s);
}

cancel = 0;
if (! nntp_article(id: msgid, timeout: 10, username: user, password:pass)) { cancel = 1; }

if (! cancel)
  notice=notice+string("We were unable to 'Cancel' our test article\n");

if (notice)
  security_note(port: port, data: notice);
