


if(description)
{
 script_id(11161);
 script_version ("$Revision: 1.1.2.3 $");
 script_cve_id("CAN-2002-1142");



 name["english"] = "RDS / MDAC Vulnerability Content-Type overflow";

  
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote DLL /msadc/msadcs.dll is accessible by anyone. 
Several flaws have been found in it in the past, we recommand
you restrict access to MSADC only to trusted hosts.

*** Nessus did not test for any security vulnerability
*** but solely relied on the presence of this resource
*** to issue this warning

Solution: 
  - Launch the Internet Services Manager
  - Select your web server
  - Right-click on MSADC and select 'Properties'
  - Select the tab 'Directory Security'
  - Click on the 'IP address and domain name restrictions'
    option
  - Make sure that by default, all computers are DENIED access
    to this resource
  - List the computers that should be allowed to use it
  
See also: MS advisory MS02-065
Risk factor: High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of msadcs.dll";


 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison");
 

 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";

 script_family(english:family["english"], francais:family["francais"]);
 
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

req = string("POST /msadc/msadcs.dll HTTP/1.1\r\n",
"Host: ", get_host_name(), "\r\n",
"Content-Type: text/plain\r\n",
"Content-Length: 1\r\n\r\nX");

port = get_kb_item("Services/www");
if(!port) port = 80;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(!soc)exit(0);
 send(socket:soc, data:req);
 headers = http_recv_headers(soc);
 body = recv(socket:soc, length:4096);
 close(soc);
 z = string(headers, body);
 if(!z)exit(0);
 if("Content-Type: application/x-varg" >< z)security_hole(port);
}
